/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.AbstractDeeplingServant;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.DeeplingBruteServant;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class DeeplingBruteSpell
extends SummonSpell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.DeeplingBruteCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.DeeplingBruteDuration.get();
    }

    public int SummonDownDuration() {
        return (Integer)GCSpellConfig.DeeplingBruteSummonDown.get();
    }

    public SoundEvent CastingSound() {
        return (SoundEvent)GoetySounds.ABYSS_PREPARE_SPELL.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.DeeplingBruteCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof DeeplingBruteServant;
    }

    public int summonLimit() {
        return (Integer)GCSpellConfig.DeeplingBruteLimit.get();
    }

    public void commonResult(ServerLevel worldIn, LivingEntity caster) {
        if (this.isShifting(caster)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof DeeplingBruteServant)) continue;
                this.teleportServants(caster, entity);
            }
            for (int i = 0; i < caster.m_9236_().f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.playSound(worldIn, (Entity)caster, (SoundEvent)GoetySounds.DROWNED_NECROMANCER_SUMMON.get());
        }
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getPotencyLevel((LivingEntity)caster);
            duration += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.DURATION.get()), (LivingEntity)caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 1;
            if (this.rightStaff(staff)) {
                i = 2 + caster.m_9236_().f_46441_.m_188503_(4);
            }
            for (int i1 = 0; i1 < i; ++i1) {
                DeeplingBruteServant summonedentity = new DeeplingBruteServant((EntityType<? extends AbstractDeeplingServant>)((EntityType)GCEntityType.DEEPLING_BRUTE.get()), (Level)worldIn);
                BlockPos blockPos = BlockFinder.SummonRadius((BlockPos)caster.m_20183_(), (Entity)summonedentity, (Level)worldIn);
                if (caster.m_5842_()) {
                    blockPos = BlockFinder.SummonWaterRadius((LivingEntity)caster, (Level)worldIn);
                }
                summonedentity.setTrueOwner(caster);
                summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                if (!caster.m_5842_()) {
                    MobUtil.moveDownToGround((Entity)summonedentity);
                }
                summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                summonedentity.m_21530_();
                summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.m_9236_().m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                if (potency > 0) {
                    int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
                    summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost, false, false));
                }
                this.SummonSap(caster, (LivingEntity)summonedentity);
                this.setTarget(caster, (Mob)summonedentity);
                worldIn.m_7967_((Entity)summonedentity);
                this.summonAdvancement(caster, (LivingEntity)summonedentity);
            }
            this.SummonDown(caster);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)GoetySounds.DROWNED_NECROMANCER_SUMMON.get());
        }
    }
}

