/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.construct;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.research.Research;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.goety_cataclysm.common.blocks.GCBlocks;
import com.Polarice3.goety_cataclysm.common.blocks.GoetyBlocks;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.NetheriteMonstrosityServant;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class NetheriteMonstrosityMold
implements IMold {
    private static final List<BlockPos> BOTTOM_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 2), (Object)new BlockPos(0, -1, 3), (Object)new BlockPos(0, -1, 4), (Object)new BlockPos(0, -1, -2), (Object)new BlockPos(0, -1, -3), (Object)new BlockPos(0, -1, -4), (Object)new BlockPos(1, -1, 1), (Object)new BlockPos(1, -1, -1), (Object)new BlockPos(1, -1, 2), (Object)new BlockPos(1, -1, -2), (Object)new BlockPos(1, -1, 3), (Object[])new BlockPos[]{new BlockPos(1, -1, -3), new BlockPos(1, -1, 5), new BlockPos(1, -1, -5), new BlockPos(-1, -1, 1), new BlockPos(-1, -1, -1), new BlockPos(-1, -1, 2), new BlockPos(-1, -1, -2), new BlockPos(-1, -1, 3), new BlockPos(-1, -1, -3), new BlockPos(-1, -1, 5), new BlockPos(-1, -1, -5), new BlockPos(2, -1, 0), new BlockPos(2, -1, 1), new BlockPos(2, -1, -1), new BlockPos(2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(2, -1, 3), new BlockPos(2, -1, -3), new BlockPos(2, -1, 4), new BlockPos(2, -1, -4), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, 1), new BlockPos(-2, -1, -1), new BlockPos(-2, -1, 2), new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 3), new BlockPos(-2, -1, -3), new BlockPos(-2, -1, 4), new BlockPos(-2, -1, -4), new BlockPos(3, -1, 0), new BlockPos(3, -1, 1), new BlockPos(3, -1, -1), new BlockPos(3, -1, 2), new BlockPos(3, -1, -2), new BlockPos(3, -1, 3), new BlockPos(3, -1, -3), new BlockPos(3, -1, 4), new BlockPos(3, -1, -4), new BlockPos(-3, -1, 0), new BlockPos(-3, -1, 1), new BlockPos(-3, -1, -1), new BlockPos(-3, -1, 2), new BlockPos(-3, -1, -2), new BlockPos(-3, -1, 3), new BlockPos(-3, -1, -3), new BlockPos(-3, -1, 4), new BlockPos(-3, -1, -4), new BlockPos(4, -1, 0), new BlockPos(4, -1, 2), new BlockPos(4, -1, -2), new BlockPos(4, -1, 3), new BlockPos(4, -1, -3), new BlockPos(-4, -1, 0), new BlockPos(-4, -1, 2), new BlockPos(-4, -1, -2), new BlockPos(-4, -1, 3), new BlockPos(-4, -1, -3), new BlockPos(5, -1, 1), new BlockPos(5, -1, -1), new BlockPos(-5, -1, 1), new BlockPos(-5, -1, -1)});
    private static final List<BlockPos> ABOVE_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, 0, 6), (Object)new BlockPos(1, 0, -6), (Object)new BlockPos(3, 0, 5), (Object)new BlockPos(3, 0, -5), (Object)new BlockPos(-3, 0, 5), (Object)new BlockPos(-3, 0, -5), (Object)new BlockPos(5, 0, 3), (Object)new BlockPos(5, 0, -3), (Object)new BlockPos(-5, 0, 3), (Object)new BlockPos(-5, 0, -3), (Object)new BlockPos(6, 0, 1), (Object)new BlockPos(6, 0, -1), (Object[])new BlockPos[]{new BlockPos(-6, 0, 1), new BlockPos(-6, 0, -1)});
    private static final List<BlockPos> STONE_LOCATIONS = Stream.of(BOTTOM_STONE_LOCATIONS, ABOVE_STONE_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> BOTTOM_GOLD_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(0, -1, 5), (Object)new BlockPos(0, -1, -5), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(1, -1, 4), (Object)new BlockPos(1, -1, -4), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(-1, -1, 4), (Object)new BlockPos(-1, -1, -4), (Object)new BlockPos(2, -1, 5), (Object)new BlockPos(2, -1, -5), (Object[])new BlockPos[]{new BlockPos(-2, -1, 5), new BlockPos(-2, -1, -5), new BlockPos(4, -1, 1), new BlockPos(4, -1, -1), new BlockPos(-4, -1, 1), new BlockPos(-4, -1, -1), new BlockPos(5, -1, 0), new BlockPos(5, -1, 2), new BlockPos(5, -1, -2), new BlockPos(-5, -1, 0), new BlockPos(-5, -1, 2), new BlockPos(-5, -1, -2)});
    private static final List<BlockPos> ABOVE_GOLD_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 6), (Object)new BlockPos(0, 0, -6), (Object)new BlockPos(2, 0, 6), (Object)new BlockPos(2, 0, -6), (Object)new BlockPos(-2, 0, 6), (Object)new BlockPos(-2, 0, -6), (Object)new BlockPos(4, 0, 4), (Object)new BlockPos(4, 0, -4), (Object)new BlockPos(-4, 0, 4), (Object)new BlockPos(-4, 0, -4), (Object)new BlockPos(6, 0, 0), (Object)new BlockPos(6, 0, 2), (Object[])new BlockPos[]{new BlockPos(6, 0, -2), new BlockPos(-6, 0, 0), new BlockPos(-6, 0, 2), new BlockPos(-6, 0, -2)});
    private static final List<BlockPos> GOLD_LOCATIONS = Stream.of(BOTTOM_GOLD_LOCATIONS, ABOVE_GOLD_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> BOTTOM_SOUL_FIRE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 6), (Object)new BlockPos(0, -1, -6), (Object)new BlockPos(1, -1, 6), (Object)new BlockPos(1, -1, -6), (Object)new BlockPos(-1, -1, 6), (Object)new BlockPos(-1, -1, -6), (Object)new BlockPos(2, -1, 6), (Object)new BlockPos(2, -1, -6), (Object)new BlockPos(-2, -1, 6), (Object)new BlockPos(-2, -1, -6), (Object)new BlockPos(3, -1, 5), (Object)new BlockPos(3, -1, -5), (Object[])new BlockPos[]{new BlockPos(-3, -1, 5), new BlockPos(-3, -1, -5), new BlockPos(4, -1, 4), new BlockPos(4, -1, -4), new BlockPos(-4, -1, 4), new BlockPos(-4, -1, -4), new BlockPos(5, -1, 3), new BlockPos(5, -1, -3), new BlockPos(-5, -1, 3), new BlockPos(-5, -1, -3), new BlockPos(6, -1, 0), new BlockPos(6, -1, 1), new BlockPos(6, -1, -1), new BlockPos(6, -1, 2), new BlockPos(6, -1, -2), new BlockPos(-6, -1, 0), new BlockPos(-6, -1, 1), new BlockPos(-6, -1, -1), new BlockPos(-6, -1, 2), new BlockPos(-6, -1, -2)});
    private static final List<BlockPos> ABOVE_SOUL_FIRE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 7), (Object)new BlockPos(0, 0, -7), (Object)new BlockPos(1, 0, 7), (Object)new BlockPos(1, 0, -7), (Object)new BlockPos(-1, 0, 7), (Object)new BlockPos(-1, 0, -7), (Object)new BlockPos(2, 0, 7), (Object)new BlockPos(2, 0, -7), (Object)new BlockPos(-2, 0, 7), (Object)new BlockPos(-2, 0, -7), (Object)new BlockPos(3, 0, 6), (Object)new BlockPos(3, 0, -6), (Object[])new BlockPos[]{new BlockPos(-3, 0, 6), new BlockPos(-3, 0, -6), new BlockPos(4, 0, 5), new BlockPos(4, 0, -5), new BlockPos(-4, 0, 5), new BlockPos(-4, 0, -5), new BlockPos(5, 0, 4), new BlockPos(5, 0, -4), new BlockPos(-5, 0, 4), new BlockPos(-5, 0, -4), new BlockPos(6, 0, 3), new BlockPos(6, 0, -3), new BlockPos(-6, 0, 3), new BlockPos(-6, 0, -3), new BlockPos(7, 0, 0), new BlockPos(7, 0, 1), new BlockPos(7, 0, -1), new BlockPos(7, 0, 2), new BlockPos(7, 0, -2), new BlockPos(-7, 0, 0), new BlockPos(-7, 0, 1), new BlockPos(-7, 0, -1), new BlockPos(-7, 0, 2), new BlockPos(-7, 0, -2)});
    private static final List<BlockPos> SOUL_FIRE_LOCATIONS = Stream.of(BOTTOM_SOUL_FIRE_LOCATIONS, ABOVE_SOUL_FIRE_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> REDSTONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 1), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(-1, 0, -1));
    private static final List<BlockPos> NETHER_BRICKS_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 3), (Object)new BlockPos(0, 0, -3), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(-3, 0, 0), (Object)new BlockPos(1, 0, 3), (Object)new BlockPos(1, 0, -3), (Object)new BlockPos(-1, 0, 3), (Object)new BlockPos(-1, 0, -3), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(3, 0, -1), (Object)new BlockPos(-3, 0, 1), (Object)new BlockPos(-3, 0, -1), (Object[])new BlockPos[]{new BlockPos(2, 0, 2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, 2), new BlockPos(-2, 0, -2)});
    private static final List<BlockPos> NETHERITE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 2), (Object)new BlockPos(0, 0, -2), (Object)new BlockPos(2, 0, 0), (Object)new BlockPos(-2, 0, 0), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(1, 0, -2), (Object)new BlockPos(2, 0, 1), (Object)new BlockPos(-2, 0, 1), (Object)new BlockPos(-1, 0, 2), (Object)new BlockPos(-1, 0, -2), (Object)new BlockPos(2, 0, -1), (Object)new BlockPos(-2, 0, -1), (Object[])new BlockPos[0]);
    private static final List<BlockPos> GILDED_BLACKSTONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 4), (Object)new BlockPos(0, 0, -4), (Object)new BlockPos(4, 0, 0), (Object)new BlockPos(-4, 0, 0), (Object)new BlockPos(1, 0, 4), (Object)new BlockPos(1, 0, -4), (Object)new BlockPos(4, 0, 1), (Object)new BlockPos(-4, 0, 1), (Object)new BlockPos(-1, 0, 4), (Object)new BlockPos(-1, 0, -4), (Object)new BlockPos(4, 0, -1), (Object)new BlockPos(-4, 0, -1), (Object[])new BlockPos[]{new BlockPos(2, 0, 3), new BlockPos(2, 0, -3), new BlockPos(3, 0, 2), new BlockPos(-3, 0, 2), new BlockPos(-2, 0, 3), new BlockPos(-2, 0, -3), new BlockPos(3, 0, -2), new BlockPos(-3, 0, -2)});
    private static final List<BlockPos> LAVA_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 5), (Object)new BlockPos(0, 0, -5), (Object)new BlockPos(5, 0, 0), (Object)new BlockPos(-5, 0, 0), (Object)new BlockPos(1, 0, 5), (Object)new BlockPos(1, 0, -5), (Object)new BlockPos(5, 0, 1), (Object)new BlockPos(-5, 0, 1), (Object)new BlockPos(-1, 0, 5), (Object)new BlockPos(-1, 0, -5), (Object)new BlockPos(5, 0, -1), (Object)new BlockPos(-5, 0, -1), (Object[])new BlockPos[]{new BlockPos(2, 0, 5), new BlockPos(2, 0, -5), new BlockPos(5, 0, 2), new BlockPos(-5, 0, 2), new BlockPos(-2, 0, 5), new BlockPos(-2, 0, -5), new BlockPos(5, 0, -2), new BlockPos(-5, 0, -2), new BlockPos(2, 0, 4), new BlockPos(2, 0, -4), new BlockPos(4, 0, 2), new BlockPos(-4, 0, 2), new BlockPos(-2, 0, 4), new BlockPos(-2, 0, -4), new BlockPos(4, 0, -2), new BlockPos(-4, 0, -2), new BlockPos(3, 0, 4), new BlockPos(3, 0, -4), new BlockPos(4, 0, 3), new BlockPos(-4, 0, 3), new BlockPos(-3, 0, 4), new BlockPos(-3, 0, -4), new BlockPos(4, 0, -3), new BlockPos(-4, 0, -3), new BlockPos(3, 0, 3), new BlockPos(3, 0, -3), new BlockPos(-3, 0, 3), new BlockPos(-3, 0, -3)});
    private static final BlockPos CORE = new BlockPos(0, 0, 0);

    private static List<BlockPos> checkStones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : STONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (!blockState.m_60734_().m_7705_().contains("blackstone") && !blockState.m_60713_(Blocks.f_50706_)) {
                invalid.add(blockPos1);
            }
            if (blockState.m_60838_((BlockGetter)level, blockPos2)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkGold(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : GOLD_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(Tags.Blocks.STORAGE_BLOCKS_GOLD)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkSoulFire(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : SOUL_FIRE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50084_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkRedstone(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : REDSTONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkNetherBricks(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : NETHER_BRICKS_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50197_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkNetherite(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : NETHERITE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)GCBlocks.NETHERITE_PLATING.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkGilded(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : GILDED_BLACKSTONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_50706_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkLava(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : LAVA_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (!level.m_6425_(blockPos2).m_205070_(FluidTags.f_13132_)) {
                invalid.add(blockPos1);
            }
            if (level.m_6425_(blockPos2).m_76170_()) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public static boolean checkBlocks(Level level, BlockPos blockPos) {
        return NetheriteMonstrosityMold.checkStones(level, blockPos).isEmpty() && NetheriteMonstrosityMold.checkGold(level, blockPos).isEmpty() && NetheriteMonstrosityMold.checkSoulFire(level, blockPos).isEmpty() && NetheriteMonstrosityMold.checkRedstone(level, blockPos).isEmpty() && NetheriteMonstrosityMold.checkNetherBricks(level, blockPos).isEmpty() && NetheriteMonstrosityMold.checkNetherite(level, blockPos).isEmpty() && NetheriteMonstrosityMold.checkLava(level, blockPos).isEmpty();
    }

    public boolean conditionsMet(Level worldIn, LivingEntity entityLiving) {
        int count = 0;
        int global = 0;
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            for (Entity entity : serverLevel.m_8583_()) {
                if (!(entity instanceof NetheriteMonstrosityServant)) continue;
                NetheriteMonstrosityServant servant = (NetheriteMonstrosityServant)entity;
                if (servant.getTrueOwner() == entityLiving && servant.m_6084_()) {
                    ++count;
                }
                ++global;
            }
        }
        return count < (Integer)SpellConfig.RedstoneMonstrosityPlayerLimit.get() && global < (Integer)SpellConfig.RedstoneMonstrosityGlobalLimit.get();
    }

    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60713_((Block)GoetyBlocks.REINFORCED_REDSTONE_BLOCK.get())) {
            if (NetheriteMonstrosityMold.checkBlocks(level, blockPos)) {
                if (SEHelper.hasResearch((Player)player, (Research)ResearchList.TERMINUS)) {
                    if (this.conditionsMet(level, (LivingEntity)player)) {
                        NetheriteMonstrosityServant monstrosity = (NetheriteMonstrosityServant)((EntityType)GCEntityType.NETHERITE_MONSTROSITY.get()).m_20615_(level);
                        if (monstrosity != null) {
                            monstrosity.setTrueOwner((LivingEntity)player);
                            monstrosity.m_6518_((ServerLevelAccessor)level, level.m_6436_(monstrosity.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            monstrosity.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                            if (level.m_7967_((Entity)monstrosity)) {
                                NetheriteMonstrosityMold.removeBlocks(level, blockPos);
                                stack.m_41774_(1);
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)monstrosity);
                                }
                                return true;
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.research.fail"), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.block.fail"), true);
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            BlockPos blockPos2;
            for (BlockPos blockPos1 : SOUL_FIRE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50084_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : REDSTONE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_204336_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : NETHER_BRICKS_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50197_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : NETHERITE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_((Block)GCBlocks.NETHERITE_PLATING.get())) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : GILDED_BLACKSTONE_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_50706_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            for (BlockPos blockPos1 : LAVA_LOCATIONS) {
                blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_6425_(blockPos2).m_205070_(FluidTags.f_13132_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            BlockPos blockPos22 = blockPos.m_121955_((Vec3i)CORE);
            if (level.m_8055_(blockPos22).m_60713_((Block)GoetyBlocks.REINFORCED_REDSTONE_BLOCK.get())) {
                level.m_46796_(2001, blockPos22, Block.m_49956_((BlockState)level.m_8055_(blockPos22)));
                level.m_46597_(blockPos22, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

