/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.construct;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.research.Research;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.goety_cataclysm.common.blocks.CataclysmBlocks;
import com.Polarice3.goety_cataclysm.common.blocks.GCBlocks;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.EnderGolemServant;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GCTags;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EnderGolemMold
implements IMold {
    private static final List<BlockPos> BOTTOM_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(1, -1, 1), (Object)new BlockPos(1, -1, -1), (Object)new BlockPos(-1, -1, 1), (Object)new BlockPos(-1, -1, -1), (Object)new BlockPos(2, -1, 1), (Object)new BlockPos(2, -1, -1), (Object)new BlockPos(-2, -1, 1), (Object[])new BlockPos[]{new BlockPos(-2, -1, -1), new BlockPos(1, -1, 2), new BlockPos(-1, -1, 2), new BlockPos(1, -1, -2), new BlockPos(-1, -1, -2)});
    private static final List<BlockPos> ABOVE_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, 0, 3), (Object)new BlockPos(-1, 0, 3), (Object)new BlockPos(1, 0, -3), (Object)new BlockPos(-1, 0, -3), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(3, 0, -1), (Object)new BlockPos(-3, 0, 1), (Object)new BlockPos(-3, 0, -1));
    private static final List<BlockPos> STONE_LOCATIONS = Stream.of(BOTTOM_STONE_LOCATIONS, ABOVE_STONE_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> BOTTOM_DIAMOND_LOCATIONS = ImmutableList.of((Object)new BlockPos(2, -1, 0), (Object)new BlockPos(-2, -1, 0), (Object)new BlockPos(0, -1, 2), (Object)new BlockPos(0, -1, -2));
    private static final List<BlockPos> ABOVE_DIAMOND_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 3), (Object)new BlockPos(0, 0, -3), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(-3, 0, 0), (Object)new BlockPos(-2, 0, 2), (Object)new BlockPos(2, 0, 2), (Object)new BlockPos(2, 0, -2), (Object)new BlockPos(-2, 0, -2));
    private static final List<BlockPos> DIAMOND_LOCATIONS = Stream.of(BOTTOM_DIAMOND_LOCATIONS, ABOVE_DIAMOND_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> LAVA_LOCATIONS = ImmutableList.of((Object)new BlockPos(3, -1, 1), (Object)new BlockPos(3, -1, 0), (Object)new BlockPos(3, -1, -1), (Object)new BlockPos(-3, -1, 1), (Object)new BlockPos(-3, -1, 0), (Object)new BlockPos(-3, -1, -1), (Object)new BlockPos(1, -1, 3), (Object)new BlockPos(0, -1, 3), (Object)new BlockPos(-1, -1, 3), (Object)new BlockPos(1, -1, -3), (Object)new BlockPos(0, -1, -3), (Object)new BlockPos(-1, -1, -3), (Object[])new BlockPos[]{new BlockPos(-2, -1, 2), new BlockPos(2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(-2, -1, -2), new BlockPos(4, 0, 1), new BlockPos(4, 0, 0), new BlockPos(4, 0, -1), new BlockPos(1, 0, 4), new BlockPos(0, 0, 4), new BlockPos(-1, 0, 4), new BlockPos(-4, 0, 1), new BlockPos(-4, 0, 0), new BlockPos(-4, 0, -1), new BlockPos(1, 0, -4), new BlockPos(0, 0, -4), new BlockPos(-1, 0, -4), new BlockPos(3, 0, 2), new BlockPos(3, 0, -2), new BlockPos(-3, 0, 2), new BlockPos(-3, 0, -2), new BlockPos(2, 0, 3), new BlockPos(2, 0, -3), new BlockPos(-2, 0, 3), new BlockPos(-2, 0, -3)});
    private static final List<BlockPos> VOID_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(-1, 0, -1), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(-1, 0, 2), (Object[])new BlockPos[]{new BlockPos(0, 0, -2), new BlockPos(1, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(2, 0, 0), new BlockPos(2, 0, 1), new BlockPos(2, 0, -1), new BlockPos(-2, 0, 0), new BlockPos(-2, 0, 1), new BlockPos(-2, 0, -1)});

    private static List<BlockPos> checkStones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : STONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (!blockState.m_204336_(GCTags.Blocks.ENDER_GOLEM_OBSIDIAN_MOLD)) {
                invalid.add(blockPos1);
            }
            if (blockState.m_60838_((BlockGetter)level, blockPos2)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkDiamonds(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : DIAMOND_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)GCBlocks.VOID_MOLD_BLOCK.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkLava(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : LAVA_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_49991_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkVoidStones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : VOID_STONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_((Block)CataclysmBlocks.VOID_STONE.get())) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public static boolean checkBlocks(Level level, BlockPos blockPos) {
        return EnderGolemMold.checkStones(level, blockPos).isEmpty() && EnderGolemMold.checkDiamonds(level, blockPos).isEmpty() && EnderGolemMold.checkVoidStones(level, blockPos).isEmpty();
    }

    public static boolean conditionsMet(Level worldIn, LivingEntity entityLiving) {
        int count = 0;
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            for (Entity entity : serverLevel.m_8583_()) {
                EnderGolemServant servant;
                if (!(entity instanceof EnderGolemServant) || (servant = (EnderGolemServant)entity).getTrueOwner() != entityLiving || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count < (Integer)GCSpellConfig.EnderGolemLimit.get();
    }

    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60713_((Block)CataclysmBlocks.VOID_STONE.get())) {
            if (EnderGolemMold.checkBlocks(level, blockPos)) {
                if (SEHelper.hasResearch((Player)player, (Research)ResearchList.WARRED)) {
                    if (EnderGolemMold.conditionsMet(level, (LivingEntity)player)) {
                        EnderGolemServant enderGolemServant = (EnderGolemServant)((EntityType)GCEntityType.ENDER_GOLEM.get()).m_20615_(level);
                        if (enderGolemServant != null) {
                            enderGolemServant.setTrueOwner((LivingEntity)player);
                            enderGolemServant.m_6518_((ServerLevelAccessor)level, level.m_6436_(enderGolemServant.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            enderGolemServant.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                            if (level.m_7967_((Entity)enderGolemServant)) {
                                EnderGolemMold.removeBlocks(level, blockPos);
                                stack.m_41774_(1);
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)enderGolemServant);
                                }
                                return true;
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.research.fail"), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.block.fail"), true);
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            for (BlockPos blockPos1 : VOID_STONE_LOCATIONS) {
                BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                if (!level.m_8055_(blockPos2).m_60713_((Block)CataclysmBlocks.VOID_STONE.get())) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
        }
    }
}

