/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.common.entities.projectiles.SpellThrowableProjectile;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.github.L_Ender.cataclysm.client.particle.LightTrailParticle;
import com.github.L_Ender.cataclysm.entity.projectile.Flame_Jet_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class FlareBomb
extends SpellThrowableProjectile {
    public double prevDeltaMovementX;
    public double prevDeltaMovementY;
    public double prevDeltaMovementZ;

    public FlareBomb(EntityType<? extends FlareBomb> type, Level world) {
        super(type, world);
    }

    public FlareBomb(EntityType<? extends FlareBomb> type, Level world, LivingEntity thrower) {
        super(type, thrower, world);
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.FLARE_BOMB.get()).m_20676_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        LivingEntity shooter = this.getOwner();
        Entity entity = result.m_82443_();
        if (!this.m_9236_().f_46443_ && !MobUtil.areAllies((Entity)shooter, (Entity)entity)) {
            float damage = ((Double)GCSpellConfig.FlareBombDamage.get()).floatValue() * WandUtil.damageMultiply() + this.getExtraDamage();
            if (shooter instanceof LivingEntity) {
                LivingEntity livingentity = shooter;
                boolean flag = entity.m_6469_(this.m_269291_().m_269299_((Entity)this, livingentity), damage);
                if (flag && entity.m_6084_()) {
                    entity.m_20254_(5);
                    this.m_19970_(livingentity, entity);
                }
            } else {
                entity.m_6469_(this.m_269291_().m_269425_(), damage);
            }
        }
    }

    protected void m_6532_(HitResult p_37628_) {
        super.m_6532_(p_37628_);
        if (!this.m_9236_().f_46443_) {
            this.m_5496_(SoundEvents.f_11909_, 1.5f, 0.75f);
            this.m_9236_().m_7605_((Entity)this, (byte)4);
            if (this.f_19796_.m_188499_()) {
                this.XStrikeJet(10, 2.0);
            } else {
                this.PlusStrikeJet(10, 2.0);
            }
            this.m_146870_();
        }
    }

    protected void PlusStrikeJet(int rune, double time) {
        for (int i = 0; i < 4; ++i) {
            float yawRadians = (float)Math.toRadians(90.0f + this.m_146908_());
            float throwAngle = yawRadians + (float)i * (float)Math.PI / 2.0f;
            for (int k = 0; k < rune; ++k) {
                double d2 = 0.8 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                this.spawnjet(this.m_20185_() + (double)Mth.m_14089_((float)throwAngle) * 1.25 * d2, this.m_20189_() + (double)Mth.m_14031_((float)throwAngle) * 1.25 * d2, this.m_20186_() - 2.0, this.m_20186_() + 2.0, throwAngle, d3);
            }
        }
    }

    protected void XStrikeJet(int rune, double time) {
        for (int i = 0; i < 4; ++i) {
            float yawRadians = (float)Math.toRadians(45.0f + this.m_146908_());
            float throwAngle = yawRadians + (float)i * (float)Math.PI / 2.0f;
            for (int k = 0; k < rune; ++k) {
                double d2 = 0.8 * (double)(k + 1);
                int d3 = (int)(time * (double)(k + 1));
                this.spawnjet(this.m_20185_() + (double)Mth.m_14089_((float)throwAngle) * 1.25 * d2, this.m_20189_() + (double)Mth.m_14031_((float)throwAngle) * 1.25 * d2, this.m_20186_() - 2.0, this.m_20186_() + 2.0, throwAngle, d3);
            }
        }
    }

    protected void spawnjet(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            float damage = ((Double)GCSpellConfig.FlareBombDamage.get()).floatValue() * WandUtil.damageMultiply() + this.getExtraDamage();
            if (this.getOwner() != null) {
                this.m_9236_().m_7967_((Entity)new Flame_Jet_Entity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, damage, this.getOwner()));
            } else {
                this.m_9236_().m_7967_((Entity)new Flame_Jet_Entity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, damage, null));
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevDeltaMovementX = this.m_20184_().f_82479_;
        this.prevDeltaMovementY = this.m_20184_().f_82480_;
        this.prevDeltaMovementZ = this.m_20184_().f_82481_;
        this.m_146922_(-((float)Mth.m_14136_((double)this.m_20184_().f_82479_, (double)this.m_20184_().f_82481_)) * 57.295776f);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double dx = this.m_20185_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dy = this.m_20186_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            double dz = this.m_20189_() + (double)(1.5f * (this.f_19796_.m_188501_() - 0.5f));
            float ran = 0.04f;
            float r = 0.7647059f + this.f_19796_.m_188501_() * ran * 1.5f;
            float g = 0.37254903f + this.f_19796_.m_188501_() * ran;
            float b = 0.011764706f + this.f_19796_.m_188501_() * ran;
            serverLevel.m_8767_((ParticleOptions)new LightTrailParticle.OrbData(r, g, b, 0.1f, this.m_20206_() / 2.0f, this.m_19879_()), dx, dy, dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.m_9236_().f_46441_.m_188501_() - this.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
            this.m_9236_().m_7106_((ParticleOptions)ModParticle.FLARE_EXPLODE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.m_188583_() * 0.05, 0.005, this.f_19796_.m_188583_() * 0.05);
        }
    }

    protected boolean m_5603_(Entity pEntity) {
        if (this.getOwner() != null) {
            Projectile projectile;
            Mob mob;
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5448_() == pEntity) {
                return super.m_5603_(pEntity);
            }
            if (MobUtil.areAllies((Entity)this.getOwner(), (Entity)pEntity)) {
                return false;
            }
            if (this.getOwner() instanceof Enemy && pEntity instanceof Enemy) {
                return false;
            }
            if (pEntity instanceof Projectile && (projectile = (Projectile)pEntity).m_19749_() == this.getOwner()) {
                return false;
            }
            if (pEntity instanceof IOwned) {
                IOwned owned0 = (IOwned)pEntity;
                LivingEntity livingEntity2 = this.getOwner();
                if (livingEntity2 instanceof IOwned) {
                    IOwned owned1 = (IOwned)livingEntity2;
                    return !MobUtil.ownerStack((IOwned)owned0, (IOwned)owned1);
                }
            }
        }
        return super.m_5603_(pEntity);
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected float getGravity() {
        return 0.025f;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

