/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.neutral;

import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.AbstractSkeletonServant;
import com.Polarice3.Goety.common.entities.neutral.AbstractNecromancer;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.config.MobsConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SoundUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.InternalAnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr.DraugrServant;
import com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr.EliteDraugrServant;
import com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr.RoyalDraugrServant;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.PhantomArrow;
import com.Polarice3.goety_cataclysm.common.items.GCItems;
import com.Polarice3.goety_cataclysm.common.items.GoetyItems;
import com.Polarice3.goety_cataclysm.common.items.revive.DraugrSoulJar;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class AbstractDraugrNecromancer
extends AbstractNecromancer {
    public int attackTick;

    public AbstractDraugrNecromancer(EntityType<? extends AbstractSkeletonServant> type, Level level) {
        super(type, level);
    }

    public void projectileGoal(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new AbstractNecromancer.NecromancerRangedGoal((AbstractNecromancer)this, 1.0, 30, 10.0f));
    }

    public void summonSpells(int priority) {
        this.f_21345_.m_25352_(priority, (Goal)new SummonServantSpell());
        this.f_21345_.m_25352_(priority + 1, (Goal)new AbstractNecromancer.SummonUndeadGoal(){

            protected void populateDefaultEquipmentSlots(LivingEntity livingEntity, RandomSource p_217055_) {
            }
        });
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.DraugrNecromancerHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.DraugrNecromancerArmor.get()).doubleValue()).m_22268_(Attributes.f_22277_, ((Double)GCAttributesConfig.DraugrNecromancerFollowRange.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.6).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.DraugrNecromancerDamage.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.DraugrNecromancerHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.DraugrNecromancerArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22277_), (double)((Double)GCAttributesConfig.DraugrNecromancerFollowRange.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.DraugrNecromancerDamage.get()));
    }

    public void soulJar() {
        LivingEntity livingEntity = this.getTrueOwner();
        if (livingEntity instanceof Player) {
            ItemStack original;
            Optional<ItemStack> optional;
            Player player = (Player)livingEntity;
            if (((Boolean)MobsConfig.NecromancerSoulJar.get()).booleanValue() && (optional = player.m_150109_().f_35974_.stream().filter(itemStack1 -> itemStack1.m_150930_((Item)GoetyItems.EMPTY_SOUL_JAR.get())).findFirst()).isPresent() && (original = optional.get()).m_150930_((Item)GoetyItems.EMPTY_SOUL_JAR.get())) {
                if (!player.m_7500_()) {
                    original.m_41774_(1);
                }
                ItemStack itemStack = new ItemStack((ItemLike)GCItems.SOUL_JAR_DRAUGR.get());
                DraugrSoulJar.setOwnerName((LivingEntity)this.getTrueOwner(), (ItemStack)itemStack);
                DraugrSoulJar.setSummon((Entity)this, (ItemStack)itemStack);
                SEHelper.addCooldown((Player)player, (Item)((Item)GoetyItems.SOUL_JAR.get()), (int)MathHelper.secondsToTicks((int)30));
                SEHelper.addCooldown((Player)player, (Item)itemStack.m_41720_(), (int)MathHelper.secondsToTicks((int)30));
                if (!player.m_150109_().m_36054_(itemStack)) {
                    player.m_7197_(itemStack, false, true);
                }
            }
        }
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        if (p_33317_ != null) {
            if (this.getNecroLevel() <= 0) {
                PhantomArrow arrow = new PhantomArrow(this.m_9236_(), (LivingEntity)this, p_33317_);
                double d0 = p_33317_.m_20185_() - this.m_20185_();
                double d1 = p_33317_.m_20227_(0.3333333333333333) - arrow.m_20186_();
                double d2 = p_33317_.m_20189_() - this.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
                arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 1.0f);
                if (this.m_9236_().m_7967_((Entity)arrow)) {
                    this.m_216990_((SoundEvent)CataclysmSounds.STRONGSWING.get());
                    this.m_6674_(InteractionHand.MAIN_HAND);
                }
            } else {
                for (int i = -this.getNecroLevel(); i <= this.getNecroLevel(); ++i) {
                    Vec3 vector3d = this.m_20252_(1.0f);
                    PhantomArrow arrow = new PhantomArrow(this.m_9236_(), (LivingEntity)this, p_33317_);
                    arrow.m_6686_(vector3d.f_82479_ + (double)((float)i / 10.0f), vector3d.f_82480_, vector3d.f_82481_ + (double)((float)i / 10.0f), 1.6f, 1.0f);
                    if (!this.m_9236_().m_7967_((Entity)arrow)) continue;
                    this.m_216990_((SoundEvent)CataclysmSounds.STRONGSWING.get());
                    this.m_6674_(InteractionHand.MAIN_HAND);
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.getCurrentAnimation() == this.getAnimationState(ATTACK)) {
                ++this.attackTick;
            } else if (this.attackTick > 0) {
                this.attackTick = 0;
            }
            if (this.attackTick >= 20) {
                this.setAnimationState(IDLE);
            }
        }
    }

    protected boolean isSunSensitive() {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.DRAUGR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_IDLE.get();
    }

    public Summoned getDefaultSummon() {
        return new DraugrServant((EntityType<? extends Owned>)((EntityType)GCEntityType.DRAUGR_SERVANT.get()), this.m_9236_());
    }

    public Summoned getSummon() {
        Summoned summoned = this.getDefaultSummon();
        if (this.getSummonList().contains(GCEntityType.DRAUGR_SERVANT.get()) && this.m_9236_().f_46441_.m_188501_() <= 0.75f) {
            summoned = new DraugrServant((EntityType<? extends Owned>)((EntityType)GCEntityType.DRAUGR_SERVANT.get()), this.m_9236_());
        }
        if (this.getSummonList().contains(GCEntityType.ELITE_DRAUGR_SERVANT.get()) && this.m_9236_().f_46441_.m_188499_()) {
            summoned = new EliteDraugrServant((EntityType<? extends InternalAnimationSummon>)((EntityType)GCEntityType.ELITE_DRAUGR_SERVANT.get()), this.m_9236_());
        }
        if (this.getSummonList().contains(GCEntityType.ROYAL_DRAUGR_SERVANT.get()) && this.m_9236_().f_46441_.m_188501_() <= 0.15f) {
            summoned = new RoyalDraugrServant((EntityType<? extends Summoned>)((EntityType)GCEntityType.ROYAL_DRAUGR_SERVANT.get()), this.m_9236_());
        }
        return summoned;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (!this.m_9236_().f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
                if (!this.spawnUndeadIdle() && pHand == InteractionHand.MAIN_HAND && itemstack.m_41619_()) {
                    if (this.idleSpellCool <= 0 && this.getSpellCooldown() <= 0) {
                        this.setUndeadIdle(true);
                    } else {
                        this.m_216990_((SoundEvent)CataclysmSounds.DRAUGR_HURT.get());
                        this.m_9236_().m_7605_((Entity)this, (byte)9);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (item == Items.f_42583_ && this.m_21223_() < this.m_21233_()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.m_5496_(SoundEvents.f_12383_, 1.0f, 1.25f);
                    this.m_5634_(2.0f);
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        for (int i = 0; i < 7; ++i) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(GCEntityType.DRAUGR_SERVANT.get()) && item == GCItems.CURSED_GRAVE_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)GCEntityType.DRAUGR_SERVANT.get());
                    this.m_5496_((SoundEvent)CataclysmSounds.DRAUGR_IDLE.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(GCEntityType.ELITE_DRAUGR_SERVANT.get()) && item == GCItems.CURSED_CAIRN_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)GCEntityType.ELITE_DRAUGR_SERVANT.get());
                    this.m_5496_((SoundEvent)CataclysmSounds.DRAUGR_IDLE.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (!this.getSummonList().contains(GCEntityType.ROYAL_DRAUGR_SERVANT.get()) && item == GCItems.CURSED_TOMB_FOCUS.get()) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.addSummon((EntityType)GCEntityType.ROYAL_DRAUGR_SERVANT.get());
                    this.m_5496_((SoundEvent)CataclysmSounds.DRAUGR_IDLE.get(), 1.0f, 1.5f);
                    return InteractionResult.SUCCESS;
                }
                if (itemstack.m_150930_((Item)GCItems.SOUL_JAR_DRAUGR.get())) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    if (this.getNecroLevel() < 2) {
                        this.setNecroLevel(this.getNecroLevel() + 1);
                    }
                    this.m_5634_(((Double)GCAttributesConfig.DraugrNecromancerHealth.get()).floatValue());
                    Level i = this.m_9236_();
                    if (i instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)i;
                        for (int i2 = 0; i2 < 7; ++i2) {
                            double d0 = this.f_19796_.m_188583_() * 0.02;
                            double d1 = this.f_19796_.m_188583_() * 0.02;
                            double d2 = this.f_19796_.m_188583_() * 0.02;
                            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235898_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                        }
                    }
                    this.m_5496_((SoundEvent)CataclysmSounds.DRAUGR_IDLE.get(), 1.0f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public class SummonServantSpell
    extends AbstractNecromancer.SummoningSpellGoal {
        public SummonServantSpell() {
            super((AbstractNecromancer)AbstractDraugrNecromancer.this);
        }

        public boolean m_8036_() {
            Predicate<Entity> predicate = entity -> {
                IOwned owned;
                return entity.m_6084_() && entity instanceof IOwned && (owned = (IOwned)entity).getTrueOwner() == AbstractDraugrNecromancer.this;
            };
            int i = AbstractDraugrNecromancer.this.m_9236_().m_6443_(LivingEntity.class, AbstractDraugrNecromancer.this.m_20191_().m_82377_(64.0, 16.0, 64.0), predicate).size();
            return super.m_8036_() && i < 6;
        }

        protected void castSpell() {
            Level level = AbstractDraugrNecromancer.this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i1 = 0; i1 < 2; ++i1) {
                    Summoned summonedentity = AbstractDraugrNecromancer.this.getSummon();
                    BlockPos blockPos = BlockFinder.SummonRadius((BlockPos)AbstractDraugrNecromancer.this.m_20183_(), (Entity)summonedentity, (Level)serverLevel);
                    summonedentity.setTrueOwner((LivingEntity)AbstractDraugrNecromancer.this);
                    summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    if (((Boolean)MobsConfig.NecromancerSummonsLife.get()).booleanValue()) {
                        summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)serverLevel));
                    }
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(AbstractDraugrNecromancer.this.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (!serverLevel.m_7967_((Entity)summonedentity)) continue;
                    SoundUtil.playNecromancerSummon((Entity)summonedentity);
                    ColorUtil colorUtil = new ColorUtil(2804175);
                    ServerParticleUtil.windShockwaveParticle((ServerLevel)serverLevel, (ColorUtil)colorUtil, (float)0.1f, (float)0.1f, (float)0.05f, (int)-1, (Vec3)summonedentity.m_20182_());
                    for (int i2 = 0; i2 < serverLevel.m_213780_().m_188503_(10) + 10; ++i2) {
                        serverLevel.m_8767_((ParticleOptions)new MagicSmokeParticle.Option(1552608, 0xFFFFFF, 10 + serverLevel.m_213780_().m_188503_(10), 0.2f), summonedentity.m_20208_(1.5), summonedentity.m_20187_(), summonedentity.m_20262_(1.5), 0, 0.0, 0.0, 0.0, 1.0);
                    }
                }
            }
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
        }

        protected AbstractNecromancer.NecromancerSpellType getNecromancerSpellType() {
            return AbstractNecromancer.NecromancerSpellType.ZOMBIE;
        }

        protected void playLaughSound() {
            AbstractDraugrNecromancer.this.m_5496_((SoundEvent)GoetySounds.NECROMANCER_LAUGH.get(), 2.0f, AbstractDraugrNecromancer.this.m_6100_() - 0.5f);
        }
    }
}

