/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.acropolis;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import com.github.L_Ender.cataclysm.entity.projectile.Urchin_Spike_Entity;
import com.github.L_Ender.cataclysm.init.ModItems;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class UrchinkinServant
extends Summoned {
    boolean searchingForLand;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState rollAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(UrchinkinServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int roll_cooldown = 0;
    public static final int ROLL_COOLDOWN = 80;
    public int attackTicks;
    protected final SemiAquaticPathNavigator waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public UrchinkinServant(EntityType<? extends Summoned> entity, Level world) {
        super(entity, world);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new SemiAquaticPathNavigator((Mob)this, world);
        this.groundNavigation = new GroundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new Roll(this, 0, 1, 0, 40, 12, 5.0f, 13, 30, 50.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal((Summoned)this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.37).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.UrchinkinArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.UrchinkinDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.UrchinkinHealth.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.UrchinkinHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.UrchinkinArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.UrchinkinDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean canUpdateMove() {
        return true;
    }

    public int xpReward() {
        return 5;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof UrchinkinServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.UrchinkinLimit.get();
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.f_21342_ = new UrchinkinSwimControl(this, 4.0f);
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.f_21342_ = new MoveControl((Mob)this);
                this.m_20282_(false);
            }
        }
    }

    protected int m_7302_(int air) {
        return air;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "roll")) {
            return this.rollAnimationState;
        }
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        return Objects.equals(input, "attack") ? this.attackAnimationState : new AnimationState();
    }

    public boolean isMeatBoy() {
        String s = ChatFormatting.m_126649_((String)this.m_7755_().getString());
        return s != null && s.toLowerCase().contains("meatboy");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.rollAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int input) {
        this.attackTicks = 0;
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)input);
        this.m_9236_().m_7605_((Entity)this, (byte)(-input));
    }

    public void stopAllAnimationStates() {
        this.rollAnimationState.m_216973_();
    }

    public boolean m_7327_(Entity p_219472_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(p_219472_);
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackTicks = 0;
        } else if (id == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(id);
        }
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 2.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
        if (this.roll_cooldown > 0) {
            --this.roll_cooldown;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAttackState() == 1) {
            if (this.attackTicks > 13 && this.attackTicks < 30 && !this.m_9236_().f_46443_) {
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_())) {
                    boolean flag;
                    if (MobUtil.areAllies((Entity)this, (Entity)livingentity) || !(flag = livingentity.m_6469_(this.getTrueOwner() != null ? ModDamageSource.summonAttack((LivingEntity)this, (LivingEntity)this.getTrueOwner()) : this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_))) || this.m_9236_().f_46443_) continue;
                    MobEffect mobEffect = MobEffects.f_19614_;
                    if (this.getTrueOwner() != null && CuriosFinder.hasWildRobe((LivingEntity)this.getTrueOwner())) {
                        mobEffect = (MobEffect)GoetyEffects.ACID_VENOM.get();
                    }
                    livingentity.m_147207_(new MobEffectInstance(mobEffect, 60, 0), (Entity)this);
                }
            }
            if (this.attackTicks == 13 || this.attackTicks == 16 || this.attackTicks == 19 || this.attackTicks == 22 || this.attackTicks == 25 || this.attackTicks == 28) {
                this.SpikeNansa(3);
            }
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        this.SpikeNansa(6);
    }

    private void SpikeNansa(int spike) {
        int shardCount = spike + this.f_19796_.m_188503_(2);
        if (!this.m_9236_().f_46443_) {
            for (int i = 0; i < shardCount; ++i) {
                float f = (float)(i + 1) / (float)shardCount * 360.0f;
                Urchin_Spike_Entity shard = new Urchin_Spike_Entity(this.m_9236_(), (LivingEntity)this);
                if (this.isMeatBoy()) {
                    ItemStack itemstack = new ItemStack((ItemLike)ModItems.BLOOD_CLOT.get());
                    shard.m_37446_(itemstack);
                }
                shard.m_6686_((double)(this.f_19796_.m_188501_() * 0.4f * 2.0f - 0.4f), (double)(this.f_19796_.m_188501_() * 0.25f + 0.1f), (double)(this.f_19796_.m_188501_() * 0.4f * 2.0f - 0.4f), 0.35f, 1.0f);
                this.m_9236_().m_7967_((Entity)shard);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.DRAUGR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_IDLE.get();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.m_5634_(2.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class Roll
    extends Goal {
        private final UrchinkinServant entity;
        private final int attackrollstart;
        private final int attackrollend;
        private final float random;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;

        public Roll(UrchinkinServant entity, int getAttackState, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange, int attackroll, int attackrollend, float random) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getAttackState;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
            this.attackrollstart = attackroll;
            this.attackrollend = attackrollend;
            this.random = random;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.entity.m_217043_().m_188501_() * 100.0f < this.random && this.entity.m_21574_().m_148306_((Entity)target) && this.entity.roll_cooldown <= 0;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
            this.entity.roll_cooldown = 80;
        }

        public boolean m_8045_() {
            return this.entity.getAttackState() == this.attackstate && this.entity.attackTicks <= this.attackMaxtick;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (this.attackrollstart < this.entity.attackTicks && this.attackrollend > this.entity.attackTicks) {
                Vec3 vector3d = this.entity.m_20184_();
                float f = this.entity.m_146908_() * ((float)Math.PI / 180);
                Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), this.entity.m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(0.35).m_82549_(vector3d.m_82490_(0.35));
                this.entity.m_20334_(vector3d1.f_82479_, this.entity.m_20184_().f_82480_, vector3d1.f_82481_);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class UrchinkinSwimControl
    extends MoveControl {
        private final UrchinkinServant drowned;
        private final float speedMulti;

        public UrchinkinSwimControl(UrchinkinServant p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

