/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.client.render;

import com.Polarice3.goety_cataclysm.client.render.layer.AbstractDeeplingServantLayer;
import com.Polarice3.goety_cataclysm.client.render.model.DeeplingPriestServantModel;
import com.Polarice3.goety_cataclysm.common.entities.ally.deepling.DeeplingPriestServant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;

public class DeeplingPriestServantRenderer
extends MobRenderer<DeeplingPriestServant, DeeplingPriestServantModel> {
    private static final ResourceLocation DEEPLING_TEXTURES = new ResourceLocation("cataclysm", "textures/entity/deepling/deepling_priest.png");
    private static final ResourceLocation DEEPLING_LAYER_TEXTURES = new ResourceLocation("cataclysm", "textures/entity/deepling/deepling_priest_layer.png");

    public DeeplingPriestServantRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new DeeplingPriestServantModel(), 0.7f);
        this.m_115326_(new AbstractDeeplingServantLayer(this, DEEPLING_LAYER_TEXTURES));
        this.m_115326_(new PriestItemLayer((RenderLayerParent)this, renderManagerIn.m_234598_()));
        this.m_115326_(new PriestLightLayer((RenderLayerParent)this));
    }

    public ResourceLocation getTextureLocation(DeeplingPriestServant entity) {
        return DEEPLING_TEXTURES;
    }

    public static class PriestItemLayer
    extends RenderLayer<DeeplingPriestServant, DeeplingPriestServantModel> {
        private final ItemInHandRenderer itemInHandRenderer;

        public PriestItemLayer(RenderLayerParent p_234846_, ItemInHandRenderer p_234847_) {
            super(p_234846_);
            this.itemInHandRenderer = p_234847_;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, DeeplingPriestServant entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack itemstack = entitylivingbaseIn.m_6844_(EquipmentSlot.MAINHAND);
            matrixStackIn.m_85836_();
            boolean left = entitylivingbaseIn.m_21526_();
            matrixStackIn.m_85836_();
            this.translateToHand(matrixStackIn, left);
            matrixStackIn.m_252880_(0.0f, 1.4225f, -0.1f);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrixStackIn.m_85841_(1.0f, 1.0f, 1.0f);
            ItemInHandRenderer renderer = Minecraft.m_91087_().m_91290_().m_234586_();
            renderer.m_269530_((LivingEntity)entitylivingbaseIn, itemstack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, false, matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
            matrixStackIn.m_85849_();
        }

        protected void translateToHand(PoseStack matrixStack, boolean left) {
            ((DeeplingPriestServantModel)this.m_117386_()).root.translateAndRotate(matrixStack);
            ((DeeplingPriestServantModel)this.m_117386_()).body.translateAndRotate(matrixStack);
            if (left) {
                ((DeeplingPriestServantModel)this.m_117386_()).left_arm.translateAndRotate(matrixStack);
            } else {
                ((DeeplingPriestServantModel)this.m_117386_()).right_arm.translateAndRotate(matrixStack);
            }
        }
    }

    public static class PriestLightLayer
    extends RenderLayer<DeeplingPriestServant, DeeplingPriestServantModel> {
        private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

        public PriestLightLayer(RenderLayerParent p_234846_) {
            super(p_234846_);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, DeeplingPriestServant entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            matrixStackIn.m_85836_();
            if (entity.getAnimation() == DeeplingPriestServant.DEEPLING_BLIND && entity.getAnimationTick() > 18 && entity.getAnimationTick() < 47) {
                float f5 = ((float)entity.getAnimationTick() + partialTicks) / 144.0f;
                float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
                RandomSource randomsource = RandomSource.m_216335_((long)432L);
                VertexConsumer vertexconsumer2 = bufferIn.m_6299_(RenderType.m_110502_());
                matrixStackIn.m_85836_();
                this.translateToLight(matrixStackIn);
                int i = 0;
                while ((float)i < 4.0f) {
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f));
                    matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(randomsource.m_188501_() * 360.0f));
                    matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(randomsource.m_188501_() * 360.0f));
                    matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(randomsource.m_188501_() * 360.0f + f5 * 90.0f));
                    float f3 = 2.75f;
                    float f4 = 2.75f;
                    Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
                    int j = (int)(255.0f * (1.0f - f7));
                    PriestLightLayer.vertex01(vertexconsumer2, matrix4f, j);
                    PriestLightLayer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                    PriestLightLayer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                    PriestLightLayer.vertex01(vertexconsumer2, matrix4f, j);
                    PriestLightLayer.vertex3(vertexconsumer2, matrix4f, f3, f4);
                    PriestLightLayer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                    PriestLightLayer.vertex01(vertexconsumer2, matrix4f, j);
                    PriestLightLayer.vertex4(vertexconsumer2, matrix4f, f3, f4);
                    PriestLightLayer.vertex2(vertexconsumer2, matrix4f, f3, f4);
                    ++i;
                }
                matrixStackIn.m_85849_();
            }
            matrixStackIn.m_85849_();
        }

        private static void vertex01(VertexConsumer p_114220_, Matrix4f p_114221_, int p_114222_) {
            p_114220_.m_252986_(p_114221_, 0.0f, 0.0f, 0.0f).m_6122_(51, 255, 255, p_114222_).m_5752_();
        }

        private static void vertex2(VertexConsumer p_114215_, Matrix4f p_114216_, float p_114217_, float p_114218_) {
            p_114215_.m_252986_(p_114216_, -HALF_SQRT_3 * p_114218_, p_114217_, -0.5f * p_114218_).m_6122_(51, 255, 255, 0).m_5752_();
        }

        private static void vertex3(VertexConsumer p_114224_, Matrix4f p_114225_, float p_114226_, float p_114227_) {
            p_114224_.m_252986_(p_114225_, HALF_SQRT_3 * p_114227_, p_114226_, -0.5f * p_114227_).m_6122_(51, 255, 255, 0).m_5752_();
        }

        private static void vertex4(VertexConsumer p_114229_, Matrix4f p_114230_, float p_114231_, float p_114232_) {
            p_114229_.m_252986_(p_114230_, 0.0f, p_114231_, 1.0f * p_114232_).m_6122_(51, 255, 255, 0).m_5752_();
        }

        private void translateToLight(PoseStack matrixStack) {
            ((DeeplingPriestServantModel)this.m_117386_()).root.translateAndRotate(matrixStack);
            ((DeeplingPriestServantModel)this.m_117386_()).body.translateAndRotate(matrixStack);
            ((DeeplingPriestServantModel)this.m_117386_()).head.translateAndRotate(matrixStack);
            ((DeeplingPriestServantModel)this.m_117386_()).head2.translateAndRotate(matrixStack);
            ((DeeplingPriestServantModel)this.m_117386_()).fin.translateAndRotate(matrixStack);
            ((DeeplingPriestServantModel)this.m_117386_()).light.translateAndRotate(matrixStack);
        }
    }
}

