/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.client.render;

import com.Polarice3.goety_cataclysm.client.render.model.ClawdianServantModel;
import com.Polarice3.goety_cataclysm.common.entities.ally.acropolis.ClawdianServant;
import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.client.model.CMModelLayers;
import com.github.L_Ender.cataclysm.client.render.layer.LayerGenericGlowing;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;

public class ClawdianServantRenderer
extends MobRenderer<ClawdianServant, ClawdianServantModel<ClawdianServant>> {
    private static final ResourceLocation KOBOLEDIATOR_TEXTURES = new ResourceLocation("cataclysm", "textures/entity/sea/shrimp.png");
    private static final ResourceLocation LAYER = new ResourceLocation("cataclysm", "textures/entity/sea/shrimp_glow.png");

    public ClawdianServantRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new ClawdianServantModel(renderManagerIn.m_174023_(CMModelLayers.CLAWDIAN_MODEL)), 1.8f);
        this.m_115326_((RenderLayer)new LayerGenericGlowing((RenderLayerParent)this, LAYER));
        this.m_115326_(new ClawdianHoldBlockLayer((RenderLayerParent<ClawdianServant, ClawdianServantModel<ClawdianServant>>)this, renderManagerIn.m_234597_()));
        this.m_115326_(new ClawdianHoldEntityLayer((RenderLayerParent<ClawdianServant, ClawdianServantModel<ClawdianServant>>)this, renderManagerIn.m_174022_()));
    }

    public ResourceLocation getTextureLocation(ClawdianServant entity) {
        return KOBOLEDIATOR_TEXTURES;
    }

    protected float getFlipDegrees(ClawdianServant entity) {
        return 0.0f;
    }

    protected void scale(ClawdianServant entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.m_85841_(1.1f, 1.1f, 1.1f);
    }

    static class ClawdianHoldBlockLayer
    extends RenderLayer<ClawdianServant, ClawdianServantModel<ClawdianServant>> {
        private final BlockRenderDispatcher blockRenderer;

        public ClawdianHoldBlockLayer(RenderLayerParent<ClawdianServant, ClawdianServantModel<ClawdianServant>> renderer, BlockRenderDispatcher blockRenderer) {
            super(renderer);
            this.blockRenderer = blockRenderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, ClawdianServant entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            BlockState blockstate = entity.getHoldBlock();
            if (blockstate != null) {
                int amount = 2;
                for (int i = 0; i < amount; ++i) {
                    for (int l = 0; l < amount; ++l) {
                        float xOffset = (float)(i * 2 - 1) * 0.5f;
                        float zOffset = (float)(l * 2 - 1) * 0.5f;
                        matrixStackIn.m_85836_();
                        ((ClawdianServantModel)this.m_117386_()).translateToHand(matrixStackIn);
                        matrixStackIn.m_85837_((double)(0.5f + xOffset), 1.0 + 0.08 * (double)(i + l), (double)(-0.7f + zOffset));
                        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
                        this.blockRenderer.m_110912_(blockstate, matrixStackIn, bufferIn, packedLightIn, OverlayTexture.f_118083_);
                        matrixStackIn.m_85849_();
                    }
                }
            }
        }
    }

    static class ClawdianHoldEntityLayer
    extends RenderLayer<ClawdianServant, ClawdianServantModel<ClawdianServant>> {
        private final EntityRenderDispatcher entityRenderer;

        public ClawdianHoldEntityLayer(RenderLayerParent<ClawdianServant, ClawdianServantModel<ClawdianServant>> renderer, EntityRenderDispatcher entityRenderer) {
            super(renderer);
            this.entityRenderer = entityRenderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, ClawdianServant entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (entity.m_20160_()) {
                for (Entity passenger : entity.m_20197_()) {
                    if (passenger == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) continue;
                    this.renderEntityInClaw(partialTicks, matrixStackIn, bufferIn, packedLightIn, passenger, this.entityRenderer);
                }
            }
        }

        public void renderEntityInClaw(float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, EntityRenderDispatcher entityRenderer) {
            Cataclysm.PROXY.releaseRenderingEntity(entity.m_20148_());
            poseStack.m_85836_();
            ((ClawdianServantModel)this.m_117386_()).translateToHand(poseStack);
            poseStack.m_252880_(0.0f, -0.25f, 0.0f);
            poseStack.m_85841_(1.0f, 1.0f, 1.0f);
            entityRenderer.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packedLight);
            poseStack.m_85849_();
            Cataclysm.PROXY.blockRenderingEntity(entity.m_20148_());
        }
    }
}

