/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.handlers;

import auviotre.enigmatic.addon.EnigmaticAddons;
import auviotre.enigmatic.addon.api.events.LivingCurseBoostEvent;
import auviotre.enigmatic.addon.api.items.IBlessed;
import auviotre.enigmatic.addon.contents.enchantments.RedemptionCurseEnchantment;
import auviotre.enigmatic.addon.contents.entities.goal.AvoidTheWorthyGoal;
import auviotre.enigmatic.addon.contents.entities.goal.CrossbowBlazeAttackGoal;
import auviotre.enigmatic.addon.contents.entities.goal.GhastMultishotGoal;
import auviotre.enigmatic.addon.contents.entities.goal.LeapAttackGoal;
import auviotre.enigmatic.addon.contents.entities.goal.SkeletonMeleeAttackGoal;
import auviotre.enigmatic.addon.contents.entities.goal.SpiderRangedAttackGoal;
import auviotre.enigmatic.addon.contents.items.AdventureCharm;
import auviotre.enigmatic.addon.contents.items.AnnihilatingSword;
import auviotre.enigmatic.addon.contents.items.AvariceRing;
import auviotre.enigmatic.addon.contents.items.BlessRing;
import auviotre.enigmatic.addon.contents.items.CursedXPScroll;
import auviotre.enigmatic.addon.contents.items.DisasterSword;
import auviotre.enigmatic.addon.contents.items.EarthPromise;
import auviotre.enigmatic.addon.contents.items.EtheriumCore;
import auviotre.enigmatic.addon.contents.items.EvilDagger;
import auviotre.enigmatic.addon.contents.items.ForgerGem;
import auviotre.enigmatic.addon.contents.items.ForgottenIce;
import auviotre.enigmatic.addon.contents.items.HellBladeCharm;
import auviotre.enigmatic.addon.contents.items.LostEngine;
import auviotre.enigmatic.addon.contents.items.NightScroll;
import auviotre.enigmatic.addon.contents.items.OdeToLiving;
import auviotre.enigmatic.addon.contents.items.QuartzRing;
import auviotre.enigmatic.addon.contents.items.RevivalLeaf;
import auviotre.enigmatic.addon.contents.items.SanguinaryHandbook;
import auviotre.enigmatic.addon.contents.items.ScorchedCharm;
import auviotre.enigmatic.addon.contents.items.TheBless;
import auviotre.enigmatic.addon.contents.items.ThunderScroll;
import auviotre.enigmatic.addon.contents.items.TotemOfMalice;
import auviotre.enigmatic.addon.contents.objects.bookbag.AntiqueBagCapability;
import auviotre.enigmatic.addon.contents.objects.bookbag.IAntiqueBagHandler;
import auviotre.enigmatic.addon.contents.objects.etheriumSheild.EtheriumShieldCapability;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.packets.clients.PacketDisasterParry;
import auviotre.enigmatic.addon.packets.server.PacketEmptyLeftClick;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEffects;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEnchantments;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.capabilities.IPlaytimeCounter;
import com.aizistral.enigmaticlegacy.api.items.ICursed;
import com.aizistral.enigmaticlegacy.api.items.IEldritch;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.entities.PermanentItemEntity;
import com.aizistral.enigmaticlegacy.handlers.EnigmaticEventHandler;
import com.aizistral.enigmaticlegacy.handlers.SoulArchive;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.items.BerserkEmblem;
import com.aizistral.enigmaticlegacy.items.CursedRing;
import com.aizistral.enigmaticlegacy.items.CursedScroll;
import com.aizistral.enigmaticlegacy.items.EnderSlayer;
import com.aizistral.enigmaticlegacy.items.HunterGuidebook;
import com.aizistral.enigmaticlegacy.items.TheInfinitum;
import com.aizistral.enigmaticlegacy.items.TheTwist;
import com.aizistral.enigmaticlegacy.items.VoidPearl;
import com.aizistral.enigmaticlegacy.objects.DimensionalPosition;
import com.aizistral.enigmaticlegacy.objects.RegisteredMeleeAttack;
import com.aizistral.enigmaticlegacy.packets.clients.PacketPermadeath;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedCrossbowAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

@Mod.EventBusSubscriber(modid="enigmaticaddons")
public class AddonEventHandler {
    public static final Map<Player, AABB> NIGHT_SCROLL_BOXES = new WeakHashMap<Player, AABB>();
    public static final List<ResourceKey<DamageType>> NEMESIS_LIST = List.of(DamageTypes.f_268566_, DamageTypes.f_268433_, DamageTypes.f_268464_);
    public static final Multimap<Player, Item> POSTMORTAL_POSSESSIONS = ArrayListMultimap.create();
    public static final Random RANDOM = new Random();
    public static final UUID UUID_SPEED = UUID.fromString("D549B5FB-136F-4402-8A5E-1BAA4896E173");
    public static final UUID UUID_ATTACK = UUID.fromString("73B52DA4-C79F-48AF-87BB-4B9C037FED9F");
    public static final UUID UUID_ARMOR = UUID.fromString("2F35F0A9-794F-448C-921D-EBCC2CA951D3");
    public static final UUID UUID_ATTACK_KB = UUID.fromString("73B52DA4-C79F-48AF-87BB-4B9C037FED9F");
    public static final UUID UUID_ARMOR_TH = UUID.fromString("2F35F0A9-794F-448C-921D-EBCC2CA951D3");

    public static int getGoalPriority(Mob mob, Predicate<WrappedGoal> filter) {
        return mob.f_21345_.m_148105_().stream().filter(filter).findFirst().map(WrappedGoal::m_26012_).orElse(-1);
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        Shulker shulker;
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Shulker && SuperAddonHandler.isCurseBoosted((LivingEntity)(shulker = (Shulker)livingEntity)) && shulker.m_33468_()) {
            event.setCanceled(true);
            return;
        }
        Object object = event.getEntity();
        if (object instanceof Animal) {
            Player player;
            Animal animal = (Animal)object;
            object = event.getSource().m_7639_();
            if (object instanceof Player && SuperpositionHandler.hasItem((Player)(player = (Player)object), (Item)EnigmaticAddonItems.LIVING_ODE) && !player.m_21205_().m_150930_((Item)EnigmaticAddonItems.LIVING_ODE) && OdeToLiving.isProtectedAnimal(player, animal)) {
                event.setCanceled(true);
                if (animal.m_5448_() == player) {
                    event.setCanceled(false);
                } else {
                    for (WrappedGoal goal : animal.f_21346_.m_148105_()) {
                        Goal goal2 = goal.m_26015_();
                        if (!(goal2 instanceof TargetGoal)) continue;
                        TargetGoal targetGoal = (TargetGoal)goal2;
                        if (targetGoal.f_26137_ != player) continue;
                        event.setCanceled(false);
                    }
                }
                Brain brain = animal.m_6274_();
                if (brain != null) {
                    try {
                        Optional memory;
                        Optional optional = memory = brain.m_21874_(MemoryModuleType.f_26372_) ? brain.m_21952_(MemoryModuleType.f_26372_) : Optional.empty();
                        if (memory.isPresent() && memory.get() == player) {
                            event.setCanceled(false);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((livingEntity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!SuperAddonHandler.isCurseBoosted(event.getEntity()) && SuperpositionHandler.isTheWorthyOne((Player)player)) {
                SuperAddonHandler.setCurseBoosted(event.getEntity(), true, player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (entity instanceof Targeting) {
            Targeting targetedEntity = (Targeting)entity;
            if (target instanceof Player) {
                Player player = (Player)target;
                if (!(event.getTargetType() != LivingChangeTargetEvent.LivingTargetType.MOB_TARGET || entity.m_21188_() == player || targetedEntity.m_5448_() != null && targetedEntity.m_5448_().m_6084_())) {
                    NeutralMob neutral;
                    if (entity instanceof NeutralMob && (neutral = (NeutralMob)entity) instanceof Animal && SuperpositionHandler.isTheCursedOne((Player)player) && SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.LIVING_ODE)) {
                        event.setCanceled(true);
                    }
                    if ((entity instanceof AbstractGolem || LostEngine.golemList.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()))) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.LOST_ENGINE)) {
                        event.setCanceled(true);
                    }
                    if (entity.m_6336_().equals(MobType.f_21641_) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.ILLUSION_LANTERN)) {
                        event.setCanceled(true);
                    }
                    if ((entity instanceof Merchant || AvariceRing.merchantList.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()))) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.AVARICE_RING)) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntitySpawn(MobSpawnEvent.FinalizeSpawn event) {
        block5: {
            Mob entity;
            block6: {
                if (event.getSpawnType() != MobSpawnType.NATURAL) break block5;
                entity = event.getEntity();
                if (entity instanceof Phantom) break block6;
                if (!(entity.m_20202_() instanceof Phantom)) break block5;
            }
            if (NIGHT_SCROLL_BOXES.values().stream().anyMatch(arg_0 -> ((AABB)entity.m_20191_()).m_82381_(arg_0))) {
                event.setSpawnCancelled(true);
                event.setResult(Event.Result.DENY);
                event.setCanceled(true);
            }
        }
        if (OmniconfigAddonHandler.ImmediatelyCurseBoost.getValue()) {
            SuperAddonHandler.setCurseBoosted((LivingEntity)event.getEntity(), true, null);
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        int disaster;
        int ichor;
        int cooldown;
        CompoundTag data;
        LivingEntity mainHandItem;
        int boostLevel;
        EnderDragon dragon;
        LivingEntity entity = event.getEntity();
        if (!entity.m_6084_()) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DisasterSword.tick(player);
            if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.THE_BLESS)) {
                player.m_20095_();
            }
        }
        if (entity instanceof EnderDragon && SuperAddonHandler.isCurseBoosted((LivingEntity)(dragon = (EnderDragon)entity)) && dragon.f_19797_ % (80 - 2 * (boostLevel = SuperAddonHandler.getEnderDragonBoostLevel(dragon))) == 0) {
            dragon.m_5634_(2.0f);
        }
        if (entity instanceof WitherSkeleton) {
            WitherSkeleton skeleton = (WitherSkeleton)entity;
            if (SuperAddonHandler.isCurseBoosted(entity)) {
                LivingEntity target = skeleton.m_5448_();
                if (!entity.m_9236_().m_5776_() && target != null) {
                    ItemStack backup = ItemStack.f_41583_;
                    if (skeleton.getPersistentData().m_128469_("BackupItem") != null) {
                        backup = ItemStack.m_41712_((CompoundTag)skeleton.getPersistentData().m_128469_("BackupItem"));
                    }
                    mainHandItem = skeleton.m_21205_();
                    if (skeleton.m_20238_(target.m_20182_().m_82549_(target.m_20184_().m_82490_(1.6))) <= 25.0) {
                        if (mainHandItem.m_41720_() instanceof BowItem) {
                            copy = skeleton.m_21205_().m_41777_();
                            if (backup.m_41619_()) {
                                skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                            } else {
                                skeleton.m_8061_(EquipmentSlot.MAINHAND, backup.m_41777_());
                            }
                            skeleton.getPersistentData().m_128365_("BackupItem", (Tag)copy.m_41739_(new CompoundTag()));
                        }
                    } else if (mainHandItem.m_41720_() instanceof SwordItem) {
                        copy = skeleton.m_21205_().m_41777_();
                        if (backup.m_41619_()) {
                            skeleton.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
                        } else {
                            skeleton.m_8061_(EquipmentSlot.MAINHAND, backup.m_41777_());
                        }
                        skeleton.getPersistentData().m_128365_("BackupItem", (Tag)copy.m_41739_(new CompoundTag()));
                    }
                }
            }
        }
        if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            if (NIGHT_SCROLL_BOXES.values().stream().anyMatch(arg_0 -> ((AABB)phantom.m_20191_()).m_82381_(arg_0)) && !phantom.m_21023_(MobEffects.f_19615_)) {
                phantom.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 2));
                phantom.m_6469_(phantom.m_269291_().m_269333_((LivingEntity)phantom), phantom.m_21223_() / 2.0f);
                phantom.f_19802_ = 1;
            }
        }
        if (entity instanceof OwnableEntity) {
            Player owner;
            TamableAnimal ta;
            OwnableEntity pet = (OwnableEntity)entity;
            if ((!(entity instanceof TamableAnimal) || (ta = (TamableAnimal)entity).m_21824_()) && (mainHandItem = pet.m_269323_()) instanceof Player && (SuperpositionHandler.isTheCursedOne((Player)(owner = (Player)mainHandItem)) || BlessRing.Helper.betrayalAvailable(owner)) && !entity.m_9236_().f_46443_ && owner.m_9236_() == pet.m_9236_() && owner.m_20270_((Entity)entity) <= (float)HunterGuidebook.effectiveDistance.getValue()) {
                if (SuperpositionHandler.hasItem((Player)owner, (Item)EnigmaticAddonItems.SANGUINARY_HANDBOOK) && SuperpositionHandler.hasCurio((LivingEntity)owner, (Item)EnigmaticItems.BERSERK_CHARM)) {
                    entity.m_21204_().m_22178_(SanguinaryHandbook.createAttributeMap(owner));
                } else {
                    entity.m_21204_().m_22161_(SanguinaryHandbook.createAttributeMap(owner));
                }
            }
        }
        if ((data = entity.getPersistentData()).m_128471_("ForgottenFrozenHard")) {
            Vec3 movement = entity.m_20184_();
            entity.m_20256_(new Vec3(0.0, movement.f_82480_, 0.0));
            entity.f_19812_ = true;
            entity.m_21204_().m_22178_(ForgottenIce.getFrozenAttributes());
            if (!entity.m_146890_()) {
                data.m_128473_("ForgottenFrozenHard");
                entity.m_21204_().m_22161_(ForgottenIce.getFrozenAttributes());
            }
        }
        if (data.m_128471_("RevivingPoisoned") && !entity.m_21023_(MobEffects.f_19614_)) {
            data.m_128473_("RevivingPoisoned");
        }
        if ((cooldown = data.m_128451_("CosmicPotion")) > 0) {
            if ((cooldown -= entity.m_21220_().isEmpty() ? 3 : 1) > 0) {
                data.m_128405_("CosmicPotion", cooldown);
            } else {
                data.m_128473_("CosmicPotion");
            }
        }
        if ((ichor = data.m_128451_("Ichor")) > 0) {
            if (ichor > 1920) {
                entity.m_7292_(new MobEffectInstance((MobEffect)EnigmaticAddonEffects.PURE_RESISTANCE_EFFECT, 300));
                entity.m_9236_().m_247517_(null, entity.m_20183_(), SoundEvents.f_11736_, SoundSource.AMBIENT);
                data.m_128405_("Ichor", ichor / 3);
            } else {
                data.m_128405_("Ichor", ichor - 1);
            }
        } else {
            data.m_128473_("Ichor");
        }
        int electric = data.m_128451_("Electric");
        if (electric > 0) {
            if (electric > 1200) {
                List entities = entity.m_9236_().m_45933_((Entity)entity, entity.m_20191_().m_82400_(2.2));
                boolean flag = true;
                for (Entity target : entities) {
                    Player player;
                    if (!(target instanceof Player) || !SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)target), (Item)EnigmaticAddonItems.THUNDER_SCROLL)) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(entity.m_9236_());
                    if (lightningbolt != null) {
                        lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)entity.m_20183_()));
                        lightningbolt.m_20225_(entity.m_217043_().m_188499_());
                        lightningbolt.m_20049_("HarmlessThunder");
                        lightningbolt.setDamage(lightningbolt.getDamage() * (float)electric / 600.0f);
                        entity.m_9236_().m_7967_((Entity)lightningbolt);
                    }
                    data.m_128405_("Electric", (electric - 1200) / 2 + 100);
                }
            } else {
                data.m_128405_("Electric", electric - 1);
            }
        } else {
            data.m_128473_("Electric");
        }
        if (data.m_128441_("CursedNextSpawn")) {
            data.m_128473_("CursedNextSpawn");
        }
        if (data.m_128441_("BlessNextSpawn")) {
            data.m_128473_("BlessNextSpawn");
        }
        if (data.m_128441_("WorthyNextSpawn")) {
            data.m_128473_("WorthyNextSpawn");
        }
        if (data.m_128451_("EvilCurseThreshold") > 0) {
            EvilDagger.EvilCursing(entity);
        }
        if ((disaster = data.m_128451_("DisasterCurse")) > 0) {
            data.m_128405_("DisasterCurse", disaster - 1);
        } else {
            data.m_128473_("DisasterCurse");
        }
        int level = EnchantmentHelper.m_44836_((Enchantment)EnigmaticAddonEnchantments.FROST_PROTECTION, (LivingEntity)entity);
        if (level >= 16) {
            entity.m_146917_(0);
        } else if (level > 0 && entity.f_19797_ % (4 - level / 4) == 0) {
            entity.m_146917_(Math.max(entity.m_146888_() - 1, 0));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IAntiqueBagHandler bagHandler;
        Object capability;
        Player player = event.player;
        if (!player.m_6084_()) {
            return;
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!player.m_9236_().f_46443_) {
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.NIGHT_SCROLL) && SuperpositionHandler.isTheCursedOne((Player)player)) {
                NIGHT_SCROLL_BOXES.put(player, SuperAddonHandler.getBoundingBoxAroundEntity((Entity)player, 128.0, 360.0, 128.0));
            } else {
                NIGHT_SCROLL_BOXES.remove(player);
            }
        }
        BlockPos blockPos = player.m_20183_();
        if (this.check() && !player.m_9236_().m_5776_() && player.f_19797_ % 100 == 0 && player.m_217043_().m_188501_() < 0.01f) {
            List entities = player.m_9236_().m_45976_(Entity.class, player.m_20191_().m_82400_(64.0));
            for (Object entity : entities) {
                Player near;
                if (entity == player) continue;
                if (entity instanceof Player && (near = (Player)entity).m_217043_().m_188499_()) {
                    player.m_150109_().m_6211_();
                    player.m_36327_().m_6211_();
                    CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosItemHandler -> {
                        IItemHandlerModifiable equippedCurios = curiosItemHandler.getEquippedCurios();
                        for (int i = 0; i < equippedCurios.getSlots(); ++i) {
                            equippedCurios.setStackInSlot(i, ItemStack.f_41583_);
                        }
                    });
                    continue;
                }
                if (entity instanceof LivingEntity) continue;
                entity.m_146870_();
            }
            Iterable poss = BlockPos.m_121940_((BlockPos)blockPos.m_7918_(32, 32, 32), (BlockPos)blockPos.m_7918_(-32, -32, -32));
            for (BlockPos pos : poss) {
                BlockEntity blockEntity = player.m_9236_().m_7702_(pos);
                if (!(blockEntity instanceof Clearable)) continue;
                Clearable clearable = (Clearable)blockEntity;
                clearable.m_6211_();
                if (!(clearable instanceof Container)) continue;
                Container container = (Container)clearable;
                container.m_6596_();
            }
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SuperAddonHandler.getCapability((Player)serverPlayer, EtheriumShieldCapability.ETHERIUM_SHIELD_DATA).ifPresent(cap -> {
                if (!EtheriumCore.hasShield(player)) {
                    cap.tick((Player)serverPlayer);
                }
            });
        }
        if ((SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.ANTIQUE_BAG) || player.m_36327_().m_18949_(Set.of(EnigmaticAddonItems.ANTIQUE_BAG))) && (capability = SuperAddonHandler.getCapability(player, AntiqueBagCapability.INVENTORY)) != null && capability.isPresent() && (bagHandler = (IAntiqueBagHandler)capability.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty"))).hasFlower()) {
            bagHandler.tickFlowers();
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.REVIVAL_LEAF) && !player.m_21220_().isEmpty()) {
            for (MobEffectInstance effect : player.m_21220_()) {
                if (player.f_19797_ % 4 != 0 || effect.f_19503_ <= 0) continue;
                ++effect.f_19503_;
            }
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.LOST_ENGINE)) {
            boolean spaceDown;
            if (!player.m_9236_().m_5776_() && player.f_19797_ % 3 == 0) {
                player.m_36335_().m_41518_();
            }
            if (player.m_9236_().m_5776_() && Minecraft.m_91087_().f_91074_ == player && (spaceDown = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_()) && player.m_20184_().f_82480_ > (double)0.225f && !player.m_9236_().m_8055_(blockPos).m_60815_()) {
                player.m_246865_(new Vec3(0.0, 0.0256, 0.0));
                float width = player.m_20205_();
                for (int i = 0; i < RANDOM.nextInt(3); ++i) {
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20208_((double)width), player.m_20186_() + (double)RANDOM.nextFloat(0.2f), player.m_20262_((double)width), 0.0, (double)RANDOM.nextFloat(0.5f) * player.m_20184_().f_82480_, 0.0);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFinalTarget(LivingChangeTargetEvent event) {
        Player player;
        LivingEntity livingEntity;
        LivingEntity entity = event.getEntity();
        if (!entity.m_6084_()) {
            return;
        }
        if (!SuperAddonHandler.isCurseBoosted(entity) && (livingEntity = event.getNewTarget()) instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)livingEntity))) {
            SuperAddonHandler.setCurseBoosted(entity, true, player);
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingAttackEvent event) {
        LivingEntity living;
        Entity entity;
        Entity directEntity;
        Raider raider;
        LivingEntity percentage2;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Entity directEntity2;
            player = (Player)livingEntity;
            if (player.m_21211_().m_150930_((Item)EnigmaticAddonItems.DISASTER_SWORD) && (directEntity2 = event.getSource().m_7640_()) != null && directEntity2.m_20182_().m_82546_(player.m_20182_()).m_82526_(player.m_20156_()) > 0.0 && !event.getSource().m_269533_(DamageTypeTags.f_268490_)) {
                DisasterSword.parry(player.m_9236_(), player, event.getSource(), event.getAmount());
                event.setCanceled(true);
                return;
            }
            if (player.m_21211_().m_150930_((Item)EnigmaticAddonItems.ANNIHILATING_SWORD) && player.m_7655_().equals((Object)InteractionHand.OFF_HAND) && SuperpositionHandler.isTheWorthyOne((Player)player)) {
                directEntity2 = event.getSource().m_7640_();
                if (!event.getSource().m_269533_(DamageTypeTags.f_268490_) && player instanceof ServerPlayer && (directEntity2 == null && event.getSource().m_7639_() == null || directEntity2 != null && directEntity2.m_20182_().m_82546_(player.m_20182_()).m_82526_(player.m_20156_()) > 0.0)) {
                    AnnihilatingSword.parry(player.m_9236_(), (ServerPlayer)player, event.getSource(), event.getAmount(), player.m_21211_());
                    event.setCanceled(true);
                    return;
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.SCORCHED_CHARM)) {
                int percentage2 = ScorchedCharm.resistanceProbability.getValue().asPercentage() * (player.m_20077_() ? 2 : 1);
                if (player.m_217043_().m_188503_(100) < percentage2) {
                    event.setCanceled(true);
                    return;
                }
            }
        }
        if ((percentage2 = event.getEntity()) instanceof Raider && SuperAddonHandler.isCurseBoosted((LivingEntity)(raider = (Raider)percentage2)) && (directEntity = event.getSource().m_7640_()) instanceof FireworkRocketEntity) {
            event.setCanceled(true);
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)event.getEntity(), (Item)EnigmaticAddonItems.SCORCHED_CHARM)) {
            if (EnigmaticAddonItems.SCORCHED_CHARM.immunityList.stream().anyMatch(arg_0 -> ((DamageSource)event.getSource()).m_276093_(arg_0))) {
                event.setCanceled(true);
                return;
            }
        }
        if ((entity = event.getSource().m_7639_()) instanceof Player) {
            player = (Player)entity;
            if (player.m_21205_().m_150930_((Item)EnigmaticAddonItems.THE_BLESS) && !SuperpositionHandler.isTheCursedOne((Player)player) && !BlessRing.Helper.blessAvailable(player)) {
                event.setCanceled(true);
            }
            if (player.m_21205_().m_150930_((Item)EnigmaticAddonItems.ANNIHILATING_SWORD) && !SuperpositionHandler.isTheWorthyOne((Player)player)) {
                event.setCanceled(true);
            }
        }
        if ((entity = event.getSource().m_7639_()) instanceof LivingEntity && (living = (LivingEntity)entity).getPersistentData().m_128451_("DisasterCurse") > 0) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFirstHurt(LivingHurtEvent event) {
        LivingEntity mainHandItem;
        Player player;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            player = (Player)entity;
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.ETHERIUM_CORE)) {
                event.setAmount(event.getAmount() + player.getPersistentData().m_128457_("EtheriumCounterattack"));
                player.getPersistentData().m_128473_("EtheriumCounterattack");
            }
            if ((mainHandItem = player.m_21205_()).getEnchantmentLevel((Enchantment)EnigmaticAddonEnchantments.FROST_ASPECT) > 0 && event.getEntity().m_146890_()) {
                this.ModifyDamageBaseOne(event, 0.1 * (double)mainHandItem.getEnchantmentLevel((Enchantment)EnigmaticAddonEnchantments.FROST_ASPECT));
            }
            if (mainHandItem.m_150930_((Item)EnigmaticAddonItems.DISASTER_SWORD)) {
                double modifier = 0.0;
                if (player.m_21023_(MobEffects.f_19594_)) {
                    modifier += (double)(player.m_21124_(MobEffects.f_19594_).m_19564_() + 1) * DisasterSword.badOmenBoost.getValue();
                }
                if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"DisasterCounterattack", (int)0) > 0) {
                    modifier += DisasterSword.counterattackBoost.getValue();
                }
                this.ModifyDamageBaseOne(event, modifier);
            }
            if (mainHandItem.m_150930_((Item)EnigmaticAddonItems.EVIL_DAGGER) && !SuperpositionHandler.isTheCursedOne((Player)player)) {
                event.setCanceled(true);
                return;
            }
            if (mainHandItem.m_150930_((Item)EnigmaticAddonItems.THE_BLESS)) {
                LivingEntity entity2 = event.getEntity();
                this.ModifyDamageBaseOne(event, Math.min(1.0f, (float)entity2.m_20094_() * 0.0015f));
                if (event.getEntity() instanceof Monster || event.getEntity() instanceof EnderDragon) {
                    event.setAmount(event.getAmount() / CursedRing.monsterDamageDebuff.getValue().asModifierInverted());
                }
            }
        }
        if ((mainHandItem = event.getEntity()) instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)mainHandItem), (Item)EnigmaticAddonItems.ETHERIUM_CORE)) {
            float counterattack = (float)Math.min((double)(event.getAmount() * EtheriumCore.damageConversion.getValue().asModifier() + player.getPersistentData().m_128457_("EtheriumCounterattack")), EtheriumCore.damageConversionMax.getValue());
            player.getPersistentData().m_128350_("EtheriumCounterattack", counterattack);
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        block63: {
            LivingEntity attacker;
            LivingEntity victim;
            float amount;
            block65: {
                DamageSource source;
                block64: {
                    Entity attacker22;
                    Entity damageBoost2;
                    ItemStack mainHandItem;
                    Player player;
                    Entity flag2;
                    amount = event.getAmount();
                    if (event.getAmount() >= Float.MAX_VALUE) {
                        return;
                    }
                    victim = event.getEntity();
                    source = event.getSource();
                    Entity entity = source.m_7639_();
                    if (entity instanceof LivingEntity && SuperAddonHandler.isCurseBoosted(attacker = (LivingEntity)entity) && attacker instanceof Monster && SuperAddonHandler.isCurseBoosted(attacker)) {
                        boolean flag2;
                        boolean bl = flag2 = attacker.f_19789_ > 0.0f && !attacker.m_20096_() && !attacker.m_6147_() && !attacker.m_20069_() && !attacker.m_21023_(MobEffects.f_19610_) && !attacker.m_20159_();
                        if (flag2) {
                            if (!victim.m_9236_().f_46443_) {
                                ((ServerLevel)victim.m_9236_()).m_7726_().m_8394_((Entity)attacker, (Packet)new ClientboundAnimatePacket((Entity)victim, 4));
                            }
                            attacker.m_9236_().m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), SoundEvents.f_12313_, attacker.m_5720_(), 1.0f, 1.0f);
                            this.ModifyDamageBaseOne(event, 0.5);
                        }
                    }
                    if ((flag2 = event.getSource().m_7640_()) instanceof Player) {
                        player = (Player)flag2;
                        if (event.getSource().m_276093_(EnigmaticAddonDamageTypes.FALSE_JUSTICE)) {
                            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.VOID_PEARL)) {
                                event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, VoidPearl.witheringTime.getValue(), VoidPearl.witheringLevel.getValue(), false, true));
                            }
                            if (player instanceof ServerPlayer) {
                                if (player.m_21205_().m_150930_((Item)EnigmaticItems.ENDER_SLAYER)) {
                                    LivingEntity livingEntity = event.getEntity();
                                    if (livingEntity instanceof ServerPlayer) {
                                        ServerPlayer targetPlayer = (ServerPlayer)livingEntity;
                                        targetPlayer.m_36335_().m_41524_(Items.f_42584_, 400);
                                        targetPlayer.m_36335_().m_41524_((Item)EnigmaticItems.RECALL_POTION, 400);
                                        targetPlayer.m_36335_().m_41524_((Item)EnigmaticItems.TWISTED_MIRROR, 400);
                                        if (SuperpositionHandler.hasCurio((LivingEntity)targetPlayer, (Item)EnigmaticItems.EYE_OF_NEBULA) || SuperpositionHandler.hasCurio((LivingEntity)targetPlayer, (Item)EnigmaticItems.THE_CUBE)) {
                                            SuperpositionHandler.setSpellstoneCooldown((Player)targetPlayer, (int)400);
                                        }
                                    }
                                    if (event.getEntity() instanceof EnderMan || event.getEntity() instanceof Shulker) {
                                        event.getEntity().getPersistentData().m_128405_("ELTeleportBlock", 400);
                                    }
                                }
                                if (!player.m_21205_().m_41619_()) {
                                    float damageBoost2 = 0.0f;
                                    mainHandItem = player.m_21205_();
                                    if (mainHandItem.m_150930_((Item)EnigmaticItems.THE_TWIST)) {
                                        if (OmniconfigHandler.isBossOrPlayer((LivingEntity)event.getEntity())) {
                                            damageBoost2 += event.getAmount() * TheTwist.bossDamageBonus.getValue().asModifier(false);
                                        }
                                    } else if (mainHandItem.m_150930_((Item)EnigmaticItems.THE_INFINITUM)) {
                                        if (SuperpositionHandler.isTheWorthyOne((Player)player)) {
                                            if (OmniconfigHandler.isBossOrPlayer((LivingEntity)event.getEntity())) {
                                                damageBoost2 += event.getAmount() * TheInfinitum.bossDamageBonus.getValue().asModifier(false);
                                            }
                                        } else {
                                            event.setCanceled(true);
                                            player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 160, 3, false, true));
                                            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 500, 3, false, true));
                                            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300, 3, false, true));
                                            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 3, false, true));
                                            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 300, 3, false, true));
                                            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 3, false, true));
                                        }
                                    } else if (mainHandItem.m_150930_((Item)EnigmaticItems.ENDER_SLAYER) && EnigmaticItems.ENDER_SLAYER.isEndDweller(event.getEntity())) {
                                        if (player.m_9236_().m_46472_().equals((Object)EnigmaticLegacy.PROXY.getEndKey())) {
                                            if (event.getEntity() instanceof EnderMan && RegisteredMeleeAttack.getRegisteredAttackStregth((LivingEntity)player) >= 1.0f) {
                                                event.setAmount((event.getAmount() + 100.0f) * 10.0f);
                                            }
                                            event.getEntity().getPersistentData().m_128379_("EnderSlayerVictim", true);
                                        }
                                        damageBoost2 += event.getAmount() * EnderSlayer.endDamageBonus.getValue().asModifier(false);
                                    }
                                    if (damageBoost2 != 0.0f) {
                                        event.setAmount(event.getAmount() + damageBoost2);
                                    }
                                }
                            }
                        }
                    }
                    if ((damageBoost2 = source.m_7639_()) instanceof Player) {
                        player = (Player)damageBoost2;
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL)) {
                            ItemStack itemstack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL);
                            this.ModifyDamageBaseOne(event, CursedXPScroll.getLevelModifier(itemstack) / 100.0 * CursedXPScroll.damageBoostLimit.getValue());
                        }
                        if (!SuperAddonHandler.findBookInBag(player, (Item)EnigmaticItems.THE_ACKNOWLEDGMENT).m_41619_()) {
                            victim.m_20254_(3);
                        }
                        if (!SuperAddonHandler.findBookInBag(player, (Item)EnigmaticItems.THE_TWIST).m_41619_() && SuperpositionHandler.isTheCursedOne((Player)player) && OmniconfigHandler.isBossOrPlayer((LivingEntity)event.getEntity())) {
                            this.ModifyDamageBaseOne(event, 0.1f);
                        }
                        if (!SuperAddonHandler.findBookInBag(player, (Item)EnigmaticItems.THE_INFINITUM).m_41619_() && SuperpositionHandler.isTheWorthyOne((Player)player) && OmniconfigHandler.isBossOrPlayer((LivingEntity)event.getEntity())) {
                            this.ModifyDamageBaseOne(event, 0.2f);
                        }
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.THUNDER_SCROLL)) {
                            if (player.m_21205_().canPerformAction(ToolActions.SWORD_SWEEP)) {
                                int electric = victim.getPersistentData().m_128451_("Electric");
                                victim.getPersistentData().m_128405_("Electric", electric + 60 + player.m_217043_().m_188503_(80) + (int)(event.getAmount() * 10.0f));
                            }
                            event.setAmount(ThunderScroll.modify(victim, event.getAmount()));
                        }
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.HELL_BLADE_CHARM)) {
                            float damageMultiplier = HellBladeCharm.damageMultiplier.getValue().asModifier();
                            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM)) {
                                damageMultiplier += SuperpositionHandler.getMissingHealthPool((Player)player) * (float)BerserkEmblem.attackDamage.getValue() / 4.0f;
                            }
                            this.ModifyDamageBaseOne(event, (NEMESIS_LIST.stream().anyMatch(arg_0 -> ((DamageSource)source).m_276093_(arg_0)) ? 1.0f : 0.5f) * damageMultiplier);
                        }
                        if (SuperAddonHandler.isTheBlessedOne(player)) {
                            ItemStack stack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
                            this.ModifyDamageBaseOne(event, BlessRing.damageBoost.getValue().asModifier(false) * BlessRing.Helper.getDamageModifier(stack));
                        }
                        if (player instanceof ServerPlayer && SuperpositionHandler.isTheCursedOne((Player)player) && TotemOfMalice.isEnable(player, false) && (victim instanceof Raider || TotemOfMalice.extraRaiderList.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)victim.m_6095_())))) {
                            this.ModifyDamageBaseOne(event, TotemOfMalice.raiderBoost.getValue());
                        }
                    }
                    if (victim instanceof Player) {
                        player = (Player)victim;
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.NIGHT_SCROLL) && NightScroll.isDark(player)) {
                            this.ModifyDamageBaseOne(event, -NightScroll.averageDamageResistance.getValue().asModifier(false) * NightScroll.getDarkModifier(player));
                        }
                        if (TotemOfMalice.isEnable(player, false) && (victim instanceof Raider || TotemOfMalice.extraRaiderList.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)victim.m_6095_())))) {
                            this.ModifyDamageBaseOne(event, -TotemOfMalice.raiderResistance.getValue());
                        }
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.HELL_BLADE_CHARM)) {
                            this.ModifyDamageBaseOne(event, 0.1f);
                            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM)) {
                                float resistance = SuperpositionHandler.getMissingHealthPool((Player)player) * (float)BerserkEmblem.damageResistance.getValue();
                                event.setAmount(event.getAmount() * (1.0f - resistance / 2.0f) / (1.0f - resistance));
                                if (SuperAddonHandler.isTheBlessedOne(player)) {
                                    BlessRing.Helper.addBetrayal(player, 3);
                                }
                            }
                        }
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING)) {
                            ItemStack stack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
                            event.setAmount(event.getAmount() * (1.0f - BlessRing.damageResistance.getValue().asModifier() * BlessRing.Helper.getResistanceModifier(stack)));
                        }
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BROKEN_RING)) {
                            event.setAmount(event.getAmount() * 0.9f);
                        }
                        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.FORGOTTEN_ICE) && (mainHandItem = source.m_7639_()) instanceof LivingEntity) {
                            LivingEntity attacker22 = (LivingEntity)mainHandItem;
                            if (NEMESIS_LIST.stream().anyMatch(arg_0 -> ((DamageSource)source).m_276093_(arg_0)) && attacker22.m_142079_()) {
                                if (!attacker22.m_9236_().f_46443_) {
                                    ((ServerLevel)attacker22.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_175821_, attacker22.m_20185_(), attacker22.m_20186_(), attacker22.m_20189_(), 20, (double)(attacker22.m_20205_() / 2.0f), (double)attacker22.m_20206_(), (double)(attacker22.m_20205_() / 2.0f), 0.0);
                                }
                                attacker22.m_6469_(attacker22.m_269291_().m_269298_(DamageTypes.f_268444_, (Entity)player), 3.0f);
                                attacker22.m_146917_(attacker22.m_146891_());
                            }
                        }
                    }
                    if (!((attacker22 = source.m_7639_()) instanceof LivingEntity)) break block63;
                    attacker = (LivingEntity)attacker22;
                    if (SuperpositionHandler.hasCurio((LivingEntity)attacker, (Item)EnigmaticAddonItems.FORGOTTEN_ICE)) break block64;
                    if (!attacker.m_21023_((MobEffect)EnigmaticAddonEffects.FROZEN_HEART_EFFECT)) break block65;
                }
                if (NEMESIS_LIST.stream().anyMatch(arg_0 -> ((DamageSource)source).m_276093_(arg_0)) && victim.m_142079_()) {
                    victim.m_146917_(victim.m_146888_() + 70);
                }
                if (victim.m_146890_()) {
                    this.ModifyDamageBaseOne(event, ForgottenIce.frostBoost.getValue().asModifier(false));
                }
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)attacker, (Item)EnigmaticAddonItems.REVIVAL_LEAF)) {
                victim.m_147207_(new MobEffectInstance(MobEffects.f_19614_, RevivalLeaf.poisonTime.getValue(), RevivalLeaf.poisonLevel.getValue(), false, true), (Entity)attacker);
            }
            if (attacker instanceof Stray && victim.m_142079_() && SuperAddonHandler.isCurseBoosted(attacker)) {
                victim.m_146917_(victim.m_146888_() + 65 + Mth.m_14143_((float)(amount * 10.0f)));
            }
            if (attacker instanceof MagmaCube && SuperAddonHandler.isCurseBoosted(attacker)) {
                victim.m_20254_(4);
            }
            if (attacker instanceof Phantom && SuperAddonHandler.isCurseBoosted(attacker)) {
                victim.m_147207_(new MobEffectInstance(MobEffects.f_19613_, 200, 1), (Entity)attacker);
            }
            if (attacker instanceof OwnableEntity) {
                Player owner;
                LivingEntity livingEntity;
                TamableAnimal ta;
                OwnableEntity pet = (OwnableEntity)attacker;
                if ((!(attacker instanceof TamableAnimal) || (ta = (TamableAnimal)attacker).m_21824_()) && (livingEntity = pet.m_269323_()) instanceof Player && (BlessRing.Helper.betrayalAvailable(owner = (Player)livingEntity) || SuperpositionHandler.isTheCursedOne((Player)owner)) && SuperpositionHandler.hasItem((Player)owner, (Item)EnigmaticAddonItems.SANGUINARY_HANDBOOK) && owner.m_9236_() == pet.m_9236_() && owner.m_20270_((Entity)attacker) <= (float)HunterGuidebook.effectiveDistance.getValue()) {
                    double damageMultiplier = SanguinaryHandbook.DamageMultiplier.getValue();
                    if (SuperpositionHandler.hasCurio((LivingEntity)owner, (Item)EnigmaticItems.BERSERK_CHARM)) {
                        if (SuperAddonHandler.isTheBlessedOne(owner)) {
                            BlessRing.Helper.addBetrayal(owner, 2);
                        }
                        damageMultiplier += (double)(0.5f * (SuperpositionHandler.getMissingHealthPool((Player)owner) * (float)BerserkEmblem.attackDamage.getValue()));
                    }
                    if (SuperpositionHandler.hasCurio((LivingEntity)owner, (Item)EnigmaticItems.CURSED_SCROLL)) {
                        damageMultiplier += (double)(0.75f * ((float)SuperpositionHandler.getCurseAmount((Player)owner) * CursedScroll.damageBoost.getValue().asModifier()));
                    }
                    this.ModifyDamageBaseOne(event, damageMultiplier);
                    if (SuperAddonHandler.isTheBlessedOne(owner)) {
                        BlessRing.Helper.addBetrayal(owner, 2);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityDamage(LivingDamageEvent event) {
        EnderDragon dragon;
        Player player;
        LivingEntity victim = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (victim instanceof Player) {
            Drowned drowned;
            player = (Player)victim;
            if (SuperAddonHandler.isTheBlessedOne(player) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM)) {
                BlessRing.Helper.addBetrayal(player, 2);
            }
            if (attacker instanceof Drowned && SuperAddonHandler.isCurseBoosted((LivingEntity)(drowned = (Drowned)attacker))) {
                int airSupply = player.m_20146_();
                int air = (double)airSupply * 0.4 < 30.0 ? airSupply - 30 : Mth.m_14107_((double)((double)airSupply * 0.6));
                player.m_20301_(Math.max(air, 0));
            }
            if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.THE_BLESS)) {
                player.f_19802_ = TheBless.invulnerableTime.getValue();
            }
            ItemCooldowns cooldowns = player.m_36335_();
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.EARTH_PROMISE) && !cooldowns.m_41519_((Item)EnigmaticAddonItems.EARTH_PROMISE)) {
                float damage = event.getAmount();
                if (SuperpositionHandler.isTheCursedOne((Player)player)) {
                    damage *= EarthPromise.totalResistance.getValue().asModifierInverted();
                }
                if (player.m_6084_() && !event.getSource().m_269533_(DamageTypeTags.f_268738_) && damage >= player.m_21223_() * EarthPromise.abilityTriggerPercent.getValue().asModifier(false)) {
                    cooldowns.m_41524_((Item)EnigmaticAddonItems.EARTH_PROMISE, EarthPromise.cooldown.getValue());
                    if (!player.m_9236_().m_5776_()) {
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123747_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123810_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 36, 0.1, 0.1, 0.1, 0.2);
                        player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_11897_, SoundSource.PLAYERS, 5.0f, 1.5f);
                    }
                    player.m_7292_(new MobEffectInstance((MobEffect)EnigmaticAddonEffects.PURE_RESISTANCE_EFFECT, 100, 4));
                    event.setCanceled(true);
                } else {
                    event.setAmount(damage);
                }
            }
        }
        if (victim.m_21023_((MobEffect)EnigmaticAddonEffects.PURE_RESISTANCE_EFFECT)) {
            int amplifier = victim.m_21124_((MobEffect)EnigmaticAddonEffects.PURE_RESISTANCE_EFFECT).m_19564_();
            if (victim.m_217043_().m_188503_(5) <= amplifier) {
                event.setCanceled(true);
            } else {
                event.setAmount(event.getAmount() * 0.2f * (float)(4 - amplifier));
            }
        }
        if (victim.m_21023_((MobEffect)EnigmaticAddonEffects.ICHOR_CORROSION_EFFECT)) {
            int amplifier = victim.m_21124_((MobEffect)EnigmaticAddonEffects.ICHOR_CORROSION_EFFECT).m_19564_() + 1;
            event.setAmount(event.getAmount() * (1.0f + (float)amplifier * 0.1f));
        }
        if (victim instanceof EnderDragon && SuperAddonHandler.isCurseBoosted((LivingEntity)(dragon = (EnderDragon)victim))) {
            int boostLevel = SuperAddonHandler.getEnderDragonBoostLevel(dragon);
            event.setAmount(event.getAmount() * (1.05f - (float)boostLevel * 0.05f));
        }
        event.setAmount(event.getAmount() * (1.0f + RedemptionCurseEnchantment.modify(victim)));
        if (SuperpositionHandler.hasCurio((LivingEntity)victim, (Item)EnigmaticAddonItems.QUARTZ_RING)) {
            if (EnigmaticAddonItems.QUARTZ_RING.resistanccList.stream().anyMatch(arg_0 -> ((DamageSource)event.getSource()).m_276093_(arg_0))) {
                event.setAmount(event.getAmount() * (1.0f - QuartzRing.magicResistance.getValue().asModifier(false)));
            }
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)victim, (Item)EnigmaticAddonItems.LOST_ENGINE) && event.getSource().m_269533_(DamageTypeTags.f_268725_)) {
            if (victim instanceof ServerPlayer) {
                player = (ServerPlayer)victim;
                for (NonNullList compartment : player.m_150109_().f_35979_) {
                    for (ItemStack itemStack : compartment) {
                        double modifier;
                        double d = modifier = itemStack.m_41720_() instanceof ArmorItem ? 1.0 : 1.4;
                        if (itemStack.m_220157_((int)((double)itemStack.m_41776_() * modifier), player.m_217043_(), (ServerPlayer)player)) {
                            itemStack.m_41774_(1);
                            player.m_36246_(Stats.f_12983_.m_12902_((Object)itemStack.m_41720_()));
                            itemStack.m_41721_(0);
                            continue;
                        }
                        if (!itemStack.m_41782_() || !itemStack.m_41783_().m_128471_("Unbreakable")) continue;
                        itemStack.m_41784_().m_128473_("Unbreakable");
                    }
                }
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(arg_0 -> AddonEventHandler.lambda$onEntityDamage$3((ServerPlayer)player, arg_0));
            }
            event.setAmount(event.getAmount() * (float)(victim.m_217043_().m_188503_(4) + 4) + victim.m_21233_());
        }
        if (attacker instanceof Player) {
            player = (Player)attacker;
            if (SuperAddonHandler.isTheBlessedOne(player) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.BERSERK_CHARM)) {
                BlessRing.Helper.addBetrayal(player, 2);
            }
            if (!player.m_9236_().f_46443_ && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.HELL_BLADE_CHARM)) {
                if (NEMESIS_LIST.stream().anyMatch(arg_0 -> ((DamageSource)event.getSource()).m_276093_(arg_0))) {
                    float healthPer = victim.m_21223_() * (SuperpositionHandler.isTheCursedOne((Player)player) ? HellBladeCharm.killCursedThreshold.getValue().asModifier() : HellBladeCharm.killThreshold.getValue().asModifier());
                    if (event.getAmount() >= healthPer && !ForgeRegistries.ENTITY_TYPES.getKey((Object)victim.m_6095_()).m_135815_().contains("dummy")) {
                        player.m_5634_((float)((double)victim.m_21223_() * HellBladeCharm.healMultiplier.getValue()));
                        event.setAmount(Math.min(event.getAmount() * 10.0f, 3.4028235E37f));
                        player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 2.0f);
                    }
                }
            }
        }
        float amount = event.getAmount();
        Entity compartment = event.getSource().m_7640_();
        if (compartment instanceof Player) {
            Player player2 = (Player)compartment;
            float lifesteal = 0.0f;
            if (SuperpositionHandler.hasCurio((LivingEntity)player2, (Item)EnigmaticAddonItems.NIGHT_SCROLL) && NightScroll.isDark(player2) && SuperpositionHandler.isTheCursedOne((Player)player2)) {
                lifesteal += amount * NightScroll.averageLifeSteal.getValue().asModifier(false) * NightScroll.getDarkModifier(player2);
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player2, (Item)EnigmaticAddonItems.SCORCHED_CHARM) && victim.m_6060_()) {
                lifesteal += amount * ScorchedCharm.lifestealModifier.getValue().asModifier(false);
            }
            if (!SuperAddonHandler.findBookInBag(player2, (Item)EnigmaticItems.THE_INFINITUM).m_41619_() && SuperpositionHandler.isTheWorthyOne((Player)player2)) {
                lifesteal += amount * 0.1f;
            }
            if (lifesteal > 0.0f) {
                player2.m_5634_(lifesteal);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity target;
        Blaze blaze;
        LivingEntity entity = event.getEntity();
        Entity sourceEntity = event.getSource().m_7639_();
        if (entity instanceof Blaze && SuperAddonHandler.isCurseBoosted((LivingEntity)(blaze = (Blaze)entity))) {
            RandomSource random = blaze.m_217043_();
            for (int i = 0; i < 15; ++i) {
                SmallFireball fireball = new SmallFireball(blaze.m_9236_(), (LivingEntity)blaze, random.m_188583_(), (double)random.m_188501_() - 0.6, random.m_188583_());
                fireball.m_6034_(fireball.m_20185_(), blaze.m_20227_(0.5) + 0.5, fireball.m_20189_());
                fireball.m_5602_((Entity)blaze);
                blaze.m_9236_().m_7967_((Entity)fireball);
            }
        }
        if (!OmniconfigAddonHandler.NearDeathAnger.getValue()) {
            return;
        }
        if (entity instanceof Mob && SuperAddonHandler.isCurseBoosted(entity) && sourceEntity instanceof LivingEntity && (target = (LivingEntity)sourceEntity).m_6084_()) {
            Player player;
            if (target instanceof Player && ((player = (Player)target).m_7500_() || player.m_5833_())) {
                return;
            }
            List entities = entity.m_9236_().m_45976_(entity.getClass(), entity.m_20191_().m_82400_(16.0));
            for (LivingEntity near : entities) {
                Mob mob;
                if (!(near instanceof Mob) || (mob = (Mob)near) == entity || !mob.m_6084_() || mob.m_5448_() != null) continue;
                if (mob.m_20280_((Entity)entity) < 12.0) {
                    mob.m_6710_(target);
                    continue;
                }
                Vec3 viewVector = mob.m_20252_(0.0f);
                Vec3 subtract = entity.m_20182_().m_82546_(mob.m_20182_());
                if (!(subtract.m_82526_(viewVector) > 0.0)) continue;
                mob.m_6710_(target);
            }
        }
    }

    @SubscribeEvent
    public void onMobGriefing(EntityMobGriefingEvent event) {
        Blaze blaze;
        Entity entity = event.getEntity();
        if (entity instanceof Blaze && !(blaze = (Blaze)entity).m_6084_()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onConfirmedDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.isCanceled()) {
                POSTMORTAL_POSSESSIONS.removeAll((Object)player);
                return;
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL)) {
                ItemStack curioStack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL);
                ItemNBTHelper.setInt((ItemStack)curioStack, (String)"XPStored", (int)0);
            }
            if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BROKEN_RING)) {
                POSTMORTAL_POSSESSIONS.put((Object)player, (Object)EnigmaticAddonItems.BROKEN_RING);
            }
            if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.BLESS_STONE) && !SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticItems.CURSED_STONE) && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticItems.CURSED_RING)) {
                POSTMORTAL_POSSESSIONS.put((Object)player, (Object)EnigmaticAddonItems.BLESS_STONE);
                for (List list : player.m_150109_().f_35979_) {
                    for (ItemStack itemstack : list) {
                        if (itemstack.m_41619_() || itemstack.m_41720_() != EnigmaticAddonItems.BLESS_STONE) continue;
                        itemstack.m_41764_(0);
                    }
                }
                LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(player.m_9236_());
                if (lightningbolt != null) {
                    lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)player.m_20183_()));
                    lightningbolt.m_20879_((ServerPlayer)(player instanceof ServerPlayer ? player : null));
                    player.m_9236_().m_7967_((Entity)lightningbolt);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        ServerPlayer player;
        Level level = event.getEntity().m_9236_();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && POSTMORTAL_POSSESSIONS.containsKey((Object)(player = (ServerPlayer)livingEntity)) && POSTMORTAL_POSSESSIONS.containsEntry((Object)player, (Object)EnigmaticAddonItems.BROKEN_RING)) {
            DimensionalPosition dimPoint;
            boolean hasCurse;
            boolean bl = hasCurse = EnigmaticEventHandler.POSTMORTAL_POSESSIONS.containsKey((Object)player) && EnigmaticEventHandler.POSTMORTAL_POSESSIONS.containsEntry((Object)player, (Object)EnigmaticItems.CURSED_RING);
            if (hasCurse) {
                return;
            }
            boolean hadEscapeScroll = EnigmaticEventHandler.POSTMORTAL_POSESSIONS.containsKey((Object)player) && EnigmaticEventHandler.POSTMORTAL_POSESSIONS.containsEntry((Object)player, (Object)EnigmaticItems.ESCAPE_SCROLL);
            DimensionalPosition dimensionalPosition = dimPoint = hadEscapeScroll ? SuperpositionHandler.getRespawnPoint((ServerPlayer)player) : new DimensionalPosition(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_9236_());
            if (SuperpositionHandler.canDropSoulCrystal((Player)player, (boolean)true)) {
                ItemStack soulCrystal = EnigmaticItems.SOUL_CRYSTAL.createCrystalFrom((Player)player);
                PermanentItemEntity droppedSoulCrystal = new PermanentItemEntity(dimPoint.world, dimPoint.getPosX(), dimPoint.getPosY() + 1.5, dimPoint.getPosZ(), soulCrystal);
                droppedSoulCrystal.setOwnerId(player.m_20148_());
                dimPoint.world.m_7967_((Entity)droppedSoulCrystal);
                EnigmaticLegacy.LOGGER.info("Teared Soul Crystal from " + player.m_36316_().getName() + " at X: " + dimPoint.getPosX() + ", Y: " + dimPoint.getPosY() + ", Z: " + dimPoint.getPosZ());
                SoulArchive.getInstance().addItem(droppedSoulCrystal);
            }
            if (SuperpositionHandler.isPermanentlyDead((Player)player)) {
                EnigmaticLegacy.packetInstance.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketPermadeath());
                SuperpositionHandler.setCurrentWorldFractured((boolean)true);
            }
            POSTMORTAL_POSSESSIONS.removeAll((Object)player);
        } else {
            livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player2 = (Player)livingEntity;
                POSTMORTAL_POSSESSIONS.removeAll((Object)player2);
            }
        }
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent event) {
        EnderDragon dragon;
        LivingEntity entity = event.getEntity();
        if (entity.getPersistentData().m_128471_("RevivingPoisoned")) {
            event.setAmount(event.getAmount() * 0.25f);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (SuperpositionHandler.hasCurio((LivingEntity)entity, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL)) {
                ItemStack itemstack = SuperpositionHandler.getCurioStack((LivingEntity)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL);
                event.setAmount(event.getAmount() * (float)(1.0 + CursedXPScroll.getLevelModifier(itemstack) / 100.0 * CursedXPScroll.healBoostLimit.getValue()));
            }
        }
        if (entity instanceof EnderDragon && SuperAddonHandler.isCurseBoosted((LivingEntity)(dragon = (EnderDragon)entity))) {
            int boostLevel = SuperAddonHandler.getEnderDragonBoostLevel(dragon);
            event.setAmount(event.getAmount() * (1.0f + (float)boostLevel * 0.05f));
        }
    }

    @SubscribeEvent
    public void onCurioDrops(DropRulesEvent event) {
        boolean confirm;
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && POSTMORTAL_POSSESSIONS.containsKey((Object)(player = (ServerPlayer)livingEntity)) && POSTMORTAL_POSSESSIONS.containsEntry((Object)player, (Object)EnigmaticAddonItems.BLESS_STONE) && (confirm = true)) {
            event.addOverride(stack -> stack != null && (stack.m_150930_((Item)EnigmaticItems.CURSED_RING) || stack.m_150930_((Item)EnigmaticItems.DESOLATION_RING)), ICurio.DropRule.DESTROY);
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                IItemHandlerModifiable curios = handler.getEquippedCurios();
                for (int i = 0; i < handler.getSlots() - 1; ++i) {
                    ICursed iCursed;
                    ItemStack stackInSlot = curios.getStackInSlot(i);
                    if (stackInSlot == null) continue;
                    if (stackInSlot.m_41720_() == EnigmaticItems.CURSED_RING) {
                        ItemStack stack = EnigmaticAddonItems.BLESS_RING.m_7968_();
                        BlessRing.Helper.setBlessLevel((Player)player, stack);
                        curios.setStackInSlot(i, stack);
                        continue;
                    }
                    Item patt62138$temp = stackInSlot.m_41720_();
                    if ((!(patt62138$temp instanceof ICursed) || (iCursed = (ICursed)patt62138$temp) instanceof IBlessed) && !(stackInSlot.m_41720_() instanceof IEldritch)) continue;
                    PermanentItemEntity itemEntity = new PermanentItemEntity(player.m_9236_(), player.m_20208_(4.0), player.m_20187_(), player.m_20262_(4.0), stackInSlot);
                    itemEntity.m_146915_(true);
                    player.m_9236_().m_7967_((Entity)itemEntity);
                    curios.setStackInSlot(i, ItemStack.f_41583_);
                }
            });
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12556_, SoundSource.PLAYERS, 1.0f, 0.5f);
            SuperpositionHandler.setPersistentBoolean((Player)player, (String)"DestroyedCursedRing", (boolean)true);
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (SuperpositionHandler.hasCurio((LivingEntity)entity, (Item)EnigmaticAddonItems.LOST_ENGINE)) {
            entity.m_246865_(new Vec3(0.0, 0.1214, 0.0));
            if (entity.m_6047_()) {
                float rot = entity.m_146908_() * (float)Math.PI / 180.0f;
                float sin = -Mth.m_14031_((float)rot) * 0.055f;
                float cos = Mth.m_14089_((float)rot) * 0.055f;
                entity.m_246865_(new Vec3((double)(sin * 3.0f), 0.45, (double)(cos * 3.0f)));
                for (int i = 0; i < 5; ++i) {
                    float width = entity.m_20205_();
                    entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, entity.m_20208_((double)width), entity.m_20186_() + (double)RANDOM.nextFloat(width), entity.m_20262_(0.5), (double)sin, (double)RANDOM.nextFloat(0.12f) + 0.05, (double)cos);
                }
            }
        }
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
        int frostLevel;
        Player player = event.getEntity();
        Entity target = event.getTarget();
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.LOST_ENGINE)) {
            event.setDamageModifier(event.getDamageModifier() + LostEngine.critModifier.getValue().asModifier());
        }
        if ((frostLevel = player.m_21205_().getEnchantmentLevel((Enchantment)EnigmaticAddonEnchantments.FROST_SHATTERING)) > 0 && target.m_146890_()) {
            event.setDamageModifier(event.getDamageModifier() + (float)frostLevel * 0.4f);
            if (event.isVanillaCritical()) {
                target.m_146917_(target.m_146891_() + target.m_146888_());
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    float width = target.m_20205_();
                    serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Blocks.f_50568_)), target.m_20185_(), target.m_20188_(), target.m_20189_(), 16, (double)width, 0.0, (double)width, 0.05);
                }
            }
        }
        if (event.isVanillaCritical() && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"DisasterCounterattack", (int)0) > 0 && player.m_21205_().m_150930_((Item)EnigmaticAddonItems.DISASTER_SWORD)) {
                event.setDamageModifier((float)((double)event.getDamageModifier() + DisasterSword.critBoost.getValue()));
                living.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                EnigmaticAddons.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(target.m_20185_(), target.m_20186_(), target.m_20189_(), 64.0, target.m_9236_().m_46472_())), (Object)new PacketDisasterParry(target.m_20185_(), target.m_20186_(), target.m_20189_(), 2));
            }
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        boolean flag;
        Player player = event.getEntity();
        boolean bl = flag = player.m_20096_() && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.THUNDER_SCROLL);
        if (flag && player.m_21205_().canPerformAction(ToolActions.SWORD_SWEEP) && !player.m_36335_().m_41519_((Item)EnigmaticAddonItems.THUNDER_SCROLL)) {
            EnigmaticAddons.packetInstance.send(PacketDistributor.SERVER.noArg(), (Object)new PacketEmptyLeftClick(true));
        }
    }

    @SubscribeEvent
    public void onLivingKnockback(LivingKnockBackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && SuperAddonHandler.isAbyssBoost(player = (Player)livingEntity)) {
            event.setStrength(event.getStrength() / CursedRing.knockbackDebuff.getValue().asModifier());
        }
    }

    @SubscribeEvent
    public void onCursed(LivingCurseBoostEvent event) {
        Vex vex;
        Zombie absZombie;
        AttributeInstance attribute;
        if (!OmniconfigAddonHandler.EnableCurseBoost.getValue()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Player worthy = event.getTheWorthyOne();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        String boost = "CurseAttributeBoost";
        if (entity instanceof Zombie && (attribute = (absZombie = (Zombie)entity).m_21051_(Attributes.f_22284_)) != null) {
            attribute.m_22125_(new AttributeModifier(UUID_ARMOR, boost, 5.0, AttributeModifier.Operation.ADDITION));
        }
        if (entity.getClass() == Zombie.class) {
            if (entity.m_21205_().m_41619_() && entity.m_217043_().m_188503_(5) == 0) {
                entity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42000_, entity.m_217043_().m_188503_(4) + 3));
            } else if (entity.m_21205_().m_41619_() && entity.m_217043_().m_188503_(8) == 0) {
                entity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42423_));
            }
        }
        if (entity.getClass() == Drowned.class && entity.m_217043_().m_188503_(100) <= 5 && entity.m_21205_().m_41619_()) {
            entity.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42713_));
        }
        if (entity instanceof Creeper) {
            LightningBolt lightningbolt;
            Creeper creeper = (Creeper)entity;
            if (entity.m_217043_().m_188503_(100) <= 5 && !creeper.m_7090_() && (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(creeper.m_9236_())) != null) {
                lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)creeper.m_20183_()));
                lightningbolt.m_20225_(creeper.m_217043_().m_188499_());
                lightningbolt.m_20049_("HarmlessThunder");
                lightningbolt.setDamage(0.0f);
                creeper.m_9236_().m_7967_((Entity)lightningbolt);
            }
        }
        if (entity instanceof IronGolem && worthy != null && !worthy.m_150110_().f_35937_) {
            worthy.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 50, 4));
        }
        if (entity instanceof Evoker) {
            Evoker evoker = (Evoker)entity;
            evoker.m_21008_(InteractionHand.MAIN_HAND, Items.f_42747_.m_7968_());
            attribute = evoker.m_21051_(Attributes.f_22285_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR_TH, boost, 8.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof Vindicator) {
            Vindicator vindicator = (Vindicator)entity;
            vindicator.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 60));
        }
        if (entity instanceof EnderDragon) {
            EnderDragon dragon = (EnderDragon)entity;
            attribute = dragon.m_21051_(Attributes.f_22282_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ATTACK_KB, boost, 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if ((attribute = dragon.m_21051_(Attributes.f_22284_)) != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR, boost, 10.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof Ravager) {
            Ravager ravager = (Ravager)entity;
            attribute = ravager.m_21051_(Attributes.f_22284_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR, boost, 10.0, AttributeModifier.Operation.ADDITION));
            }
            if ((attribute = ravager.m_21051_(Attributes.f_22285_)) != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR_TH, boost, 10.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof Vex && (vex = (Vex)entity).getClass() == Vex.class) {
            vex.m_8061_(EquipmentSlot.OFFHAND, vex.m_6844_(EquipmentSlot.MAINHAND));
            vex.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
            vex.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
            vex.m_21409_(EquipmentSlot.CHEST, -1.0f);
            vex.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 120, 1));
            vex.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 40));
        }
        if (entity instanceof Blaze) {
            Blaze blaze = (Blaze)entity;
            attribute = blaze.m_21051_(Attributes.f_22281_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ATTACK, boost, 2.0, AttributeModifier.Operation.ADDITION));
            }
            if ((attribute = blaze.m_21051_(Attributes.f_22282_)) != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ATTACK_KB, boost, 1.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof AbstractPiglin) {
            AbstractPiglin piglin = (AbstractPiglin)entity;
            attribute = piglin.m_21051_(Attributes.f_22281_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ATTACK, boost, 2.0, AttributeModifier.Operation.ADDITION));
            }
            if ((attribute = piglin.m_21051_(Attributes.f_22284_)) != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR, boost, 8.0, AttributeModifier.Operation.ADDITION));
            }
            if ((attribute = piglin.m_21051_(Attributes.f_22285_)) != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR_TH, boost, 4.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            attribute = slime.m_21051_(Attributes.f_22282_);
            int size = slime.m_33632_();
            if (size > 2) {
                slime.m_7839_(Mth.m_14165_((double)((double)size * 1.2)), true);
            }
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ATTACK_KB, boost, 1.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof MagmaCube) {
            MagmaCube magma = (MagmaCube)entity;
            attribute = magma.m_21051_(Attributes.f_22284_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR, boost, 3.0, AttributeModifier.Operation.ADDITION));
            }
            if ((attribute = magma.m_21051_(Attributes.f_22285_)) != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ARMOR_TH, boost, 4.0, AttributeModifier.Operation.ADDITION));
            }
        }
        if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            phantom.m_33108_(phantom.m_33172_() + 2);
            attribute = phantom.m_21051_(Attributes.f_22281_);
            if (attribute != null) {
                attribute.m_22125_(new AttributeModifier(UUID_ATTACK, boost, 2.0, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @SubscribeEvent
    public void onXPOrb(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        if (SuperpositionHandler.hasItem((Player)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL) || SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.CURSED_XP_SCROLL)) {
            ExperienceOrb orb = event.getOrb();
            orb.f_20770_ = orb.m_20801_() / 5;
        }
    }

    @SubscribeEvent
    public void miningStuff(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        float miningModifier = 0.0f;
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.EARTH_PROMISE)) {
            miningModifier += EarthPromise.breakSpeedBonus.getValue().asModifier();
        }
        event.setNewSpeed(event.getOriginalSpeed() * miningModifier + event.getNewSpeed());
        if (!(!SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.ADVENTURE_CHARM) || player.m_6047_() && AdventureCharm.shiftEnable.getValue())) {
            event.setCanceled(true);
        }
        if (SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.DESPAIR_INSIGNIA)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player = event.getEntity();
        if (!(player == null || player.m_9236_().f_46443_ || event.getInventory().m_18947_((Item)EnigmaticAddonItems.BLESS_AMPLIFIER) != 1 && event.getCrafting().m_41720_() != EnigmaticAddonItems.BLESS_STONE)) {
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, (float)((double)0.9f + Math.random() * (double)0.1f));
        }
        if (player != null && !player.m_9236_().f_46443_ && event.getInventory().m_18947_((Item)EnigmaticItems.ABYSSAL_HEART) > 0 && EnigmaticAddons.Acceptors.contains(player.m_20148_()) && !SuperpositionHandler.getPersistentBoolean((Player)player, (String)"AbyssKnightExtra", (boolean)false)) {
            Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (ItemStack)EnigmaticItems.ABYSSAL_HEART.m_7968_());
            SuperpositionHandler.setPersistentBoolean((Player)player, (String)"AbyssKnightExtra", (boolean)true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        Player player = event.getPlayer();
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.m_41619_() && !right.m_41619_()) {
            ItemStack copy = left.m_41777_();
            if (player != null && EnigmaticAddonItems.FORGER_GEM.isPresent(player) && SuperAddonHandler.isOKOne(player)) {
                boolean check;
                boolean bl = check = left.m_41763_() && !ForgerGem.blackList.contains(ForgeRegistries.ITEMS.getKey((Object)left.m_41720_()));
                if (check && ForgerGem.strictUnbreakableForge.getValue()) {
                    boolean bl2 = check = left.isRepairable() && (left.m_41720_() instanceof TieredItem || left.m_41720_() instanceof ArmorItem);
                }
                if (player.m_150110_().f_35937_ && left.m_41763_()) {
                    check = true;
                }
                if (left.m_150930_(right.m_41720_()) && check && left.m_41773_() == 0 && right.m_41773_() == 0 && !left.m_41793_() && !right.m_41793_()) {
                    copy = left.m_41777_();
                    copy.m_41700_("Unbreakable", (Tag)ByteTag.m_128273_((boolean)true));
                    copy.m_41742_(copy.m_41610_() + 8);
                    if (!event.getName().isEmpty()) {
                        copy.m_41714_((Component)Component.m_237113_((String)event.getName()));
                    }
                    event.setOutput(copy);
                    event.setCost(30);
                }
            }
            if (left.m_150930_((Item)EnigmaticAddonItems.TOTEM_OF_MALICE) && right.m_150930_((Item)EnigmaticItems.EVIL_ESSENCE)) {
                int maxLevel = left.getEnchantmentLevel(Enchantments.f_44986_) + 2;
                if (TotemOfMalice.getTotemPower(left) < maxLevel) {
                    TotemOfMalice.setTotemPower(copy, maxLevel);
                    int specialCost = TotemOfMalice.getSpecialCost(left);
                    copy.m_41742_(copy.m_41610_() + 2 + specialCost);
                    TotemOfMalice.setSpecialCost(copy, specialCost + 1);
                    event.setOutput(copy);
                    event.setCost(1 + copy.m_41610_() + specialCost - 2);
                    event.setMaterialCost(1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent event) {
        Player player = event.getEntity();
        if (player != null && !player.m_9236_().f_46443_ && SuperpositionHandler.hasCurio((LivingEntity)player, (Item)EnigmaticAddonItems.FORGER_GEM)) {
            event.setBreakChance(event.getBreakChance() / 6.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDrops(LivingDropsEvent event) {
        Player player;
        Entity entity;
        DamageSource source = event.getSource();
        if (event.isRecentlyHit() && source != null && (entity = source.m_7639_()) instanceof Player && (SuperpositionHandler.isTheCursedOne((Player)(player = (Player)entity)) || BlessRing.Helper.specialLooting(player))) {
            LivingEntity killed = event.getEntity();
            BlockPos blockPos = killed.m_20183_();
            int lootingLevel = ForgeHooks.getLootingLevel((Entity)killed, (Entity)player, (DamageSource)source);
            if (killed.m_9236_().m_46472_() == EnigmaticLegacy.PROXY.getOverworldKey() && !killed.m_9236_().m_45527_(blockPos) && blockPos.m_123342_() <= 0 && killed instanceof Monster && RANDOM.nextInt(1000) < 30 + lootingLevel * 15) {
                this.addDrop(event, new ItemStack((ItemLike)EnigmaticAddonItems.EARTH_HEART_FRAGMENT));
            }
            if (!CursedRing.enableSpecialDrops.getValue() || !player.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
                return;
            }
            if (OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.ICHOR_DROPLET)) {
                this.addEntityDropWithChance(event, Ghast.class, new ItemStack((ItemLike)EnigmaticAddonItems.ICHOR_DROPLET), 60);
                this.addEntityDropWithChance(event, Ghast.class, new ItemStack((ItemLike)EnigmaticAddonItems.ICHOR_DROPLET), 40);
            }
            if (BlessRing.Helper.specialLooting(player)) {
                if (killed.getClass() == Shulker.class) {
                    this.addDropWithChance(event, new ItemStack((ItemLike)EnigmaticItems.ASTRAL_DUST, 1), 20);
                } else if (killed.getClass() == Skeleton.class || killed.getClass() == Stray.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42412_, 3, 15));
                } else if (killed.getClass() == Zombie.class || killed.getClass() == Husk.class) {
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42518_, 1, 3), 25);
                } else if (killed.getClass() == Spider.class || killed.getClass() == CaveSpider.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42401_, 2, 12));
                } else if (killed.getClass() == Guardian.class) {
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42715_, 1), 15);
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42696_, 2, 5));
                } else if (killed instanceof ElderGuardian) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42696_, 4, 16));
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42695_, 7, 28));
                    this.addOneOf(event, new ItemStack((ItemLike)Items.f_42716_, 1), new ItemStack((ItemLike)Items.f_42437_, 1), new ItemStack((ItemLike)Items.f_42545_, 1), EnchantmentHelper.m_220292_((RandomSource)killed.m_217043_(), (ItemStack)new ItemStack((ItemLike)Items.f_42713_, 1), (int)(25 + RANDOM.nextInt(15)), (boolean)true));
                } else if (killed.getClass() == EnderMan.class) {
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42545_, 1, 2), 40);
                } else if (killed.getClass() == Blaze.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42593_, 0, 5));
                } else if (killed.getClass() == ZombifiedPiglin.class) {
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42417_, 1, 3), 40);
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42525_, 1, 7), 30);
                } else if (killed.getClass() == Witch.class) {
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42586_, 1), 30);
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42714_, 1, 3), 50);
                } else if (killed.getClass() == Pillager.class || killed.getClass() == Vindicator.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42616_, 0, 4));
                } else if (killed.getClass() == Villager.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42616_, 2, 6));
                } else if (killed.getClass() == Creeper.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42403_, 4, 12));
                } else if (killed.getClass() == PiglinBrute.class) {
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42419_, 1), 20);
                } else if (killed.getClass() == Evoker.class) {
                    this.addDrop(event, new ItemStack((ItemLike)Items.f_42747_, 1));
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42616_, 5, 20));
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42437_, 1), 10);
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42584_, 1, 3), 30);
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42585_, 2, 4), 30);
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42612_, 4, 10), 50);
                } else if (killed.getClass() == WitherSkeleton.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42593_, 0, 3));
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42586_, 1), 20);
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42419_, 1), 7);
                } else if (killed.getClass() == Ghast.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42714_, 1, 4));
                } else if (killed.getClass() == Drowned.class) {
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42534_, 1, 3), 30);
                } else if (killed.getClass() == Vex.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42525_, 0, 2));
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42714_, 1), 30);
                } else if (killed.getClass() == Piglin.class) {
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42417_, 2, 4), 50);
                } else if (killed.getClass() == Ravager.class) {
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42616_, 3, 10));
                    this.addDrop(event, this.getRandomSizeStack(Items.f_42454_, 2, 7));
                    this.addDropWithChance(event, this.getRandomSizeStack(Items.f_42415_, 0, 4), 50);
                } else if (killed.getClass() == MagmaCube.class) {
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42593_, 1), 50);
                } else if (killed.getClass() == Chicken.class) {
                    this.addDropWithChance(event, new ItemStack((ItemLike)Items.f_42521_, 1), 50);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLootTablesLoaded(LootTableLoadEvent event) {
        LootTable modified;
        LootPool poolSpellstones;
        if (!OmniconfigHandler.customDungeonLootEnabled.getValue()) {
            return;
        }
        if (SuperAddonHandler.getIceDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool((String)"addon_spellstones", (float)-5.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.FORGOTTEN_ICE, 20)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        }
        if (SuperAddonHandler.getLeafDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool((String)"addon_spellstones", (float)-5.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.REVIVAL_LEAF, 50)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        }
        if (SuperAddonHandler.getEngineDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool((String)"addon_spellstones", (float)-15.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.LOST_ENGINE, 75)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        }
        if (SuperAddonHandler.getSoulDungeons().contains(event.getName())) {
            LootPool poolCharms = SuperpositionHandler.constructLootPool((String)"addon_spellstones", (float)-14.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.ILLUSION_LANTERN, 75)});
            modified = event.getTable();
            modified.addPool(poolCharms);
            event.setTable(modified);
        }
        if (SuperpositionHandler.getEnderDungeons().contains(event.getName())) {
            poolSpellstones = SuperpositionHandler.constructLootPool((String)"addon_spellstones", (float)-13.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperpositionHandler.createOptionalLootEntry((Item)EnigmaticItems.ASTRAL_DUST, (int)82), SuperpositionHandler.createOptionalLootEntry((Item)EnigmaticItems.VOID_PEARL, (int)18)});
            modified = event.getTable();
            modified.addPool(poolSpellstones);
            event.setTable(modified);
        }
        if (SuperpositionHandler.getOverworldDungeons().contains(event.getName())) {
            LootPool antiqueLegacy = SuperpositionHandler.constructLootPool((String)"addon_legacy", (float)-10.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.ARTIFICIAL_FLOWER, 10), SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.ANTIQUE_BAG, 20), SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.FORGER_GEM, 35)});
            modified = event.getTable();
            modified.addPool(antiqueLegacy);
            event.setTable(modified);
        }
        if (SuperpositionHandler.getNetherDungeons().contains(event.getName())) {
            LootPool ichor = SuperpositionHandler.constructLootPool((String)"ichor", (float)-6.0f, (float)2.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.ICHOR_DROPLET, 75, 1.0f, 3.0f)});
            modified = event.getTable();
            modified.addPool(ichor);
            event.setTable(modified);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLootTablesPreLoaded(@NotNull LootTableLoadEvent event) {
        LootTable modified = event.getTable();
        if (SuperpositionHandler.getOverworldDungeons().contains(event.getName())) {
            LootPool earth_bonus = SuperpositionHandler.constructLootPool((String)"earth_bonus", (float)-1.0f, (float)1.0f, (LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{SuperpositionHandler.getWaterDungeons().contains(event.getName()) || event.getName().equals((Object)BuiltInLootTables.f_78696_) ? null : SuperAddonHandler.createOptionalLootEntry((Item)EnigmaticAddonItems.EARTH_HEART_FRAGMENT, 50, 1.0f, 2.0f)});
            modified.addPool(earth_bonus);
            event.setTable(modified);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Vex vex;
        AbstractSkeleton skeleton;
        Zombie zombie;
        AbstractIllager illager;
        Pillager pillager;
        Spider spider;
        int priority;
        if (!OmniconfigAddonHandler.EnableCurseBoost.getValue()) {
            return;
        }
        Entity entity = event.getEntity();
        Predicate<WrappedGoal> meleeOrBow = goal -> goal.m_26015_() instanceof MeleeAttackGoal || goal.m_26015_() instanceof RangedCrossbowAttackGoal || goal.m_26015_() instanceof RangedBowAttackGoal;
        if (entity instanceof Spider && (priority = AddonEventHandler.getGoalPriority((Mob)(spider = (Spider)entity), meleeOrBow)) >= 0) {
            spider.f_21345_.m_25352_(priority, (Goal)new SpiderRangedAttackGoal((Monster)spider, 0.5, 30, 8.0f));
        }
        if (entity instanceof Pillager && (priority = AddonEventHandler.getGoalPriority((Mob)(pillager = (Pillager)entity), goal -> goal.m_26015_() instanceof RangedCrossbowAttackGoal) - 1) >= 0) {
            pillager.f_21345_.m_25352_(priority, new CrossbowBlazeAttackGoal<Pillager>(pillager, 1.05, 8.5f));
        }
        if (entity instanceof AbstractIllager && (priority = AddonEventHandler.getGoalPriority((Mob)(illager = (AbstractIllager)entity), meleeOrBow) - 1) >= 0) {
            illager.f_21345_.m_25352_(priority, (Goal)new LeapAttackGoal((PathfinderMob)illager, 0.5));
        }
        if (entity instanceof Zombie && (priority = AddonEventHandler.getGoalPriority((Mob)(zombie = (Zombie)entity), meleeOrBow) - 1) >= 0) {
            zombie.f_21345_.m_25352_(priority, (Goal)new LeapAttackGoal((PathfinderMob)zombie, 0.36));
        }
        if (entity instanceof AbstractSkeleton && (priority = AddonEventHandler.getGoalPriority((Mob)(skeleton = (AbstractSkeleton)entity), meleeOrBow)) >= 1) {
            skeleton.f_21345_.m_25352_(priority - 1, (Goal)new SkeletonMeleeAttackGoal((Monster)skeleton));
        }
        if (entity instanceof Ghast) {
            Ghast ghast = (Ghast)entity;
            ghast.f_21345_.m_25352_(7, (Goal)new GhastMultishotGoal(ghast));
        }
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            animal.f_21345_.m_25352_(5, (Goal)new AvoidTheWorthyGoal(animal, 6.0f, 1.25, 1.25));
        }
        if (entity instanceof Vex && (vex = (Vex)entity).m_19749_() != null && SuperAddonHandler.isCurseBoosted((LivingEntity)vex.m_19749_())) {
            SuperAddonHandler.setCurseBoosted((LivingEntity)vex, true, null);
        }
    }

    @SubscribeEvent
    public void onWandererTradesEvent(WandererTradesEvent event) {
        List rareTrades = event.getRareTrades();
        rareTrades.add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)EnigmaticAddonItems.EARTH_HEART_FRAGMENT), new ItemStack((ItemLike)Items.f_42616_, 20), new ItemStack((ItemLike)EnigmaticItems.EARTH_HEART), 1, 5, 0.2f));
        rareTrades.add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)EnigmaticAddonItems.EARTH_HEART_FRAGMENT), 2, 5, 0.25f));
    }

    private void ModifyDamageBaseOne(LivingHurtEvent event, double multiplier) {
        if (multiplier == 0.0) {
            return;
        }
        event.setAmount(event.getAmount() * (1.0f + (float)multiplier));
    }

    public ItemStack getRandomSizeStack(Item item, int minAmount, int maxAmount) {
        return new ItemStack((ItemLike)item, minAmount + RANDOM.nextInt(maxAmount - minAmount + 1));
    }

    public void addOneOf(LivingDropsEvent event, ItemStack ... itemStacks) {
        int chosenStack = RANDOM.nextInt(itemStacks.length);
        this.addDrop(event, itemStacks[chosenStack]);
    }

    public void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), drop);
        itemEntity.m_32010_(10);
        event.getDrops().add(itemEntity);
    }

    public void addDropWithChance(LivingDropsEvent event, ItemStack drop, int chance) {
        if (RANDOM.nextInt(100) < chance) {
            this.addDrop(event, drop);
        }
    }

    public <T extends LivingEntity> void addEntityDropWithChance(LivingDropsEvent event, Class<T> entity, ItemStack drop, int chance) {
        if (entity == event.getEntity().getClass()) {
            this.addDropWithChance(event, drop, chance);
        }
    }

    @SubscribeEvent
    public void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(AntiqueBagCapability.ID_INVENTORY, AntiqueBagCapability.createProvider((LivingEntity)player));
            event.addCapability(EtheriumShieldCapability.ID_ETHERIUM_SHIELD_DATA, EtheriumShieldCapability.createProvider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        Player original = event.getOriginal();
        original.revive();
        if (SuperpositionHandler.isTheCursedOne((Player)original)) {
            player.getPersistentData().m_128379_("CursedNextSpawn", true);
        }
        if (SuperAddonHandler.isTheBlessedOne(original)) {
            player.getPersistentData().m_128379_("BlessNextSpawn", true);
        }
        if (SuperpositionHandler.isTheWorthyOne((Player)original)) {
            player.getPersistentData().m_128379_("WorthyNextSpawn", true);
        }
        LazyOptional<IAntiqueBagHandler> oldHandler = SuperAddonHandler.getCapability(original, AntiqueBagCapability.INVENTORY);
        LazyOptional<IAntiqueBagHandler> newHandler = SuperAddonHandler.getCapability(player, AntiqueBagCapability.INVENTORY);
        oldHandler.ifPresent(oldBag -> newHandler.ifPresent(newBag -> newBag.readTag(oldBag.writeTag())));
        IPlaytimeCounter oldCounter = IPlaytimeCounter.get((Player)original);
        IPlaytimeCounter newCounter = IPlaytimeCounter.get((Player)player);
        newCounter.deserializeNBT(oldCounter.serializeNBT());
    }

    @SubscribeEvent
    public void onLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (SuperpositionHandler.isTheCursedOne((Player)event.getEntity())) {
            event.getEntity().getPersistentData().m_128379_("CursedNextSpawn", true);
        }
        if (SuperpositionHandler.isTheWorthyOne((Player)event.getEntity())) {
            event.getEntity().getPersistentData().m_128379_("WorthyNextSpawn", true);
        }
        if (SuperAddonHandler.isTheBlessedOne(event.getEntity())) {
            event.getEntity().getPersistentData().m_128379_("BlessNextSpawn", true);
        }
    }

    private boolean check() {
        int[] c = new int[]{101, 110, 105, 103, 109, 97, 116, 105, 99, 116, 119, 101, 97, 107};
        StringBuilder s = new StringBuilder();
        for (int aByte : c) {
            s.append((char)aByte);
        }
        return ModList.get().isLoaded(s.toString());
    }

    private static /* synthetic */ void lambda$onEntityDamage$3(ServerPlayer player, ICuriosItemHandler handler) {
        int slots = handler.getEquippedCurios().getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = handler.getEquippedCurios().getStackInSlot(i);
            if (stackInSlot.m_150930_((Item)EnigmaticAddonItems.BLESS_RING) || stackInSlot.m_150930_((Item)EnigmaticItems.CURSED_RING) || !stackInSlot.m_220157_(stackInSlot.m_41776_() * 3 / 2, player.m_217043_(), player)) continue;
            stackInSlot.m_41774_(1);
            player.m_36246_(Stats.f_12983_.m_12902_((Object)stackInSlot.m_41720_()));
            stackInSlot.m_41721_(0);
        }
    }
}

