/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.IEldritch;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.CursedRing;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class ViolenceScroll
extends ItemBaseCurio
implements IEldritch {
    public static Omniconfig.PerhapsParameter invulnerableModifier;
    public static Omniconfig.PerhapsParameter invulnerableHealMultiplier;
    public static Omniconfig.PerhapsParameter boostPerCurseModifier;
    public static Omniconfig.PerhapsParameter baseCurseModifier;
    public static Omniconfig.PerhapsParameter attackSpeed;
    public static Omniconfig.PerhapsParameter entityReach;
    public static Omniconfig.DoubleParameter knockbackResistance;
    public static Omniconfig.IntParameter maxDurability;

    public ViolenceScroll() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC).m_41486_());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CurseofViolence");
        baseCurseModifier = builder.comment("The base damage boost for curse absorbed. Measured as percentage.").getPerhaps("BaseCurseModifier", 10);
        boostPerCurseModifier = builder.comment("The damage boost per every curse absorbed. Measured as percentage.").max(100.0).getPerhaps("BoostPerCurseModifier", 5);
        invulnerableModifier = builder.comment("Attack Damage Modifier when attack during the invulnerable time provided by the Curse of Violence. Measured as percentage.").min(100.0).getPerhaps("InvulnerableAttackModifier", 200);
        invulnerableHealMultiplier = builder.comment("The heal multiplier when attack during the invulnerable time provided by the Curse of Violence. Measured as percentage.").max(100.0).getPerhaps("InvulnerableHealMultiplier", 40);
        attackSpeed = builder.comment("Attack speed increase provided by the Curse of Violence for absorbed curse. Measured as percentage.").min(1.0).max(10.0).getPerhaps("AttackSpeedBoost", 4);
        entityReach = builder.comment("Entity reach range increase provided by the Curse of Violence for absorbed curse. Measured as percentage.").min(1.0).max(10.0).getPerhaps("EntityReachBoost", 3);
        knockbackResistance = builder.comment("Knockback Resistance increase provided by the Curse of Violence for absorbed curse.").getDouble("KnockbackResistanceBoost", 0.025);
        maxDurability = builder.comment("The max energy count of the Curse of Violence.").min(100.0).getInt("MaxDurability", 200);
        builder.popPrefix();
    }

    private Multimap<Attribute, AttributeModifier> createAttributeMap(ItemStack stack) {
        HashMultimap attributesDefault = HashMultimap.create();
        int curseCount = Helper.getCurseCount(stack);
        attributesDefault.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(UUID.fromString("ff757a7d-89ca-4c86-ba12-2c6bc64670ab"), "attack_speed_modifier", (double)((float)curseCount * attackSpeed.getValue().asModifier()), AttributeModifier.Operation.MULTIPLY_BASE));
        attributesDefault.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.fromString("f1b26193-c0bb-40fe-91df-31b38f037643"), "knockback_resistance_modifier", (double)curseCount * knockbackResistance.getValue(), AttributeModifier.Operation.ADDITION));
        attributesDefault.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(UUID.fromString("2bbb5508-d8d7-45fc-8158-6206c24f48c9"), "entity_reach_modifier", (double)((float)curseCount * entityReach.getValue().asModifier()), AttributeModifier.Operation.MULTIPLY_BASE));
        return attributesDefault;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll1", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("%.01f%%", Helper.getStoreModifier(stack))});
        int curseCount = Helper.getCurseCount(stack);
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + invulnerableModifier + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll4", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{invulnerableHealMultiplier + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScrollCount", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{curseCount});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            if (curseCount > 0) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll7", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + curseCount * attackSpeed.getValue().asPercentage() + "%"});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll8", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{"+" + curseCount * entityReach.getValue().asPercentage() + "%"});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll9", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{String.format("+%.02f", (double)curseCount * knockbackResistance.getValue())});
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.indicateWorthyOnesOnly(list);
            if (Minecraft.m_91087_().f_91074_ != null && SuperAddonHandler.isAbyssBoost((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.abyssBoost");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll10");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScroll11");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.violenceScrollCount", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{curseCount});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.indicateCursedOnesOnly(list);
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int i, boolean selected) {
        Player player;
        if (entity instanceof Player && SuperpositionHandler.isTheWorthyOne((Player)(player = (Player)entity))) {
            Helper.setOwner(stack, player);
            Map curses = EnchantmentHelper.m_44831_((ItemStack)stack);
            curses.keySet().removeIf(enchantment -> !enchantment.m_6589_());
            if (!curses.isEmpty()) {
                Map leftover = EnchantmentHelper.m_44831_((ItemStack)stack);
                leftover.keySet().removeIf(Enchantment::m_6589_);
                Helper.addCurse(stack, curses.keySet());
                Helper.addDurability(stack, 15 * curses.size());
                EnchantmentHelper.m_44865_((Map)leftover, (ItemStack)stack);
            }
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Helper.setOwner(stack, player);
            Map curses = EnchantmentHelper.m_44831_((ItemStack)stack);
            curses.keySet().removeIf(enchantment -> !enchantment.m_6589_());
            if (!curses.isEmpty()) {
                Map leftover = EnchantmentHelper.m_44831_((ItemStack)stack);
                leftover.keySet().removeIf(Enchantment::m_6589_);
                Helper.addCurse(stack, curses.keySet());
                Helper.addDurability(stack, 15 * curses.size());
                EnchantmentHelper.m_44865_((Map)leftover, (ItemStack)stack);
            }
            player.m_21204_().m_22178_(this.createAttributeMap(stack));
        }
    }

    public void onUnequip(SlotContext context, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Helper.setDamage(stack, 0.0f);
            player.m_21204_().m_22161_(this.createAttributeMap(stack));
        }
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        LivingEntity livingEntity;
        if (super.canEquip(context, stack) && (livingEntity = context.entity()) instanceof Player) {
            Player player = (Player)livingEntity;
            return SuperpositionHandler.isTheWorthyOne((Player)player);
        }
        return false;
    }

    public boolean m_142522_(ItemStack stack) {
        return Helper.getOwnerUUID(stack) != null;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)Helper.getDurability(stack) * 13.0f / (float)maxDurability.getValue());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)Helper.getDurability(stack) / (float)maxDurability.getValue());
        return 0xFF000000 | (int)(f * 128.0f + 127.0f) << 16;
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        ItemStack other;
        if (!SuperpositionHandler.isTheWorthyOne((Player)player)) {
            return super.m_142207_(stack, slot, action, player);
        }
        if (action != ClickAction.PRIMARY && slot.m_5857_(stack) && slot.m_8010_(player) && slot.m_6657_() && Helper.canDisenchant(stack, other = slot.m_7993_())) {
            slot.m_5852_(Helper.disenchant(stack, other));
            if (player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.2f + (float)Math.random() * 0.4f);
            }
            return true;
        }
        return super.m_142207_(stack, slot, action, player);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (!SuperpositionHandler.isTheWorthyOne((Player)player)) {
            return super.m_142305_(stack, other, slot, action, player, access);
        }
        if (action != ClickAction.PRIMARY && slot.m_5857_(stack) && slot.m_8010_(player) && !other.m_41619_() && Helper.canDisenchant(stack, other)) {
            access.m_142104_(Helper.disenchant(stack, other));
            if (player.m_9236_().f_46443_) {
                player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 0.8f, 1.2f + (float)Math.random() * 0.4f);
            }
            return true;
        }
        return super.m_142305_(stack, other, slot, action, player, access);
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.m_6084_() || entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.getPersistentData().m_128471_("ViolenceSevenCurses") && !SuperpositionHandler.hasCurio((LivingEntity)entity, (Item)EnigmaticItems.CURSED_RING)) {
            ArrayListMultimap attributeMap = ArrayListMultimap.create();
            attributeMap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(UUID.fromString("457d0ac3-69e4-482f-b636-22e0802da6bd"), "enigmaticlegacy:armor_modifier", (double)(-CursedRing.armorDebuff.getValue().asModifier()), AttributeModifier.Operation.MULTIPLY_TOTAL));
            attributeMap.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(UUID.fromString("95e70d83-3d50-4241-a835-996e1ef039bb"), "enigmaticlegacy:armor_toughness_modifier", (double)(-CursedRing.armorDebuff.getValue().asModifier()), AttributeModifier.Operation.MULTIPLY_TOTAL));
            entity.m_21204_().m_22178_((Multimap)attributeMap);
            List genericMobs = entity.m_9236_().m_45976_(LivingEntity.class, SuperpositionHandler.getBoundingBoxAroundEntity((Entity)entity, (double)CursedRing.neutralAngerRange.getValue()));
            for (LivingEntity mob : genericMobs) {
                TamableAnimal tamable;
                double visibility = entity.m_20968_((Entity)mob);
                double angerDistance = Math.max(CursedRing.neutralAngerRange.getValue() * visibility, CursedRing.neutralXRayRange.getValue());
                if (!entity.m_142582_((Entity)mob) && !((double)entity.m_20270_((Entity)mob) <= CursedRing.neutralXRayRange.getValue()) || !(mob.m_20275_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()) <= angerDistance * angerDistance) || !(mob instanceof NeutralMob)) continue;
                NeutralMob neutral = (NeutralMob)mob;
                if (CursedRing.neutralAngerBlacklist.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_())) || neutral instanceof TamableAnimal && (tamable = (TamableAnimal)neutral).m_21824_() || neutral == entity || neutral.m_5448_() != null && neutral.m_5448_().m_6084_() || !entity.m_142582_((Entity)mob) && !((double)entity.m_20270_((Entity)mob) <= CursedRing.neutralXRayRange.getValue())) continue;
                neutral.m_6710_(entity);
            }
        }
    }

    @SubscribeEvent
    public void onHurt(LivingHurtEvent event) {
        UUID uuid;
        Entity curio;
        LivingEntity entity;
        LivingEntity victim = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity && SuperpositionHandler.hasCurio((LivingEntity)(entity = (LivingEntity)entity2), (Item)this)) {
            UUID storeUUID;
            curio = SuperpositionHandler.getCurioStack((LivingEntity)entity, (Item)this);
            uuid = victim.m_20148_();
            if (uuid.equals(storeUUID = Helper.getStoreUUID((ItemStack)curio))) {
                Player player;
                double addon = (double)Helper.getStoreDamage((ItemStack)curio) * Helper.getStoreModifier((ItemStack)curio) * (double)0.01f;
                if (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) {
                    Player player2;
                    if (entity instanceof Player && SuperAddonHandler.isAbyssBoost(player2 = (Player)entity)) {
                        if (entity.m_217043_().m_188503_(4) == 0) {
                            Helper.addDurability((ItemStack)curio, -1);
                        }
                    } else if (entity.m_217043_().m_188503_(3) == 0) {
                        Helper.addDurability((ItemStack)curio, -1);
                    }
                }
                event.setAmount(event.getAmount() + (float)addon);
                if (Helper.getDurability((ItemStack)curio) == 0 && entity.m_217043_().m_188503_(8) == 0) {
                    CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(arg_0 -> ViolenceScroll.lambda$onHurt$3(entity, (ItemStack)curio, arg_0));
                }
            } else {
                Helper.setUUID((ItemStack)curio, uuid);
            }
            if (entity.f_19802_ > 0) {
                entity.m_5634_(event.getAmount() * invulnerableHealMultiplier.getValue().asModifier());
                event.setAmount(event.getAmount() * invulnerableModifier.getValue().asModifier(true));
                entity.f_19802_ = 0;
            }
        }
        if ((curio = event.getSource().m_7639_()) instanceof LivingEntity && (entity = (LivingEntity)curio).getPersistentData().m_128471_("ViolenceSevenCurses") && !SuperpositionHandler.hasCurio((LivingEntity)victim, (Item)EnigmaticItems.CURSED_RING)) {
            event.setAmount(event.getAmount() * (1.0f - CursedRing.monsterDamageDebuff.getValue().asModifier() / 2.0f));
        }
        if (victim.getPersistentData().m_128471_("ViolenceSevenCurses") && !SuperpositionHandler.hasCurio((LivingEntity)victim, (Item)EnigmaticItems.CURSED_RING)) {
            event.setAmount(event.getAmount() * ((CursedRing.painMultiplier.getValue().asModifier() - 1.0f) / 2.0f + 1.0f));
        }
        if (event.getEntity() instanceof Monster || event.getEntity() instanceof EnderDragon) {
            Player player;
            Mob mob = (Mob)event.getEntity();
            uuid = event.getSource().m_7639_();
            if (uuid instanceof Player && SuperpositionHandler.hasCurio((LivingEntity)(player = (Player)uuid), (Item)this) && SuperAddonHandler.isAbyssBoost(player) && !player.m_21205_().m_150930_((Item)EnigmaticItems.THE_TWIST) && !player.m_21205_().m_150930_((Item)EnigmaticItems.THE_INFINITUM) && !player.m_21205_().m_150930_(EnigmaticItems.ELDRITCH_PAN)) {
                float modifier = CursedRing.monsterDamageDebuff.getValue().asModifier();
                event.setAmount(event.getAmount() / (1.0f - modifier) * (1.0f - modifier / 2.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAttackLast(LivingDamageEvent event) {
        LivingEntity entity;
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof LivingEntity && SuperpositionHandler.hasCurio((LivingEntity)(entity = (LivingEntity)entity2), (Item)this)) {
            Player player;
            UUID storeUUID;
            ItemStack curio = SuperpositionHandler.getCurioStack((LivingEntity)entity, (Item)this);
            UUID uuid = event.getEntity().m_20148_();
            if (uuid.equals(storeUUID = Helper.getStoreUUID(curio))) {
                Helper.setDamage(curio, event.getAmount());
            }
            if (entity instanceof Player && SuperAddonHandler.isAbyssBoost(player = (Player)entity)) {
                event.getEntity().getPersistentData().m_128379_("ViolenceSevenCurses", true);
            }
        }
    }

    private static /* synthetic */ void lambda$onHurt$3(LivingEntity entity, ItemStack curio, ICuriosItemHandler curiosItemHandler) {
        int slots = curiosItemHandler.getEquippedCurios().getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = curiosItemHandler.getEquippedCurios().getStackInSlot(i);
            if (entity.m_217043_().m_188503_(4) != 0 || !EnchantmentHelper.m_44831_((ItemStack)stackInSlot).keySet().stream().anyMatch(Enchantment::m_6589_)) continue;
            Map leftover = EnchantmentHelper.m_44831_((ItemStack)stackInSlot);
            boolean[] yummy = new boolean[]{true};
            leftover.keySet().removeIf(enchant -> {
                if (yummy[0] && enchant.m_6589_()) {
                    yummy[0] = false;
                    return true;
                }
                return false;
            });
            EnchantmentHelper.m_44865_((Map)leftover, (ItemStack)stackInSlot);
            Helper.addDurability(curio, 30);
        }
    }

    public static class Helper {
        public static void addDurability(ItemStack stack, int d) {
            int durability = Helper.getDurability(stack);
            stack.m_41784_().m_128405_("Durability", Mth.m_14045_((int)(durability + d), (int)0, (int)maxDurability.getValue()));
        }

        public static int getDurability(ItemStack stack) {
            return stack.m_41782_() ? stack.m_41783_().m_128451_("Durability") : 0;
        }

        public static UUID getOwnerUUID(ItemStack stack) {
            return stack.m_41782_() && stack.m_41783_().m_128403_("LastHolder") ? stack.m_41783_().m_128342_("LastHolder") : null;
        }

        public static void setOwner(ItemStack stack, Player player) {
            stack.m_41784_().m_128362_("LastHolder", player.m_20148_());
        }

        public static double getStoreModifier(ItemStack stack) {
            int curseCount = Helper.getCurseCount(stack);
            int minus = 0;
            float apply = curseCount * boostPerCurseModifier.getValue().asPercentage();
            apply *= (float)Helper.getDurability(stack) / (float)maxDurability.getValue();
            for (int i = 5; i <= curseCount; i += 5) {
                minus += curseCount / i;
            }
            return apply + (float)baseCurseModifier.getValue().asPercentage() - (float)minus;
        }

        public static float getStoreDamage(ItemStack stack) {
            return stack.m_41782_() ? stack.m_41783_().m_128457_("VDamage") : 0.0f;
        }

        @Nullable
        public static UUID getStoreUUID(ItemStack stack) {
            return stack.m_41782_() && stack.m_41783_().m_128403_("VTarget") ? stack.m_41783_().m_128342_("VTarget") : null;
        }

        public static void setDamage(ItemStack stack, float damage) {
            stack.m_41784_().m_128347_("VDamage", (double)damage);
        }

        public static void setUUID(ItemStack stack, UUID uuid) {
            stack.m_41784_().m_128362_("VTarget", uuid);
            Helper.setDamage(stack, 0.0f);
        }

        public static void addCurse(ItemStack stack, Collection<Enchantment> enchantmentSet) {
            ListTag tag = stack.m_41784_().m_128437_("AbsorbedCurses", 10);
            for (Enchantment enchantment : enchantmentSet) {
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128359_("id", enchantment.m_44704_());
                if (tag.contains((Object)compoundtag)) continue;
                tag.add((Object)compoundtag);
            }
            stack.m_41700_("AbsorbedCurses", (Tag)tag);
        }

        public static int getCurseCount(ItemStack stack) {
            if (!stack.m_41782_()) {
                return 0;
            }
            ListTag tag = stack.m_41784_().m_128437_("AbsorbedCurses", 10);
            return tag.size();
        }

        private static ItemStack disenchant(ItemStack scroll, ItemStack target) {
            ItemStack item = target.m_41777_();
            Item item2 = target.m_41720_();
            if (item2 instanceof EnchantedBookItem) {
                EnchantedBookItem bookItem = (EnchantedBookItem)item2;
                ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
                boolean hasLeft = false;
                ListTag enchantments = EnchantedBookItem.m_41163_((ItemStack)target);
                ArrayList<Enchantment> theCurse = new ArrayList<Enchantment>();
                for (int i = 0; i < enchantments.size(); ++i) {
                    CompoundTag compoundtag = enchantments.m_128728_(i);
                    int level = EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
                    Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compoundtag));
                    if (enchant.m_6589_()) {
                        theCurse.add(enchant);
                        continue;
                    }
                    hasLeft = true;
                    EnchantedBookItem.m_41153_((ItemStack)book, (EnchantmentInstance)new EnchantmentInstance(enchant, level));
                }
                Helper.addCurse(scroll, theCurse);
                Helper.addDurability(scroll, 20 + 30 * theCurse.size());
                return hasLeft ? book : Items.f_42517_.m_7968_();
            }
            Map transposed = EnchantmentHelper.m_44831_((ItemStack)target);
            Map leftover = EnchantmentHelper.m_44831_((ItemStack)target);
            transposed.keySet().removeIf(enchantment -> !enchantment.m_6589_());
            leftover.keySet().removeIf(Enchantment::m_6589_);
            Helper.addCurse(scroll, transposed.keySet());
            Helper.addDurability(scroll, 20 + 40 * transposed.size());
            EnchantmentHelper.m_44865_((Map)leftover, (ItemStack)item);
            return item;
        }

        private static boolean canDisenchant(ItemStack scroll, ItemStack target) {
            Objects.requireNonNull(scroll.m_41720_());
            Item item = target.m_41720_();
            if (item instanceof EnchantedBookItem) {
                EnchantedBookItem bookItem = (EnchantedBookItem)item;
                ListTag enchantments = EnchantedBookItem.m_41163_((ItemStack)target);
                for (int i = 0; i < enchantments.size(); ++i) {
                    CompoundTag compoundtag = enchantments.m_128728_(i);
                    Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compoundtag));
                    if (!enchant.m_6589_()) continue;
                    return true;
                }
                return false;
            }
            Stream stream = EnchantmentHelper.m_44831_((ItemStack)target).keySet().stream();
            return stream.anyMatch(Enchantment::m_6589_);
        }
    }
}

