/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.api.items.IBetrayed;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;

public class NightScroll
extends ItemBaseCurio
implements IBetrayed {
    public static Omniconfig.PerhapsParameter averageDamageBoost;
    public static Omniconfig.PerhapsParameter averageDamageResistance;
    public static Omniconfig.PerhapsParameter averageLifeSteal;

    public NightScroll() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC));
    }

    @SubscribeConfig
    public static void onConfig(@NotNull OmniconfigWrapper builder) {
        builder.pushPrefix("PactofDarkNight");
        averageDamageBoost = builder.comment("The average damage boost modifier provided by Pact of Dark Night.").max(100.0).getPerhaps("AverageDamageBoost", 20);
        averageDamageResistance = builder.comment("The average damage resistance modifier provided by Pact of Dark Night.").max(100.0).getPerhaps("AverageDamageResistance", 16);
        averageLifeSteal = builder.comment("The average life stealing modifier provided by Pact of Dark Night.").max(100.0).getPerhaps("AverageLifeSteal", 8);
        builder.popPrefix();
    }

    public static boolean isDark(Player player) {
        if (!SuperAddonHandler.isOKOne(player)) {
            return false;
        }
        if (player.m_21023_(MobEffects.f_216964_)) {
            return true;
        }
        LevelLightEngine lightEngine = player.m_9236_().m_5518_();
        BlockPos blockPos = player.m_20183_();
        return true;
    }

    public static float getDarkModifier(Player player) {
        if (player == null || !SuperAddonHandler.isOKOne(player)) {
            return 0.4f;
        }
        if (player.m_21023_(MobEffects.f_216964_)) {
            return 2.0f;
        }
        LevelLightEngine lightEngine = player.m_9236_().m_5518_();
        BlockPos blockPos = player.m_20183_();
        int i = 16 - lightEngine.m_75831_(blockPos, 8);
        return 0.4f + 0.1f * (float)i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.nightScroll1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.nightScroll2");
            float darkModifier = NightScroll.getDarkModifier((Player)Minecraft.m_91087_().f_91074_);
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.nightScroll3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(int)(darkModifier * (float)averageDamageBoost.getValue().asPercentage()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.nightScroll4", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(int)(darkModifier * (float)averageDamageResistance.getValue().asPercentage()) + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.nightScroll5", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(int)(darkModifier * (float)averageLifeSteal.getValue().asPercentage()) + "%"});
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        ItemLoreHelper.indicateCursedOnesOnly(list);
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && !SuperAddonHandler.isOKOne(player = (Player)livingEntity) && !player.m_7500_() && !player.m_5833_()) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 20));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        Player player;
        HashMultimap attributes = HashMultimap.create();
        LivingEntity entity = slotContext.entity();
        if (entity instanceof Player && NightScroll.isDark(player = (Player)entity)) {
            attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(UUID.fromString("6F27C266-9DCD-22DC-E491-4AF7B6A8CCF9"), "Dark Bonus", (double)(averageDamageBoost.getValue().asModifier(false) * NightScroll.getDarkModifier(player)), AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        return attributes;
    }
}

