/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.contents.gui.AntiqueBagContainerMenu;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class AntiqueBag
extends ItemBase {
    public static final List<ResourceLocation> extraBookList = new ArrayList<ResourceLocation>();

    public AntiqueBag() {
        super(ItemBase.getDefaultProperties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        extraBookList.clear();
        String[] list = builder.config.getStringList("AntiqueBookBagList", "Balance Options", new String[0], "List of items that can be stored in the Antique Book Bag. Examples: enigmaticaddons:false_justice. Changing this option required game restart to take effect.");
        Arrays.stream(list).forEach(entry -> {
            if (!entry.equals("enigmaticaddons:antique_bag")) {
                extraBookList.add(new ResourceLocation(entry));
            }
        });
    }

    public static boolean isBook(ItemStack stack) {
        return extraBookList.contains(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())) || stack.m_204117_(ItemTags.f_244646_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.antiqueBag1");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.antiqueBag2");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.antiqueBag3");
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.antiqueBag4");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        if (!world.f_46443_) {
            player.m_5893_((MenuProvider)new AntiqueBagContainerMenu.Provider());
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }
}

