/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.enchantments;

import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class RedemptionCurseEnchantment
extends Enchantment {
    public static Omniconfig.PerhapsParameter resistanceModifier;

    public RedemptionCurseEnchantment(Enchantment.Rarity rarity, EquipmentSlot[] slots) {
        super(rarity, EnchantmentCategory.ARMOR, slots);
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("CurseofRedemptionEnchantment");
        resistanceModifier = builder.comment("The damage modifier per every this curse.").max(40.0).min(0.0).getPerhaps("ResistanceModifier", 4);
        builder.popPrefix();
    }

    public static float modify(LivingEntity entity) {
        int amount = 0;
        for (ItemStack armor : entity.m_6168_()) {
            amount += SuperAddonHandler.getRedemptionCurseAmount(armor);
        }
        if (amount > 0) {
            Player player;
            float modifier = Math.min(resistanceModifier.getValue().asModifier() * (float)amount, 90.0f);
            if (entity instanceof Player && SuperAddonHandler.isTheBlessedOne(player = (Player)entity)) {
                modifier = -modifier;
            }
            return modifier;
        }
        return 0.0f;
    }

    public int m_6183_(int enchantmentLevel) {
        return 25;
    }

    public int m_6175_(int enchantmentLevel) {
        return 50;
    }

    public int m_44702_() {
        return 1;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return OmniconfigHandler.isItemEnabled((Object)((Object)this)) && super.m_6081_(stack) && SuperpositionHandler.getCurseAmount((ItemStack)stack) == 0;
    }

    public boolean m_6591_() {
        return true;
    }

    public boolean m_6589_() {
        return true;
    }

    public boolean isAllowedOnBooks() {
        return OmniconfigAddonHandler.isItemEnabled((Object)this);
    }

    public boolean m_6592_() {
        return OmniconfigAddonHandler.isItemEnabled((Object)this);
    }

    protected boolean m_5975_(Enchantment enchantment) {
        return !enchantment.m_6589_() && super.m_5975_(enchantment);
    }

    public Component m_44700_(int i) {
        MutableComponent mutablecomponent;
        Player player = EnigmaticLegacy.PROXY.getClientPlayer();
        if (player != null && SuperAddonHandler.isTheBlessedOne(player)) {
            mutablecomponent = Component.m_237115_((String)(this.m_44704_() + "_alt"));
            mutablecomponent.m_130940_(ChatFormatting.GOLD);
        } else {
            mutablecomponent = Component.m_237115_((String)this.m_44704_());
            mutablecomponent.m_130940_(ChatFormatting.RED);
        }
        return mutablecomponent;
    }
}

