/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.shearPickpocketVillager;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.util.CustomLootTables;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;
import xyz.faewulf.lib.util.entity.EntityUtils;
import xyz.faewulf.lib.util.missingMethod.ItemStackMethod;
import xyz.faewulf.lib.util.missingMethod.LivingEntityMethod;

@Mixin(value={Villager.class})
public abstract class villagerMixin
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder {
    @Unique
    private int Diversity$pickpocket_cooldown = 0;

    public villagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private static ResourceLocation diversity_Multiloader$getPickPocketLootTable(String name) {
        switch (name) {
            case "armorer": {
                return CustomLootTables.PICKPOCKET_ARMORER;
            }
            case "butcher": {
                return CustomLootTables.PICKPOCKET_BUTCHER;
            }
            case "cartographer": {
                return CustomLootTables.PICKPOCKET_CARTOGRAPHER;
            }
            case "cleric": {
                return CustomLootTables.PICKPOCKET_CLERIC;
            }
            case "farmer": {
                return CustomLootTables.PICKPOCKET_FARMER;
            }
            case "fisherman": {
                return CustomLootTables.PICKPOCKET_FISHERMAN;
            }
            case "fletcher": {
                return CustomLootTables.PICKPOCKET_FLETCHER;
            }
            case "leatherworker": {
                return CustomLootTables.PICKPOCKET_LEATHERWORKER;
            }
            case "librarian": {
                return CustomLootTables.PICKPOCKET_LIBRARIAN;
            }
            case "mason": {
                return CustomLootTables.PICKPOCKET_MASON;
            }
            case "nitwit": {
                return CustomLootTables.PICKPOCKET_NITWIT;
            }
            case "shepherd": {
                return CustomLootTables.PICKPOCKET_SHEPHERD;
            }
            case "toolsmith": {
                return CustomLootTables.PICKPOCKET_TOOLSMITH;
            }
            case "weaponsmith": {
                return CustomLootTables.PICKPOCKET_WEAPONSMITH;
            }
        }
        return CustomLootTables.PICKPOCKET_NONE;
    }

    @Shadow
    public abstract void m_34375_(VillagerData var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickInject(CallbackInfo ci) {
        if (!this.m_183595_() && ModConfigs.shear_can_pickpocket_villager && this.Diversity$pickpocket_cooldown > 0) {
            --this.Diversity$pickpocket_cooldown;
        }
    }

    @Shadow
    @NotNull
    public abstract VillagerData m_7141_();

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveDataInject(CompoundTag compound, CallbackInfo ci) {
        compound.m_128405_("diversity:pickpocket_cooldown", this.Diversity$pickpocket_cooldown);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveDataInject(CompoundTag compound, CallbackInfo ci) {
        if (compound.m_128425_("diversity:pickpocket_cooldown", 3)) {
            this.Diversity$pickpocket_cooldown = compound.m_128451_("diversity:pickpocket_cooldown");
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteractInject(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        Level level;
        if (!ModConfigs.shear_can_pickpocket_villager || this.m_9236_().f_46443_) {
            return;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && Compare.isHasTag((Item)itemStack.m_41720_(), (String)"diversity:pickpocket_tool") && this.Diversity$pickpocket_cooldown <= 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            String job = this.m_7141_().m_35571_().f_35600_();
            int jobLevel = this.m_7141_().m_35576_();
            Vec3 blockPos = this.m_20183_().m_252807_();
            LootTable loottable = serverLevel.m_7654_().m_278653_().m_278676_(villagerMixin.diversity_Multiloader$getPickPocketLootTable(job));
            LootParams lootparams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList itemStackList = loottable.m_287195_(lootparams);
            for (ItemStack stack : itemStackList) {
                ItemEntity itementity = new ItemEntity(this.m_9236_(), blockPos.f_82479_, blockPos.f_82480_, blockPos.f_82481_, stack);
                itementity.m_32060_();
                serverLevel.m_7967_((Entity)itementity);
            }
            boolean sneaky = EntityUtils.isEntity2BehindEntity1((LivingEntity)this, (LivingEntity)player);
            boolean stealth = !this.m_142582_((Entity)player) || player.m_21023_(MobEffects.f_19609_);
            float successChance = 0.3f;
            if (sneaky) {
                successChance = 0.7f;
            }
            if (stealth) {
                successChance = 1.0f;
            }
            if (this.f_19796_.m_188501_() > successChance) {
                this.m_6469_(this.m_269291_().m_269075_(player), 0.0f);
            }
            if (jobLevel == 1) {
                this.Diversity$pickpocket_cooldown = 6000;
            }
            if (jobLevel > 1 && this.f_19796_.m_188501_() > (float)jobLevel * 0.15f) {
                VillagerData old = this.m_7141_();
                this.m_34375_(new VillagerData(old.m_35560_(), VillagerProfession.f_35585_, 1));
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.5);
                this.Diversity$pickpocket_cooldown = 6000;
            }
            ItemStackMethod.hurtAndBreak((ItemStack)player.m_21120_(hand), (int)1, (LivingEntity)player, (EquipmentSlot)LivingEntityMethod.getSlotForHand((InteractionHand)hand));
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_184214_, SoundSource.PLAYERS, 1.0f, 1.0f);
            serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            cir.cancel();
        }
        if (player.m_6144_() && Compare.isHasTag((Item)itemStack.m_41720_(), (String)"diversity:pickpocket_tool") && this.Diversity$pickpocket_cooldown > 0) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.02f);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            cir.cancel();
        }
    }
}

