/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bundleEnchantments;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.inter.ICustomBundleVacuum;
import xyz.faewulf.diversity.mixin.general.bundleEnchantments.BundleItemInvoker;
import xyz.faewulf.diversity.util.CustomEnchant;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements TraceableEntity {
    @Shadow
    private int f_31986_;
    @Shadow
    @Nullable
    private UUID f_265881_;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private static int diversity_Multiloader$getMaxSize(ItemStack itemStack) {
        int originalSize = 64;
        int value = EnchantmentHelper.m_44843_((Enchantment)CustomEnchant.CAPACITY, (ItemStack)itemStack);
        return originalSize + value * 64;
    }

    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getCount()I")}, cancellable=true)
    private void playerTouchInject(Player entity, CallbackInfo ci, @Local(ordinal=0) ItemStack itemstack) {
        if (this.f_31986_ != 0 || this.f_265881_ != null && !this.f_265881_.equals(entity.m_20148_())) {
            return;
        }
        if (itemstack.m_41741_() <= 1 || itemstack.m_41619_()) {
            return;
        }
        ArrayList<ItemStack> bundles = new ArrayList<ItemStack>();
        int originalCount = itemstack.m_41613_();
        for (ItemStack item : entity.m_150109_().f_35974_) {
            int value2;
            int value1;
            if (item.m_41619_() || (value1 = EnchantmentHelper.m_44843_((Enchantment)CustomEnchant.VACUUM, (ItemStack)item)) + (value2 = EnchantmentHelper.m_44843_((Enchantment)CustomEnchant.SELECTIVE_VACUUM, (ItemStack)item)) <= 0 || !(item.m_41720_() instanceof ICustomBundleVacuum)) continue;
            if (value2 > 0) {
                bundles.add(0, item);
                continue;
            }
            bundles.add(item);
        }
        for (ItemStack bundle : bundles) {
            Stream<ItemStack> itemStackStream;
            int freeSlotInBundle;
            int numberOfItemWillPut;
            int maxBundleSize;
            if (ci.isCancelled()) break;
            if (bundle == null) continue;
            boolean isSelective = false;
            if (EnchantmentHelper.m_44843_((Enchantment)CustomEnchant.SELECTIVE_VACUUM, (ItemStack)bundle) > 0) {
                isSelective = true;
            }
            int stackMultiplier = 64 / itemstack.m_41741_();
            int realStackSizeOfTheItemWillPutInto = stackMultiplier * itemstack.m_41613_();
            int usedSlotInBundle = BundleItemInvoker.getContentWeightInvoked(bundle);
            if (usedSlotInBundle >= (maxBundleSize = ItemEntityMixin.diversity_Multiloader$getMaxSize(bundle)) || (numberOfItemWillPut = (int)Math.floor((float)Math.min(freeSlotInBundle = maxBundleSize - usedSlotInBundle, realStackSizeOfTheItemWillPutInto) * 1.0f / (float)stackMultiplier)) <= 0 || (itemStackStream = BundleItemInvoker.getContentsInvoked(bundle)) == null) continue;
            LinkedList<ItemStack> itemStacksInBundle = new LinkedList<ItemStack>(itemStackStream.toList());
            boolean hasInsert = false;
            for (ItemStack itemStackInBundle : itemStacksInBundle) {
                int maxSize;
                if (!ItemStack.m_150942_((ItemStack)itemStackInBundle, (ItemStack)itemstack) || itemStackInBundle.m_41613_() >= itemStackInBundle.m_41741_()) continue;
                int countInBundle = itemStackInBundle.m_41613_();
                if (countInBundle + numberOfItemWillPut > (maxSize = itemStackInBundle.m_41741_())) {
                    ItemStack newItemStack;
                    int slotLeft = maxSize - countInBundle;
                    int numberOfItemWillPutIntoCurrentBundle = numberOfItemWillPut;
                    numberOfItemWillPutIntoCurrentBundle -= slotLeft;
                    itemStackInBundle.m_41769_(slotLeft);
                    while (numberOfItemWillPutIntoCurrentBundle > maxSize) {
                        numberOfItemWillPutIntoCurrentBundle -= maxSize;
                        newItemStack = itemstack.m_41777_();
                        newItemStack.m_41764_(maxSize);
                        itemStacksInBundle.add(newItemStack);
                    }
                    if (numberOfItemWillPutIntoCurrentBundle > 0) {
                        newItemStack = itemstack.m_41777_();
                        newItemStack.m_41764_(numberOfItemWillPutIntoCurrentBundle);
                        itemStacksInBundle.add(newItemStack);
                    }
                } else {
                    itemStackInBundle.m_41769_(numberOfItemWillPut);
                }
                hasInsert = true;
                break;
            }
            if (!hasInsert && !isSelective) {
                int numberOfItemWillPutIntoCurrentBundle;
                int maxSize = itemstack.m_41741_();
                for (numberOfItemWillPutIntoCurrentBundle = numberOfItemWillPut; numberOfItemWillPutIntoCurrentBundle > maxSize; numberOfItemWillPutIntoCurrentBundle -= maxSize) {
                    ItemStack newItemStack = itemstack.m_41777_();
                    newItemStack.m_41764_(maxSize);
                    itemStacksInBundle.add(newItemStack);
                }
                if (numberOfItemWillPutIntoCurrentBundle > 0) {
                    ItemStack newItemStack = itemstack.m_41777_();
                    newItemStack.m_41764_(numberOfItemWillPutIntoCurrentBundle);
                    itemStacksInBundle.add(newItemStack);
                }
                hasInsert = true;
            }
            if (!hasInsert) continue;
            itemstack.m_41774_(numberOfItemWillPut);
            this.diversity$saveItemListToBundle(itemStacksInBundle, bundle);
            if (itemstack.m_41619_()) {
                entity.m_7938_((Entity)this, originalCount);
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 0.3f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
                entity.m_6278_(Stats.f_12984_.m_12902_((Object)itemstack.m_41720_()), originalCount);
                this.m_146870_();
                ci.cancel();
                continue;
            }
            int pickedUpCount = originalCount - itemstack.m_41613_();
            if (pickedUpCount <= 0) continue;
            entity.m_7938_((Entity)this, pickedUpCount);
            entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_184215_, SoundSource.PLAYERS, 0.3f, 0.8f + this.f_19796_.m_188501_() * 0.4f);
            entity.m_6278_(Stats.f_12984_.m_12902_((Object)itemstack.m_41720_()), pickedUpCount);
        }
    }

    @Unique
    private void diversity$saveItemListToBundle(List<ItemStack> itemStackList, ItemStack bundle) {
        CompoundTag bundleTag = bundle.m_41784_();
        ListTag itemsTagList = new ListTag();
        for (ItemStack item : itemStackList) {
            if (item.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            itemsTagList.add((Object)itemTag);
        }
        bundleTag.m_128365_("Items", (Tag)itemsTagList);
        bundle.m_41751_(bundleTag);
    }
}

