/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;
import xyz.faewulf.lib.util.missingMethod.ItemStackMethod;
import xyz.faewulf.lib.util.missingMethod.LivingEntityMethod;

public class rightClickCropBlocks {
    public static InteractionResult run(Level level, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (ModConfigs.hoe_harvest_crop == ModConfigs.allowHarvestType.DISABLE) {
            return InteractionResult.PASS;
        }
        if (hand == InteractionHand.MAIN_HAND && hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK) && level instanceof ServerLevel) {
            boolean usingHoe;
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
            BlockPos targetBlock = hitResult.m_82425_();
            BlockState blockState = level.m_8055_(targetBlock);
            boolean bl = usingHoe = Compare.isHasTag((Item)mainHandItem.m_41720_(), (String)"diversity:crop_harvester") && rightClickCropBlocks.enableRadius(blockState);
            if (ModConfigs.hoe_harvest_crop == ModConfigs.allowHarvestType.HAND_ONLY) {
                usingHoe = false;
            }
            if (ModConfigs.hoe_harvest_crop == ModConfigs.allowHarvestType.HOE_ONLY && !usingHoe) {
                return InteractionResult.PASS;
            }
            int radius = 1;
            if (usingHoe && Compare.isHasTag((Item)mainHandItem.m_41720_(), (String)"diversity:tier2_hoe")) {
                radius = 2;
            }
            if (!usingHoe) {
                radius = 0;
            }
            boolean shouldConsumeAction = false;
            if (rightClickCropBlocks.isCrop(blockState)) {
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        int maxAge;
                        int age;
                        BlockPos currentBlock = hitResult.m_82425_().m_7918_(dx, 0, dz);
                        BlockState currentBlockState = level.m_8055_(currentBlock);
                        if (!rightClickCropBlocks.isCrop(currentBlockState) || (age = rightClickCropBlocks.getAge(currentBlockState)) != (maxAge = rightClickCropBlocks.getMaxAge(currentBlockState))) continue;
                        Vec3 center = currentBlock.m_252807_();
                        List itemStacks = Block.m_49874_((BlockState)currentBlockState, (ServerLevel)serverLevel, (BlockPos)currentBlock, null, (Entity)player, (ItemStack)mainHandItem);
                        if (ModConfigs.xp_crops) {
                            ExperienceOrb.m_147082_((ServerLevel)serverLevel, (Vec3)center, (int)level.f_46441_.m_216332_(0, 1));
                        }
                        boolean alreadyTakeSeed = false;
                        for (ItemStack itemStack : itemStacks) {
                            if (rightClickCropBlocks.shouldNotDropSeed(currentBlockState.m_60734_(), itemStack.m_41720_())) {
                                itemStack.m_41764_(0);
                            }
                            if (!alreadyTakeSeed && rightClickCropBlocks.isSeed(itemStack.m_41720_(), currentBlockState)) {
                                alreadyTakeSeed = true;
                                if (rightClickCropBlocks.shouldTakeSeed(currentBlockState.m_60734_())) {
                                    itemStack.m_41774_(1);
                                }
                            }
                            if (itemStack.m_41613_() == 0) continue;
                            ItemEntity item = new ItemEntity((Level)serverLevel, center.f_82479_, center.f_82480_, center.f_82481_, itemStack);
                            item.m_32060_();
                            serverLevel.m_7967_((Entity)item);
                        }
                        if (!alreadyTakeSeed) {
                            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                                ItemStack stack = player.m_150109_().m_8020_(i);
                                if (stack.m_41619_() || !rightClickCropBlocks.isSeed(stack.m_41720_(), currentBlockState)) continue;
                                alreadyTakeSeed = true;
                                if (!rightClickCropBlocks.shouldTakeSeed(currentBlockState.m_60734_())) break;
                                stack.m_41774_(1);
                                break;
                            }
                        }
                        if (alreadyTakeSeed) {
                            rightClickCropBlocks.replaceCrop(serverLevel, currentBlockState, currentBlock);
                        } else {
                            rightClickCropBlocks.replaceCrop(serverLevel, Blocks.f_50016_.m_49966_(), currentBlock);
                        }
                        serverLevel.m_5594_(null, targetBlock, currentBlockState.m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, currentBlockState), center.f_82479_, center.f_82480_ - (double)0.2f, center.f_82481_, 40, 0.25, 0.25, 0.25, 0.5);
                        player.m_36399_(0.005f);
                        if (usingHoe) {
                            ItemStackMethod.hurtAndBreak((ItemStack)player.m_21120_(hand), (int)1, (LivingEntity)player, (EquipmentSlot)LivingEntityMethod.getSlotForHand((InteractionHand)hand));
                        }
                        shouldConsumeAction = true;
                    }
                }
                if (shouldConsumeAction) {
                    player.m_21011_(hand, true);
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static boolean isCrop(BlockState blockState) {
        return blockState.m_60734_() instanceof CropBlock || blockState.m_60734_() instanceof NetherWartBlock || blockState.m_60734_() instanceof CocoaBlock;
    }

    private static boolean enableRadius(BlockState blockState) {
        return blockState.m_60734_() instanceof CropBlock || blockState.m_60734_() instanceof NetherWartBlock;
    }

    private static boolean shouldTakeSeed(Block block) {
        return !Compare.isBlock((String)"farmersdelight:tomatoes", (Block)block);
    }

    private static boolean shouldNotDropSeed(Block block, Item item) {
        return Compare.isBlock((String)"farmersdelight:tomatoes", (Block)block) && Compare.isItem((String)"farmersdelight:tomato_seeds", (Item)item);
    }

    private static boolean isSeed(Item target, BlockState blockState) {
        BlockItem blockItem;
        if (Compare.isBlock((String)"farmersdelight:tomatoes", (Block)blockState.m_60734_())) {
            return true;
        }
        return target instanceof BlockItem && (blockItem = (BlockItem)target).m_40614_() == blockState.m_60734_();
    }

    private static int getAge(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_52305_(blockState);
        }
        if (blockState.m_60734_() instanceof NetherWartBlock) {
            return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61407_);
        }
        if (blockState.m_60734_() instanceof CocoaBlock) {
            return (Integer)blockState.m_61143_((Property)BlockStateProperties.f_61406_);
        }
        return -1;
    }

    private static int getMaxAge(BlockState blockState) {
        Block block = blockState.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock cropBlock = (CropBlock)block;
            return cropBlock.m_7419_();
        }
        if (blockState.m_60734_() instanceof NetherWartBlock) {
            return 3;
        }
        if (blockState.m_60734_() instanceof CocoaBlock) {
            return 2;
        }
        return 0;
    }

    private static void replaceCrop(ServerLevel level, BlockState blockState, BlockPos blockPos) {
        BlockState result = blockState.m_60734_().m_49966_();
        if (blockState.m_60734_() instanceof CocoaBlock) {
            result = (BlockState)result.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        level.m_7731_(blockPos, result, 3);
    }
}

