/*
 * Decompiled with CFR 0.152.
 */
package com.rinko1231.armordamagelimit.mixin;

import com.rinko1231.armordamagelimit.config.ArmorProtectionConfig;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public class ArmorDurabilityMixin {
    @Shadow
    @Final
    public NonNullList<ItemStack> f_35975_;

    @Inject(method={"hurtArmor"}, at={@At(value="HEAD")}, cancellable=true)
    private void modifyArmorDurability(DamageSource source, float amount, int[] slots, CallbackInfo ci) {
        if (!(amount <= 0.0f)) {
            amount /= 4.0f;
            for (int i : slots) {
                ItemStack armorItem = (ItemStack)this.f_35975_.get(i);
                if (source.m_269533_(DamageTypeTags.f_268745_) && armorItem.m_41720_().m_41475_() || !(armorItem.m_41720_() instanceof ArmorItem)) continue;
                String itemId = ForgeRegistries.ITEMS.getKey((Object)armorItem.m_41720_()).toString();
                if (!((List)ArmorProtectionConfig.itemProtectionBlacklist.get()).contains(itemId)) {
                    int maxDurability = armorItem.m_41776_();
                    float maxAllowedDamage = (float)((double)maxDurability * (Double)ArmorProtectionConfig.maxArmorDurabilityLossPercent.get());
                    amount = Math.min(amount, maxAllowedDamage);
                }
                if (amount < 1.0f) {
                    amount = 1.0f;
                }
                armorItem.m_41622_((int)amount, (LivingEntity)((Inventory)this).f_35978_, ThePlayer -> ThePlayer.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)i)));
            }
        }
        ci.cancel();
    }
}

