/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.tact;

import com.google.common.base.Suppliers;
import com.telepathicgrunt.tact.Config;
import com.telepathicgrunt.tact.mixin.BlockStateBaseAccessor;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModifications {
    public static ResourceKey<Biome> CANDY_CAVITY_BIOME_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("alexscaves", "candy_cavity"));
    private static final Supplier<Item> GUANO = Suppliers.memoize(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("alexscaves", "guano")));
    private static final Supplier<Item> GUANO_BLOCK = Suppliers.memoize(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("alexscaves", "guano_block")));
    private static final Supplier<Item> GUANO_LAYER = Suppliers.memoize(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("alexscaves", "guano_layer")));

    static void doModifications(FMLCommonSetupEvent event) {
        if (((Boolean)Config.REPLACEABLE_SMALL_PLANTS.get()).booleanValue()) {
            BlockModifications.makeReplaceable(new ResourceLocation("alexscaves", "underweed"));
            BlockModifications.makeReplaceable(new ResourceLocation("alexscaves", "tree_star"));
            BlockModifications.makeReplaceable(new ResourceLocation("alexscaves", "fiddlehead"));
            BlockModifications.makeReplaceable(new ResourceLocation("alexscaves", "curly_fern"));
        }
    }

    static void burnTimeModifications(FurnaceFuelBurnTimeEvent event) {
        if (((Boolean)Config.GUANO_BURN_FUEL.get()).booleanValue()) {
            ItemStack currentStack = event.getItemStack();
            if (currentStack.m_150930_(GUANO.get())) {
                event.setBurnTime(1600);
            } else if (currentStack.m_150930_(GUANO_BLOCK.get())) {
                event.setBurnTime(7000);
            } else if (currentStack.m_150930_(GUANO_LAYER.get())) {
                event.setBurnTime(3500);
            }
        }
    }

    private static void makeReplaceable(ResourceLocation targetBlock) {
        Optional block = BuiltInRegistries.f_256975_.m_6612_(targetBlock);
        block.ifPresent(value -> value.m_49965_().m_61056_().forEach(blockState -> ((BlockStateBaseAccessor)blockState).setReplaceable(true)));
    }
}

