/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancient_elements.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.ancient_elements.AncientElementsMod;
import net.mcreator.ancient_elements.procedures.AncientElementalButtonProcedure;
import net.mcreator.ancient_elements.procedures.HellstoneButtonProcedure;
import net.mcreator.ancient_elements.procedures.MobEffect2ButtonProcedure;
import net.mcreator.ancient_elements.procedures.MobEffect4ButtonProcedure;
import net.mcreator.ancient_elements.world.inventory.MobEffect3Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEffect3ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MobEffect3ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MobEffect3ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MobEffect3ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MobEffect3ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MobEffect3ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MobEffect3Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            MobEffect4ButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            MobEffect2ButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            AncientElementalButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            AncientElementalButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            AncientElementalButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            AncientElementalButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            AncientElementalButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AncientElementsMod.addNetworkMessage(MobEffect3ButtonMessage.class, MobEffect3ButtonMessage::buffer, MobEffect3ButtonMessage::new, MobEffect3ButtonMessage::handler);
    }
}

