/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancient_elements.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.ancient_elements.AncientElementsMod;
import net.mcreator.ancient_elements.procedures.AstroLureButtonProcedure;
import net.mcreator.ancient_elements.procedures.CrystalPowderBagButtonProcedure;
import net.mcreator.ancient_elements.procedures.DynamiteButtonProcedure;
import net.mcreator.ancient_elements.procedures.ElementalChargeButtonProcedure;
import net.mcreator.ancient_elements.procedures.FierySolutionButtonProcedure;
import net.mcreator.ancient_elements.procedures.GeodeButtonProcedure;
import net.mcreator.ancient_elements.procedures.GlowshroomSoupButtonProcedure;
import net.mcreator.ancient_elements.procedures.Items2ButtonProcedure;
import net.mcreator.ancient_elements.procedures.MiscButtonProcedure;
import net.mcreator.ancient_elements.procedures.OldCoinButtonProcedure;
import net.mcreator.ancient_elements.procedures.ScampPouchButtonProcedure;
import net.mcreator.ancient_elements.procedures.SlimeballButtonProcedure;
import net.mcreator.ancient_elements.world.inventory.Items1PageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Items1PageButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public Items1PageButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public Items1PageButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(Items1PageButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(Items1PageButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            Items1PageButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = Items1PageMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Items2ButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            MiscButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            OldCoinButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            GlowshroomSoupButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            FierySolutionButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            DynamiteButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            ScampPouchButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            CrystalPowderBagButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 8) {
            SlimeballButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 9) {
            GeodeButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 10) {
            AstroLureButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 11) {
            ElementalChargeButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AncientElementsMod.addNetworkMessage(Items1PageButtonMessage.class, Items1PageButtonMessage::buffer, Items1PageButtonMessage::new, Items1PageButtonMessage::handler);
    }
}

