/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancient_elements.network;

import java.util.function.Supplier;
import net.mcreator.ancient_elements.AncientElementsMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AncientElementsModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        AncientElementsMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        AncientElementsMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.aurora_staff_beam_cooldown = message.data.aurora_staff_beam_cooldown;
                    variables.is_player_in_void = message.data.is_player_in_void;
                    variables.galactrium_stage = message.data.galactrium_stage;
                    variables.celestium_invincible = message.data.celestium_invincible;
                    variables.molten_spear_thowing = message.data.molten_spear_thowing;
                    variables.player_walk_on_air_counter = message.data.player_walk_on_air_counter;
                    variables.player_cosmic_shock = message.data.player_cosmic_shock;
                    variables.luminflux_light = message.data.luminflux_light;
                    variables.luminflux_light_reverse = message.data.luminflux_light_reverse;
                    variables.OreListVariable = message.data.OreListVariable;
                    variables.minersslotmachine = message.data.minersslotmachine;
                    variables.player_palladium_bar = message.data.player_palladium_bar;
                    variables.titanium_weapon_power_strike = message.data.titanium_weapon_power_strike;
                    variables.extra_damage = message.data.extra_damage;
                    variables.hook_x = message.data.hook_x;
                    variables.hook_y = message.data.hook_y;
                    variables.hook_z = message.data.hook_z;
                    variables.is_hooked = message.data.is_hooked;
                    variables.has_item_in_inventory = message.data.has_item_in_inventory;
                    variables.velocity_x = message.data.velocity_x;
                    variables.player_use_mirror = message.data.player_use_mirror;
                    variables.player_mirror_used = message.data.player_mirror_used;
                    variables.bell_charge = message.data.bell_charge;
                    variables.player_can_throw_spear = message.data.player_can_throw_spear;
                    variables.piggybank_slot0 = message.data.piggybank_slot0;
                    variables.piggybank_slot1 = message.data.piggybank_slot1;
                    variables.piggybank_slot2 = message.data.piggybank_slot2;
                    variables.piggybank_slot3 = message.data.piggybank_slot3;
                    variables.piggybank_slot4 = message.data.piggybank_slot4;
                    variables.piggybank_slot5 = message.data.piggybank_slot5;
                    variables.piggybank_slot6 = message.data.piggybank_slot6;
                    variables.piggybank_number_0 = message.data.piggybank_number_0;
                    variables.piggybank_number_1 = message.data.piggybank_number_1;
                    variables.piggybank_number_2 = message.data.piggybank_number_2;
                    variables.piggybank_number_3 = message.data.piggybank_number_3;
                    variables.piggybank_number_4 = message.data.piggybank_number_4;
                    variables.piggybank_number_5 = message.data.piggybank_number_5;
                    variables.piggybank_number_6 = message.data.piggybank_number_6;
                    variables.is_using_magnet = message.data.is_using_magnet;
                    variables.magnet_sound_loop = message.data.magnet_sound_loop;
                    variables.pocket_magnet_slot0 = message.data.pocket_magnet_slot0;
                    variables.is_using_maul = message.data.is_using_maul;
                    variables.maul_sound_loop = message.data.maul_sound_loop;
                    variables.player_paralyzed_overlay = message.data.player_paralyzed_overlay;
                    variables.gravity_anchor_active = message.data.gravity_anchor_active;
                    variables.player_x = message.data.player_x;
                    variables.player_z = message.data.player_z;
                    variables.player_elemental_blight_loop = message.data.player_elemental_blight_loop;
                    variables.is_using_prism = message.data.is_using_prism;
                    variables.prism_sound_loop = message.data.prism_sound_loop;
                    variables.is_hooked2 = message.data.is_hooked2;
                    variables.player_pull_hook = message.data.player_pull_hook;
                    variables.endrium_ability = message.data.endrium_ability;
                    variables.galacttrium_slash = message.data.galacttrium_slash;
                    variables.celestium_ability = message.data.celestium_ability;
                    variables.player_can_wish = message.data.player_can_wish;
                    variables.wish_cooldown = message.data.wish_cooldown;
                    variables.is_using_facet_piercer = message.data.is_using_facet_piercer;
                    variables.piercer_cooldown = message.data.piercer_cooldown;
                    variables.piercer_firerate = message.data.piercer_firerate;
                    variables.piercer_charging = message.data.piercer_charging;
                    variables.player_crystal_infestion_overlay = message.data.player_crystal_infestion_overlay;
                    variables.auric_breaker_using = message.data.auric_breaker_using;
                    variables.auric_breaker_cooldown = message.data.auric_breaker_cooldown;
                    variables.auric_breaker_firetate = message.data.auric_breaker_firetate;
                    variables.auric_breaker_charging = message.data.auric_breaker_charging;
                    variables.auric_breaker_super_arrow = message.data.auric_breaker_super_arrow;
                    variables.MusicTick = message.data.MusicTick;
                    variables.MusicWait = message.data.MusicWait;
                    variables.MusicLock = message.data.MusicLock;
                    variables.MusicReplace = message.data.MusicReplace;
                    variables.MusicPlay = message.data.MusicPlay;
                    variables.cave_music_playable = message.data.cave_music_playable;
                    variables.cave_music_tick = message.data.cave_music_tick;
                    variables.player_first_join = message.data.player_first_join;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double aurora_staff_beam_cooldown = 0.0;
        public double is_player_in_void = 0.0;
        public double galactrium_stage = 0.0;
        public boolean celestium_invincible = false;
        public boolean molten_spear_thowing = false;
        public double player_walk_on_air_counter = 0.0;
        public double player_cosmic_shock = 0.0;
        public double luminflux_light = 0.0;
        public boolean luminflux_light_reverse = false;
        public String OreListVariable = "\"\"";
        public double minersslotmachine = 0.0;
        public double player_palladium_bar = 0.0;
        public double titanium_weapon_power_strike = 0.0;
        public double extra_damage = 0.0;
        public double hook_x = 0.0;
        public double hook_y = 0.0;
        public double hook_z = 0.0;
        public boolean is_hooked = false;
        public boolean has_item_in_inventory = false;
        public double velocity_x = 0.0;
        public boolean player_use_mirror = false;
        public boolean player_mirror_used = false;
        public double bell_charge = 0.0;
        public boolean player_can_throw_spear = false;
        public ItemStack piggybank_slot0 = ItemStack.f_41583_;
        public ItemStack piggybank_slot1 = ItemStack.f_41583_;
        public ItemStack piggybank_slot2 = ItemStack.f_41583_;
        public ItemStack piggybank_slot3 = ItemStack.f_41583_;
        public ItemStack piggybank_slot4 = ItemStack.f_41583_;
        public ItemStack piggybank_slot5 = ItemStack.f_41583_;
        public ItemStack piggybank_slot6 = ItemStack.f_41583_;
        public double piggybank_number_0 = 0.0;
        public double piggybank_number_1 = 0.0;
        public double piggybank_number_2 = 0.0;
        public double piggybank_number_3 = 0.0;
        public double piggybank_number_4 = 0.0;
        public double piggybank_number_5 = 0.0;
        public double piggybank_number_6 = 0.0;
        public boolean is_using_magnet = false;
        public double magnet_sound_loop = 0.0;
        public ItemStack pocket_magnet_slot0 = ItemStack.f_41583_;
        public boolean is_using_maul = false;
        public double maul_sound_loop = 0.0;
        public double player_paralyzed_overlay = 0.0;
        public boolean gravity_anchor_active = true;
        public double player_x = 0.0;
        public double player_z = 0.0;
        public double player_elemental_blight_loop = 0.0;
        public boolean is_using_prism = false;
        public double prism_sound_loop = 0.0;
        public boolean is_hooked2 = false;
        public boolean player_pull_hook = false;
        public double endrium_ability = 0.0;
        public double galacttrium_slash = 0.0;
        public double celestium_ability = 0.0;
        public boolean player_can_wish = true;
        public double wish_cooldown = 0.0;
        public boolean is_using_facet_piercer = false;
        public double piercer_cooldown = 10.0;
        public double piercer_firerate = 0.0;
        public double piercer_charging = 0.0;
        public double player_crystal_infestion_overlay = 0.0;
        public boolean auric_breaker_using = false;
        public double auric_breaker_cooldown = 8.0;
        public double auric_breaker_firetate = 0.0;
        public double auric_breaker_charging = 0.0;
        public double auric_breaker_super_arrow = 0.0;
        public double MusicTick = 0.0;
        public double MusicWait = 0.0;
        public boolean MusicLock = false;
        public boolean MusicReplace = false;
        public String MusicPlay = "\"\"";
        public boolean cave_music_playable = true;
        public double cave_music_tick = 0.0;
        public boolean player_first_join = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                AncientElementsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("aurora_staff_beam_cooldown", this.aurora_staff_beam_cooldown);
            nbt.m_128347_("is_player_in_void", this.is_player_in_void);
            nbt.m_128347_("galactrium_stage", this.galactrium_stage);
            nbt.m_128379_("celestium_invincible", this.celestium_invincible);
            nbt.m_128379_("molten_spear_thowing", this.molten_spear_thowing);
            nbt.m_128347_("player_walk_on_air_counter", this.player_walk_on_air_counter);
            nbt.m_128347_("player_cosmic_shock", this.player_cosmic_shock);
            nbt.m_128347_("luminflux_light", this.luminflux_light);
            nbt.m_128379_("luminflux_light_reverse", this.luminflux_light_reverse);
            nbt.m_128359_("OreListVariable", this.OreListVariable);
            nbt.m_128347_("minersslotmachine", this.minersslotmachine);
            nbt.m_128347_("player_palladium_bar", this.player_palladium_bar);
            nbt.m_128347_("titanium_weapon_power_strike", this.titanium_weapon_power_strike);
            nbt.m_128347_("extra_damage", this.extra_damage);
            nbt.m_128347_("hook_x", this.hook_x);
            nbt.m_128347_("hook_y", this.hook_y);
            nbt.m_128347_("hook_z", this.hook_z);
            nbt.m_128379_("is_hooked", this.is_hooked);
            nbt.m_128379_("has_item_in_inventory", this.has_item_in_inventory);
            nbt.m_128347_("velocity_x", this.velocity_x);
            nbt.m_128379_("player_use_mirror", this.player_use_mirror);
            nbt.m_128379_("player_mirror_used", this.player_mirror_used);
            nbt.m_128347_("bell_charge", this.bell_charge);
            nbt.m_128379_("player_can_throw_spear", this.player_can_throw_spear);
            nbt.m_128365_("piggybank_slot0", (Tag)this.piggybank_slot0.m_41739_(new CompoundTag()));
            nbt.m_128365_("piggybank_slot1", (Tag)this.piggybank_slot1.m_41739_(new CompoundTag()));
            nbt.m_128365_("piggybank_slot2", (Tag)this.piggybank_slot2.m_41739_(new CompoundTag()));
            nbt.m_128365_("piggybank_slot3", (Tag)this.piggybank_slot3.m_41739_(new CompoundTag()));
            nbt.m_128365_("piggybank_slot4", (Tag)this.piggybank_slot4.m_41739_(new CompoundTag()));
            nbt.m_128365_("piggybank_slot5", (Tag)this.piggybank_slot5.m_41739_(new CompoundTag()));
            nbt.m_128365_("piggybank_slot6", (Tag)this.piggybank_slot6.m_41739_(new CompoundTag()));
            nbt.m_128347_("piggybank_number_0", this.piggybank_number_0);
            nbt.m_128347_("piggybank_number_1", this.piggybank_number_1);
            nbt.m_128347_("piggybank_number_2", this.piggybank_number_2);
            nbt.m_128347_("piggybank_number_3", this.piggybank_number_3);
            nbt.m_128347_("piggybank_number_4", this.piggybank_number_4);
            nbt.m_128347_("piggybank_number_5", this.piggybank_number_5);
            nbt.m_128347_("piggybank_number_6", this.piggybank_number_6);
            nbt.m_128379_("is_using_magnet", this.is_using_magnet);
            nbt.m_128347_("magnet_sound_loop", this.magnet_sound_loop);
            nbt.m_128365_("pocket_magnet_slot0", (Tag)this.pocket_magnet_slot0.m_41739_(new CompoundTag()));
            nbt.m_128379_("is_using_maul", this.is_using_maul);
            nbt.m_128347_("maul_sound_loop", this.maul_sound_loop);
            nbt.m_128347_("player_paralyzed_overlay", this.player_paralyzed_overlay);
            nbt.m_128379_("gravity_anchor_active", this.gravity_anchor_active);
            nbt.m_128347_("player_x", this.player_x);
            nbt.m_128347_("player_z", this.player_z);
            nbt.m_128347_("player_elemental_blight_loop", this.player_elemental_blight_loop);
            nbt.m_128379_("is_using_prism", this.is_using_prism);
            nbt.m_128347_("prism_sound_loop", this.prism_sound_loop);
            nbt.m_128379_("is_hooked2", this.is_hooked2);
            nbt.m_128379_("player_pull_hook", this.player_pull_hook);
            nbt.m_128347_("endrium_ability", this.endrium_ability);
            nbt.m_128347_("galacttrium_slash", this.galacttrium_slash);
            nbt.m_128347_("celestium_ability", this.celestium_ability);
            nbt.m_128379_("player_can_wish", this.player_can_wish);
            nbt.m_128347_("wish_cooldown", this.wish_cooldown);
            nbt.m_128379_("is_using_facet_piercer", this.is_using_facet_piercer);
            nbt.m_128347_("piercer_cooldown", this.piercer_cooldown);
            nbt.m_128347_("piercer_firerate", this.piercer_firerate);
            nbt.m_128347_("piercer_charging", this.piercer_charging);
            nbt.m_128347_("player_crystal_infestion_overlay", this.player_crystal_infestion_overlay);
            nbt.m_128379_("auric_breaker_using", this.auric_breaker_using);
            nbt.m_128347_("auric_breaker_cooldown", this.auric_breaker_cooldown);
            nbt.m_128347_("auric_breaker_firetate", this.auric_breaker_firetate);
            nbt.m_128347_("auric_breaker_charging", this.auric_breaker_charging);
            nbt.m_128347_("auric_breaker_super_arrow", this.auric_breaker_super_arrow);
            nbt.m_128347_("MusicTick", this.MusicTick);
            nbt.m_128347_("MusicWait", this.MusicWait);
            nbt.m_128379_("MusicLock", this.MusicLock);
            nbt.m_128379_("MusicReplace", this.MusicReplace);
            nbt.m_128359_("MusicPlay", this.MusicPlay);
            nbt.m_128379_("cave_music_playable", this.cave_music_playable);
            nbt.m_128347_("cave_music_tick", this.cave_music_tick);
            nbt.m_128379_("player_first_join", this.player_first_join);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.aurora_staff_beam_cooldown = nbt.m_128459_("aurora_staff_beam_cooldown");
            this.is_player_in_void = nbt.m_128459_("is_player_in_void");
            this.galactrium_stage = nbt.m_128459_("galactrium_stage");
            this.celestium_invincible = nbt.m_128471_("celestium_invincible");
            this.molten_spear_thowing = nbt.m_128471_("molten_spear_thowing");
            this.player_walk_on_air_counter = nbt.m_128459_("player_walk_on_air_counter");
            this.player_cosmic_shock = nbt.m_128459_("player_cosmic_shock");
            this.luminflux_light = nbt.m_128459_("luminflux_light");
            this.luminflux_light_reverse = nbt.m_128471_("luminflux_light_reverse");
            this.OreListVariable = nbt.m_128461_("OreListVariable");
            this.minersslotmachine = nbt.m_128459_("minersslotmachine");
            this.player_palladium_bar = nbt.m_128459_("player_palladium_bar");
            this.titanium_weapon_power_strike = nbt.m_128459_("titanium_weapon_power_strike");
            this.extra_damage = nbt.m_128459_("extra_damage");
            this.hook_x = nbt.m_128459_("hook_x");
            this.hook_y = nbt.m_128459_("hook_y");
            this.hook_z = nbt.m_128459_("hook_z");
            this.is_hooked = nbt.m_128471_("is_hooked");
            this.has_item_in_inventory = nbt.m_128471_("has_item_in_inventory");
            this.velocity_x = nbt.m_128459_("velocity_x");
            this.player_use_mirror = nbt.m_128471_("player_use_mirror");
            this.player_mirror_used = nbt.m_128471_("player_mirror_used");
            this.bell_charge = nbt.m_128459_("bell_charge");
            this.player_can_throw_spear = nbt.m_128471_("player_can_throw_spear");
            this.piggybank_slot0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot0"));
            this.piggybank_slot1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot1"));
            this.piggybank_slot2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot2"));
            this.piggybank_slot3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot3"));
            this.piggybank_slot4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot4"));
            this.piggybank_slot5 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot5"));
            this.piggybank_slot6 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("piggybank_slot6"));
            this.piggybank_number_0 = nbt.m_128459_("piggybank_number_0");
            this.piggybank_number_1 = nbt.m_128459_("piggybank_number_1");
            this.piggybank_number_2 = nbt.m_128459_("piggybank_number_2");
            this.piggybank_number_3 = nbt.m_128459_("piggybank_number_3");
            this.piggybank_number_4 = nbt.m_128459_("piggybank_number_4");
            this.piggybank_number_5 = nbt.m_128459_("piggybank_number_5");
            this.piggybank_number_6 = nbt.m_128459_("piggybank_number_6");
            this.is_using_magnet = nbt.m_128471_("is_using_magnet");
            this.magnet_sound_loop = nbt.m_128459_("magnet_sound_loop");
            this.pocket_magnet_slot0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("pocket_magnet_slot0"));
            this.is_using_maul = nbt.m_128471_("is_using_maul");
            this.maul_sound_loop = nbt.m_128459_("maul_sound_loop");
            this.player_paralyzed_overlay = nbt.m_128459_("player_paralyzed_overlay");
            this.gravity_anchor_active = nbt.m_128471_("gravity_anchor_active");
            this.player_x = nbt.m_128459_("player_x");
            this.player_z = nbt.m_128459_("player_z");
            this.player_elemental_blight_loop = nbt.m_128459_("player_elemental_blight_loop");
            this.is_using_prism = nbt.m_128471_("is_using_prism");
            this.prism_sound_loop = nbt.m_128459_("prism_sound_loop");
            this.is_hooked2 = nbt.m_128471_("is_hooked2");
            this.player_pull_hook = nbt.m_128471_("player_pull_hook");
            this.endrium_ability = nbt.m_128459_("endrium_ability");
            this.galacttrium_slash = nbt.m_128459_("galacttrium_slash");
            this.celestium_ability = nbt.m_128459_("celestium_ability");
            this.player_can_wish = nbt.m_128471_("player_can_wish");
            this.wish_cooldown = nbt.m_128459_("wish_cooldown");
            this.is_using_facet_piercer = nbt.m_128471_("is_using_facet_piercer");
            this.piercer_cooldown = nbt.m_128459_("piercer_cooldown");
            this.piercer_firerate = nbt.m_128459_("piercer_firerate");
            this.piercer_charging = nbt.m_128459_("piercer_charging");
            this.player_crystal_infestion_overlay = nbt.m_128459_("player_crystal_infestion_overlay");
            this.auric_breaker_using = nbt.m_128471_("auric_breaker_using");
            this.auric_breaker_cooldown = nbt.m_128459_("auric_breaker_cooldown");
            this.auric_breaker_firetate = nbt.m_128459_("auric_breaker_firetate");
            this.auric_breaker_charging = nbt.m_128459_("auric_breaker_charging");
            this.auric_breaker_super_arrow = nbt.m_128459_("auric_breaker_super_arrow");
            this.MusicTick = nbt.m_128459_("MusicTick");
            this.MusicWait = nbt.m_128459_("MusicWait");
            this.MusicLock = nbt.m_128471_("MusicLock");
            this.MusicReplace = nbt.m_128471_("MusicReplace");
            this.MusicPlay = nbt.m_128461_("MusicPlay");
            this.cave_music_playable = nbt.m_128471_("cave_music_playable");
            this.cave_music_tick = nbt.m_128459_("cave_music_tick");
            this.player_first_join = nbt.m_128471_("player_first_join");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("ancient_elements", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "ancient_elements_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                AncientElementsMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "ancient_elements_worldvars";
        public boolean post_ancient_elemental = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.post_ancient_elemental = nbt.m_128471_("post_ancient_elemental");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128379_("post_ancient_elemental", this.post_ancient_elemental);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                AncientElementsMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.aurora_staff_beam_cooldown = original.aurora_staff_beam_cooldown;
            clone.is_player_in_void = original.is_player_in_void;
            clone.galactrium_stage = original.galactrium_stage;
            clone.celestium_invincible = original.celestium_invincible;
            clone.molten_spear_thowing = original.molten_spear_thowing;
            clone.player_walk_on_air_counter = original.player_walk_on_air_counter;
            clone.player_cosmic_shock = original.player_cosmic_shock;
            clone.luminflux_light = original.luminflux_light;
            clone.luminflux_light_reverse = original.luminflux_light_reverse;
            clone.OreListVariable = original.OreListVariable;
            clone.minersslotmachine = original.minersslotmachine;
            clone.titanium_weapon_power_strike = original.titanium_weapon_power_strike;
            clone.extra_damage = original.extra_damage;
            clone.is_hooked = original.is_hooked;
            clone.has_item_in_inventory = original.has_item_in_inventory;
            clone.velocity_x = original.velocity_x;
            clone.player_use_mirror = original.player_use_mirror;
            clone.player_mirror_used = original.player_mirror_used;
            clone.bell_charge = original.bell_charge;
            clone.player_can_throw_spear = original.player_can_throw_spear;
            clone.piggybank_slot0 = original.piggybank_slot0;
            clone.piggybank_slot1 = original.piggybank_slot1;
            clone.piggybank_slot2 = original.piggybank_slot2;
            clone.piggybank_slot3 = original.piggybank_slot3;
            clone.piggybank_slot4 = original.piggybank_slot4;
            clone.piggybank_slot5 = original.piggybank_slot5;
            clone.piggybank_slot6 = original.piggybank_slot6;
            clone.piggybank_number_0 = original.piggybank_number_0;
            clone.piggybank_number_1 = original.piggybank_number_1;
            clone.piggybank_number_2 = original.piggybank_number_2;
            clone.piggybank_number_3 = original.piggybank_number_3;
            clone.piggybank_number_4 = original.piggybank_number_4;
            clone.piggybank_number_5 = original.piggybank_number_5;
            clone.piggybank_number_6 = original.piggybank_number_6;
            clone.is_using_magnet = original.is_using_magnet;
            clone.magnet_sound_loop = original.magnet_sound_loop;
            clone.pocket_magnet_slot0 = original.pocket_magnet_slot0;
            clone.is_using_maul = original.is_using_maul;
            clone.maul_sound_loop = original.maul_sound_loop;
            clone.player_paralyzed_overlay = original.player_paralyzed_overlay;
            clone.gravity_anchor_active = original.gravity_anchor_active;
            clone.player_x = original.player_x;
            clone.player_z = original.player_z;
            clone.player_elemental_blight_loop = original.player_elemental_blight_loop;
            clone.is_using_prism = original.is_using_prism;
            clone.prism_sound_loop = original.prism_sound_loop;
            clone.is_hooked2 = original.is_hooked2;
            clone.player_pull_hook = original.player_pull_hook;
            clone.endrium_ability = original.endrium_ability;
            clone.player_can_wish = original.player_can_wish;
            clone.wish_cooldown = original.wish_cooldown;
            clone.is_using_facet_piercer = original.is_using_facet_piercer;
            clone.piercer_cooldown = original.piercer_cooldown;
            clone.piercer_firerate = original.piercer_firerate;
            clone.piercer_charging = original.piercer_charging;
            clone.player_crystal_infestion_overlay = original.player_crystal_infestion_overlay;
            clone.auric_breaker_cooldown = original.auric_breaker_cooldown;
            clone.auric_breaker_firetate = original.auric_breaker_firetate;
            clone.auric_breaker_charging = original.auric_breaker_charging;
            clone.auric_breaker_super_arrow = original.auric_breaker_super_arrow;
            clone.MusicTick = original.MusicTick;
            clone.MusicWait = original.MusicWait;
            clone.MusicLock = original.MusicLock;
            clone.MusicReplace = original.MusicReplace;
            clone.MusicPlay = original.MusicPlay;
            clone.cave_music_tick = original.cave_music_tick;
            clone.player_first_join = original.player_first_join;
            if (!event.isWasDeath()) {
                clone.player_palladium_bar = original.player_palladium_bar;
                clone.hook_x = original.hook_x;
                clone.hook_y = original.hook_y;
                clone.hook_z = original.hook_z;
                clone.galacttrium_slash = original.galacttrium_slash;
                clone.celestium_ability = original.celestium_ability;
                clone.auric_breaker_using = original.auric_breaker_using;
                clone.cave_music_playable = original.cave_music_playable;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    AncientElementsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    AncientElementsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                AncientElementsMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

