/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import malte0811.modelsplitter.math.EpsilonMath;
import malte0811.modelsplitter.math.ModelSplitterVec3i;
import malte0811.modelsplitter.math.Plane;
import malte0811.modelsplitter.math.Vec3d;
import malte0811.modelsplitter.model.OBJModel;
import malte0811.modelsplitter.model.Polygon;
import malte0811.modelsplitter.model.Vertex;

public class SplitModel<Texture> {
    private static final EpsilonMath EPS_MATH = new EpsilonMath(1.0E-5);
    private final Map<ModelSplitterVec3i, OBJModel<Texture>> submodels;

    public SplitModel(OBJModel<Texture> input) {
        ImmutableMap.Builder submodels = ImmutableMap.builder();
        for (Int2ObjectMap.Entry xSlice : SplitModel.splitInPlanes(input, 0).int2ObjectEntrySet()) {
            Int2ObjectMap<OBJModel<Texture>> columns = SplitModel.splitInPlanes((OBJModel)xSlice.getValue(), 2);
            for (Int2ObjectMap.Entry zColumn : columns.int2ObjectEntrySet()) {
                Int2ObjectMap<OBJModel<Texture>> dices = SplitModel.splitInPlanes((OBJModel)zColumn.getValue(), 1);
                for (Int2ObjectMap.Entry yDice : dices.int2ObjectEntrySet()) {
                    submodels.put((Object)new ModelSplitterVec3i(xSlice.getIntKey(), yDice.getIntKey(), zColumn.getIntKey()), (Object)((OBJModel)yDice.getValue()));
                }
            }
        }
        this.submodels = submodels.build();
    }

    public Map<ModelSplitterVec3i, OBJModel<Texture>> getParts() {
        return this.submodels;
    }

    private static <Texture> Int2ObjectMap<OBJModel<Texture>> splitInPlanes(OBJModel<Texture> input, int axis) {
        if (input.isEmpty()) {
            return new Int2ObjectOpenHashMap();
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (Polygon<Texture> f : input.getFaces()) {
            for (Vertex v : f.getPoints()) {
                double pos = v.position().get(axis);
                min = Math.min(min, pos);
                max = Math.max(max, pos);
            }
        }
        int firstBorder = EPS_MATH.ceil(min);
        int lastBorder = EPS_MATH.floor(max);
        Int2ObjectOpenHashMap modelPerSection = new Int2ObjectOpenHashMap();
        double[] vecData = new double[3];
        vecData[axis] = 1.0;
        Vec3d normal = new Vec3d(vecData);
        for (int borderPos = firstBorder; borderPos <= lastBorder; ++borderPos) {
            Plane cut = new Plane(normal, borderPos);
            Map<EpsilonMath.Sign, OBJModel<Texture>> splitModel = input.split(cut);
            OBJModel<Texture> sectionModel = splitModel.get((Object)EpsilonMath.Sign.NEGATIVE);
            SplitModel.putModel(modelPerSection, axis, borderPos - 1, sectionModel);
            input = OBJModel.union(splitModel.get((Object)EpsilonMath.Sign.POSITIVE), splitModel.get((Object)EpsilonMath.Sign.ZERO));
        }
        SplitModel.putModel(modelPerSection, axis, lastBorder, input);
        return modelPerSection;
    }

    private static <Texture> void putModel(Int2ObjectMap<OBJModel<Texture>> sectionModels, int axis, int section, OBJModel<Texture> baseSectionModel) {
        if (baseSectionModel != null && !baseSectionModel.isEmpty()) {
            sectionModels.put(section, baseSectionModel.translate(axis, -section).quadify());
        }
    }
}

