/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.worldgen.general.common.random_instances;

import com.ishland.c2me.base.mixin.access.IAtomicSimpleRandomDeriver;
import com.ishland.c2me.base.mixin.access.ISimpleRandom;
import com.ishland.c2me.base.mixin.access.IXoroshiro128PlusPlusRandom;
import com.ishland.c2me.base.mixin.access.IXoroshiro128PlusPlusRandomDeriver;
import com.ishland.c2me.base.mixin.access.IXoroshiro128PlusPlusRandomImpl;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;

public class RandomUtils {
    private static final ThreadLocal<XoroshiroRandomSource> xoroshiro = ThreadLocal.withInitial(() -> new XoroshiroRandomSource(0L, 0L));
    private static final ThreadLocal<SingleThreadedRandomSource> simple = ThreadLocal.withInitial(() -> new SingleThreadedRandomSource(0L));

    public static void derive(PositionalRandomFactory deriver, RandomSource random, int x, int y, int z) {
        if (deriver instanceof XoroshiroRandomSource.XoroshiroPositionalRandomFactory) {
            IXoroshiro128PlusPlusRandomImpl implementation = (IXoroshiro128PlusPlusRandomImpl)((IXoroshiro128PlusPlusRandom)random).getImplementation();
            IXoroshiro128PlusPlusRandomDeriver deriver1 = (IXoroshiro128PlusPlusRandomDeriver)deriver;
            implementation.setSeedLo(Mth.m_14130_((int)x, (int)y, (int)z) ^ deriver1.getSeedLo());
            implementation.setSeedHi(deriver1.getSeedHi());
            return;
        }
        if (deriver instanceof LegacyRandomSource.LegacyPositionalRandomFactory) {
            ISimpleRandom random1 = (ISimpleRandom)random;
            IAtomicSimpleRandomDeriver deriver1 = (IAtomicSimpleRandomDeriver)deriver;
            random1.invokeSetSeed(Mth.m_14130_((int)x, (int)y, (int)z) ^ deriver1.getSeed());
            return;
        }
        throw new IllegalArgumentException();
    }

    public static RandomSource getThreadLocalRandom(PositionalRandomFactory deriver) {
        if (deriver instanceof XoroshiroRandomSource.XoroshiroPositionalRandomFactory) {
            return (RandomSource)xoroshiro.get();
        }
        if (deriver instanceof LegacyRandomSource.LegacyPositionalRandomFactory) {
            return (RandomSource)simple.get();
        }
        throw new IllegalArgumentException();
    }

    public static RandomSource getRandom(PositionalRandomFactory deriver) {
        if (deriver instanceof XoroshiroRandomSource.XoroshiroPositionalRandomFactory) {
            return new XoroshiroRandomSource(0L, 0L);
        }
        if (deriver instanceof LegacyRandomSource.LegacyPositionalRandomFactory) {
            return new SingleThreadedRandomSource(0L);
        }
        throw new IllegalArgumentException();
    }
}

