/*
 * Decompiled with CFR 0.152.
 */
package me.odin.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.odin.custom.JoinItemEntry;
import me.odin.custom.Main;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;

@Mod.EventBusSubscriber(modid="firstjoin")
public class PlayerJoinHandler {
    private static final Map<ServerPlayer, Integer> pendingClear = new HashMap<ServerPlayer, Integer>();
    private static final Map<Path, Set<UUID>> knownPlayersPerWorld = new HashMap<Path, Set<UUID>>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean INV_CLEAR = true;
    private static int DELAY_TICKS = 20;
    private static boolean GIVE_ITEMS = false;
    private static List<JoinItemEntry> JOIN_ITEMS = new ArrayList<JoinItemEntry>();
    private static boolean SEND_MESSAGE = false;
    private static String JOIN_MESSAGE = "First join message!";
    private static boolean SEND_TITLE = false;
    private static String TITLE = "First join title!";
    private static String SUBTITLE = "";
    private static int TITLE_FADEIN = 10;
    private static int TITLE_STAY = 70;
    private static int TITLE_FADEOUT = 20;

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID uuid = player2.m_20148_();
        PlayerJoinHandler.loadGlobalConfig();
        Path worldRoot = player2.m_20194_().m_129843_(LevelResource.f_78182_);
        Path worldConfigFolder = worldRoot.resolve("config");
        Path worldDataFile = worldRoot.resolve("data/first_join_players.dat");
        Set<UUID> knownPlayers = PlayerJoinHandler.loadKnownPlayers(worldDataFile, worldConfigFolder);
        if (!knownPlayers.contains(uuid)) {
            knownPlayers.add(uuid);
            PlayerJoinHandler.saveKnownPlayers(worldDataFile, knownPlayers);
            pendingClear.put(player2, DELAY_TICKS);
            Main.LOGGER.info("Inventory of {} will be cleared in {} ticks.", (Object)player2.m_7755_().getString(), (Object)DELAY_TICKS);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || pendingClear.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<ServerPlayer, Integer>> iterator = pendingClear.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = iterator.next();
            ServerPlayer player = entry.getKey();
            int ticksLeft = entry.getValue() - 1;
            if (ticksLeft <= 0) {
                if (INV_CLEAR) {
                    PlayerJoinHandler.clearInventory(player);
                    iterator.remove();
                    Main.LOGGER.info("Inventory of {} cleared.", (Object)player.m_7755_().getString());
                }
                if (GIVE_ITEMS) {
                    for (JoinItemEntry e : JOIN_ITEMS) {
                        ItemStack stack = e.toItemStack();
                        player.m_36356_(stack);
                    }
                }
                if (SEND_MESSAGE) {
                    player.m_213846_((Component)Component.m_237113_((String)JOIN_MESSAGE));
                }
                if (!SEND_TITLE) continue;
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)TITLE)));
                player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)SUBTITLE)));
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(TITLE_FADEIN, TITLE_STAY, TITLE_FADEOUT));
                continue;
            }
            entry.setValue(ticksLeft);
        }
    }

    private static void clearInventory(ServerPlayer player) {
        player.m_150109_().m_6211_();
    }

    private static Set<UUID> loadKnownPlayers(Path dataFile, Path configFolder) {
        HashSet<UUID> players = new HashSet<UUID>();
        boolean oldJsonExists = Files.exists(configFolder.resolve("first_join_players.json"), new LinkOption[0]);
        try {
            if (Files.exists(dataFile, new LinkOption[0])) {
                try (DataInputStream dis = new DataInputStream(Files.newInputStream(dataFile, new OpenOption[0]));){
                    CompoundTag tag = NbtIo.m_128928_((DataInput)dis);
                    ListTag uuids = tag.m_128437_("players", 8);
                    for (int i = 0; i < uuids.size(); ++i) {
                        players.add(UUID.fromString(uuids.m_128778_(i)));
                    }
                }
                return players;
            }
            if (oldJsonExists) {
                Path oldJson = configFolder.resolve("first_join_players.json");
                try (BufferedReader reader = Files.newBufferedReader(oldJson);){
                    Type type = new TypeToken<Set<UUID>>(){}.getType();
                    Set oldPlayers = (Set)GSON.fromJson((Reader)reader, type);
                    if (oldPlayers != null) {
                        players.addAll(oldPlayers);
                    }
                }
                Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
                PlayerJoinHandler.saveKnownPlayers(dataFile, players);
                return players;
            }
            Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
            PlayerJoinHandler.saveKnownPlayers(dataFile, players);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return players;
    }

    private static void saveKnownPlayers(Path dataFile, Set<UUID> players) {
        try {
            Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            for (UUID uuid : players) {
                list.add((Object)StringTag.m_129297_((String)uuid.toString()));
            }
            tag.m_128365_("players", (Tag)list);
            try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(dataFile, new OpenOption[0]));){
                NbtIo.m_128941_((CompoundTag)tag, (DataOutput)dos);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Path getGlobalConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("firstjoin.json");
    }

    private static void loadGlobalConfig() {
        Path configPath = PlayerJoinHandler.getGlobalConfigPath();
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                PlayerJoinHandler.writeDefaultConfig(configPath);
            }
            try (BufferedReader reader = Files.newBufferedReader(configPath);){
                JsonObject obj = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                INV_CLEAR = obj.get("invclear").getAsBoolean();
                DELAY_TICKS = obj.get("delay").getAsInt();
                GIVE_ITEMS = obj.get("give_items").getAsBoolean();
                SEND_MESSAGE = obj.get("send_message").getAsBoolean();
                SEND_TITLE = obj.get("send_title").getAsBoolean();
                JOIN_MESSAGE = obj.get("message").getAsString();
                TITLE = obj.get("title").getAsString();
                SUBTITLE = obj.get("subtitle").getAsString();
                TITLE_FADEIN = obj.get("fadeIn").getAsInt();
                TITLE_STAY = obj.get("stay").getAsInt();
                TITLE_FADEOUT = obj.get("fadeOut").getAsInt();
                Type listType = new TypeToken<List<JoinItemEntry>>(){}.getType();
                JOIN_ITEMS = (List)GSON.fromJson(obj.get("items"), listType);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeDefaultConfig(Path configPath) throws IOException {
        List<String> lines = Arrays.asList("# FirstJoin configuration", "# This config controls the behavior when a player joins for the first time.", "# delay: number of ticks to wait before clearing inventory (default 20) 20 ticks = 1 second", "# give_items: whether to give items defined in the items list", "# items: list of items to give (minecraft:item_name (also modded items work)) with count", "# send_message: send a chat message on first join", "# message: the message to send (use \u00a7 for colors, e.g. \u00a7aGreen)", "# send_title: send a title on first join", "# title: main title (use \u00a7 for colors)", "# subtitle: subtitle text (use \u00a7 for colors)", "# fadeIn, stay, fadeOut: title animation times in ticks", "", "{", "  \"invclear\": true,", "  \"delay\": 20,", "  \"give_items\": false,", "  \"items\": [", "    {\"item\": \"minecraft:air\", \"count\": 1},", "    {\"item\": \"minecraft:air\", \"count\": 1},", "    {\"item\": \"minecraft:air\", \"count\": 1}", "  ],", "  \"send_message\": true,", "  \"message\": \"First Join Message\",", "  \"send_title\": true,", "  \"title\": \"First join title!\",", "  \"subtitle\": \"First join subtitle\",", "  \"fadeIn\": 10,", "  \"stay\": 70,", "  \"fadeOut\": 20", "}");
        Files.write(configPath, lines, new OpenOption[0]);
    }
}

