/*
 * Decompiled with CFR 0.152.
 */
package occult.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import occult.entity.InkBallThrownEntity;
import occult.entity.OccultoreEntity;
import occult.entity.SeepingEntity;
import occult.entity.WeaverEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OccultModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"occult");
    public static final RegistryObject<EntityType<OccultoreEntity>> OCCULTORE = OccultModEntities.register("occultore", EntityType.Builder.m_20704_(OccultoreEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(OccultoreEntity::new).m_20699_(1.0f, 2.5f));
    public static final RegistryObject<EntityType<WeaverEntity>> WEAVER = OccultModEntities.register("weaver", EntityType.Builder.m_20704_(WeaverEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(WeaverEntity::new).m_20699_(2.0f, 2.5f));
    public static final RegistryObject<EntityType<SeepingEntity>> SEEPING = OccultModEntities.register("seeping", EntityType.Builder.m_20704_(SeepingEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SeepingEntity::new).m_20699_(1.0f, 2.5f));
    public static final RegistryObject<EntityType<InkBallThrownEntity>> INK_BALL_THROWN = OccultModEntities.register("ink_ball_thrown", EntityType.Builder.m_20704_(InkBallThrownEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(InkBallThrownEntity::new).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).m_20699_(0.5f, 0.5f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            OccultoreEntity.init();
            WeaverEntity.init();
            SeepingEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)OCCULTORE.get(), OccultoreEntity.createAttributes().m_22265_());
        event.put((EntityType)WEAVER.get(), WeaverEntity.createAttributes().m_22265_());
        event.put((EntityType)SEEPING.get(), SeepingEntity.createAttributes().m_22265_());
    }
}

