/*
 * Decompiled with CFR 0.152.
 */
package occult;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import occult.init.OccultModBlockEntities;
import occult.init.OccultModBlocks;
import occult.init.OccultModEnchantments;
import occult.init.OccultModEntities;
import occult.init.OccultModItems;
import occult.init.OccultModMenus;
import occult.init.OccultModMobEffects;
import occult.init.OccultModPaintings;
import occult.init.OccultModParticleTypes;
import occult.init.OccultModSounds;
import occult.init.OccultModTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="occult")
public class OccultMod {
    public static final Logger LOGGER = LogManager.getLogger(OccultMod.class);
    public static final String MODID = "occult";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("occult", "occult"), () -> "1", "1"::equals, clientVersion -> true);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public OccultMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        OccultModSounds.REGISTRY.register(bus);
        OccultModBlocks.REGISTRY.register(bus);
        OccultModBlockEntities.REGISTRY.register(bus);
        OccultModItems.REGISTRY.register(bus);
        OccultModEntities.REGISTRY.register(bus);
        OccultModEnchantments.REGISTRY.register(bus);
        OccultModTabs.REGISTRY.register(bus);
        OccultModMobEffects.REGISTRY.register(bus);
        OccultModPaintings.REGISTRY.register(bus);
        OccultModParticleTypes.REGISTRY.register(bus);
        OccultModMenus.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

