/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.chunk_access.mixin.async_chunk_request;

import com.ishland.c2me.base.common.util.CFUtil;
import com.ishland.c2me.opts.chunk_access.common.CurrentWorldGenState;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkCache.class})
public abstract class MixinServerChunkManager {
    @Shadow
    @Final
    private Thread f_8330_;
    @Shadow
    @Final
    private DistanceManager f_8327_;
    @Shadow
    @Final
    ServerLevel f_8329_;
    @Shadow
    @Final
    public ChunkMap f_8325_;
    @Shadow
    @Final
    public ServerChunkCache.MainThreadExecutor f_8332_;
    private static final TicketType<ChunkPos> ASYNC_LOAD = TicketType.m_9462_((String)"async_load", Comparator.comparingLong(ChunkPos::m_45588_));

    @Shadow
    @Nullable
    protected abstract ChunkHolder m_8364_(long var1);

    @Shadow
    protected abstract boolean m_8416_(@Nullable ChunkHolder var1, int var2);

    @Shadow
    public abstract boolean m_8489_();

    @Inject(method={"getChunk(IILnet/minecraft/world/chunk/ChunkStatus;Z)Lnet/minecraft/world/chunk/Chunk;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetChunk(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create, CallbackInfoReturnable<ChunkAccess> cir) {
        if (Thread.currentThread() != this.f_8330_) {
            cir.setReturnValue((Object)this.c2me$getChunkOffThread(chunkX, chunkZ, leastStatus, create));
        }
    }

    @Unique
    @Final
    private ChunkAccess c2me$getChunkOffThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        WorldGenRegion currentRegion = CurrentWorldGenState.getCurrentRegion();
        if (currentRegion != null) {
            ChunkAccess chunk = currentRegion.m_6522_(chunkX, chunkZ, leastStatus, false);
            if (chunk instanceof ImposterProtoChunk) {
                ImposterProtoChunk readOnlyChunk = (ImposterProtoChunk)chunk;
                chunk = readOnlyChunk.m_62768_();
            }
            if (chunk != null) {
                return chunk;
            }
        }
        CompletableFuture<ChunkAccess> chunkLoad = this.c2me$getChunkFutureOffThread(chunkX, chunkZ, leastStatus, create);
        assert (chunkLoad != null);
        return (ChunkAccess)CFUtil.join(chunkLoad);
    }

    @Unique
    @Final
    @Nullable
    private CompletableFuture<ChunkAccess> c2me$getChunkFutureOffThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            CompletableFuture future;
            boolean doCreate;
            ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
            long chunkPosLong = chunkPos.m_45588_();
            int ticketLevel = 33 + ChunkStatus.m_62370_((ChunkStatus)leastStatus);
            ChunkHolder chunkHolder = this.m_8364_(chunkPosLong);
            boolean bl = doCreate = create && (chunkHolder == null || this.m_8416_(chunkHolder, ticketLevel));
            if (doCreate) {
                this.f_8327_.m_140792_(ASYNC_LOAD, chunkPos, ticketLevel, (Object)chunkPos);
                if (this.m_8416_(chunkHolder, ticketLevel)) {
                    ProfilerFiller profiler = this.f_8329_.m_46473_();
                    profiler.m_6180_("chunkLoad");
                    this.m_8489_();
                    chunkHolder = this.m_8364_(chunkPosLong);
                    profiler.m_7238_();
                    if (this.m_8416_(chunkHolder, ticketLevel)) {
                        throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException("No chunk holder after ticket has been added"));
                    }
                }
            }
            CompletableFuture completableFuture = future = this.m_8416_(chunkHolder, ticketLevel) ? ChunkHolder.f_139996_ : chunkHolder.m_140049_(leastStatus, this.f_8325_);
            if (doCreate && future != null) {
                ((CompletableFuture)future.exceptionally(__ -> null)).thenRunAsync(() -> this.f_8327_.m_140823_(ASYNC_LOAD, chunkPos, ticketLevel, (Object)chunkPos), (Executor)this.f_8332_);
            }
            return future;
        }, (Executor)this.f_8332_).thenCompose(Function.identity())).thenApply(either -> (ChunkAccess)either.map(Function.identity(), unloaded -> {
            if (create) {
                throw (IllegalStateException)Util.m_137570_((Throwable)new IllegalStateException("Chunk not there when requested: " + String.valueOf(unloaded)));
            }
            return null;
        }));
    }
}

