/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.util;

import com.google.common.collect.Multimap;
import java.awt.Color;
import java.util.Map;
import javax.annotation.Nullable;
import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.item.ModItems;
import net.daphne.lethality.potion.IStackingEffect;
import net.mcreator.terramity.init.TerramityModParticleTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;

public class ModUtils {
    public static int[] changeBrightness(int[] colors, float factor) {
        int[] result = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            result[i] = (int)((float)colors[i] * factor);
        }
        return result;
    }

    public static Component tooltipHelper(String localeKey, boolean bold, ResourceLocation font, float waveSpeed, float spreadMultiplier, int[] ... colors) {
        if (font == null) {
            if (colors.length == 1) {
                return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_178520_(ModUtils.rgbToInt(colors[0])));
            }
            return ModUtils.addColorGradientText((Component)Component.m_237115_((String)localeKey), waveSpeed, spreadMultiplier, colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)));
        }
        if (colors.length == 1) {
            return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font).m_178520_(ModUtils.rgbToInt(colors[0])));
        }
        return ModUtils.addColorGradientText((Component)Component.m_237115_((String)localeKey), waveSpeed, spreadMultiplier, colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font));
    }

    public static MutableComponent tooltipHelper(String localeKey, boolean bold, ResourceLocation font, int[] ... colors) {
        if (font == null) {
            if (colors.length == 1) {
                return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_178520_(ModUtils.rgbToInt(colors[0])));
            }
            return ModUtils.addColorGradientText((Component)Component.m_237115_((String)localeKey), colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)));
        }
        if (colors.length == 1) {
            return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font).m_178520_(ModUtils.rgbToInt(colors[0])));
        }
        return ModUtils.addColorGradientText((Component)Component.m_237115_((String)localeKey), colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font));
    }

    public static int[] ensureVisible(int[] rgb) {
        float[] hsv = new float[3];
        Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], hsv);
        float minBrightness = 25.0f;
        float boost = 0.25f;
        if (hsv[2] < minBrightness) {
            hsv[2] = Math.min(1.0f, hsv[2] + boost);
        }
        int rgbInt = Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
        return new int[]{rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF, rgbInt & 0xFF};
    }

    public static int getColorFromGradient(int percentage, int[] ... rgbColors) {
        if (rgbColors.length < 2) {
            return ModUtils.rgbToInt(rgbColors[0]);
        }
        float ratio = (float)percentage / 100.0f;
        int totalSegments = rgbColors.length - 1;
        int segment = Math.min((int)(ratio * (float)totalSegments), totalSegments - 1);
        float localRatio = ratio * (float)totalSegments - (float)segment;
        int[] color1 = rgbColors[segment];
        int[] color2 = rgbColors[segment + 1];
        int r = (int)((1.0f - localRatio) * (float)color1[0] + localRatio * (float)color2[0]);
        int g = (int)((1.0f - localRatio) * (float)color1[1] + localRatio * (float)color2[1]);
        int b = (int)((1.0f - localRatio) * (float)color1[2] + localRatio * (float)color2[2]);
        return r << 16 | g << 8 | b;
    }

    public static MutableComponent addColorGradientText(Component text, float speed, float spreadMultiplier, int[] ... rgbColors) {
        MutableComponent gradientTextComponent = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        int numColors = rgbColors.length;
        if (numColors == 0 || length == 0) {
            return gradientTextComponent;
        }
        int tickCount = ModUtils.getTickCount();
        int[][] adjustedColors = new int[numColors + 1][3];
        System.arraycopy(rgbColors, 0, adjustedColors, 0, numColors);
        adjustedColors[numColors] = rgbColors[0];
        speed = 1.0f / speed;
        float effectiveTickCount = (float)tickCount % (speed * 20.0f);
        float ratio = effectiveTickCount / (speed * 20.0f);
        spreadMultiplier = 1.0f / spreadMultiplier;
        int effectiveLength = (int)((float)length * spreadMultiplier);
        for (int i = 0; i < length; ++i) {
            float adjustedIndex = ((float)i * spreadMultiplier / (float)length + ratio) * (float)effectiveLength;
            int percentage = (int)((adjustedIndex %= (float)effectiveLength) / (float)effectiveLength * 100.0f);
            int color = ModUtils.getColorFromGradient(percentage, adjustedColors);
            MutableComponent letterComponent = Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color));
            gradientTextComponent = gradientTextComponent.m_7220_((Component)letterComponent);
        }
        return gradientTextComponent;
    }

    public static MutableComponent addColorGradientText(Component text, int[] ... rgbColors) {
        MutableComponent gradientTextComponent = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        int numColors = rgbColors.length;
        if (numColors == 0 || length == 0) {
            return gradientTextComponent;
        }
        for (int i = 0; i < length; ++i) {
            int percentage = i * 100 / (length - 1);
            int color = ModUtils.getColorFromGradient(percentage, rgbColors);
            MutableComponent letterComponent = Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color));
            gradientTextComponent = gradientTextComponent.m_7220_((Component)letterComponent);
        }
        return gradientTextComponent;
    }

    public static MutableComponent addColorGradientTextWithFont(Component text, ResourceLocation font, float speed, float spreadMultiplier, int[] ... rgbColors) {
        MutableComponent gradientTextComponent = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        int numColors = rgbColors.length;
        if (numColors == 0 || length == 0) {
            return gradientTextComponent;
        }
        int tickCount = ModUtils.getTickCount();
        int[][] adjustedColors = new int[numColors + 1][3];
        System.arraycopy(rgbColors, 0, adjustedColors, 0, numColors);
        adjustedColors[numColors] = rgbColors[0];
        speed = 1.0f / speed;
        float effectiveTickCount = (float)tickCount % (speed * 20.0f);
        float ratio = effectiveTickCount / (speed * 20.0f);
        spreadMultiplier = 1.0f / spreadMultiplier;
        int effectiveLength = (int)((float)length * spreadMultiplier);
        for (int i = 0; i < length; ++i) {
            float adjustedIndex = ((float)i * spreadMultiplier / (float)length + ratio) * (float)effectiveLength;
            int percentage = (int)((adjustedIndex %= (float)effectiveLength) / (float)effectiveLength * 100.0f);
            int color = ModUtils.getColorFromGradient(percentage, adjustedColors);
            MutableComponent letterComponent = Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color).m_131150_(font));
            gradientTextComponent = gradientTextComponent.m_7220_((Component)letterComponent);
        }
        return gradientTextComponent;
    }

    public static int rgbToInt(int[] rgb) {
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int rgbToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int argbToInt(int[] rgb, int ... alpha) {
        int a = alpha.length > 0 ? alpha[0] : 255;
        rgb[0] = Math.max(0, Math.min(255, rgb[0]));
        rgb[1] = Math.max(0, Math.min(255, rgb[1]));
        rgb[2] = Math.max(0, Math.min(255, rgb[2]));
        return a << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int[] argbToRgb(int argb) {
        return new int[]{argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF};
    }

    public static float getItemAttackDamage(ItemStack weapon) {
        if (weapon.m_41619_()) {
            return 1.0f;
        }
        Multimap modifiers = weapon.m_41638_(EquipmentSlot.MAINHAND);
        double damage = 1.0;
        for (Map.Entry entry : modifiers.entries()) {
            if (!((Attribute)entry.getKey()).equals(Attributes.f_22281_)) continue;
            damage += ((AttributeModifier)entry.getValue()).m_22218_();
        }
        return (float)(damage += (double)EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)MobType.f_21640_));
    }

    public static int countBloodCoins(Player player) {
        int count = 0;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != ModItems.BLOOD_COIN.get()) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public static void consumeBloodCoins(Player player, int amount) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41720_() != ModItems.BLOOD_COIN.get()) continue;
            int toRemove = Math.min(amount, stack.m_41613_());
            stack.m_41774_(toRemove);
            if ((amount -= toRemove) <= 0) break;
        }
    }

    public static boolean hasFullBattleMaidSet(Player player) {
        ItemStack head = player.m_150109_().m_36052_(3);
        ItemStack chest = player.m_150109_().m_36052_(2);
        ItemStack legs = player.m_150109_().m_36052_(1);
        ItemStack feet = player.m_150109_().m_36052_(0);
        return head.m_41720_() == ModItems.BATTLE_MAID_HELMET.get() && chest.m_41720_() == ModItems.BATTLE_MAID_CHESTPLATE.get() && legs.m_41720_() == ModItems.BATTLE_MAID_LEGGINGS.get() && feet.m_41720_() == ModItems.BATTLE_MAID_BOOTS.get();
    }

    public static boolean hasFullHFMaidSet(Player player) {
        ItemStack head = player.m_150109_().m_36052_(3);
        ItemStack chest = player.m_150109_().m_36052_(2);
        ItemStack legs = player.m_150109_().m_36052_(1);
        ItemStack feet = player.m_150109_().m_36052_(0);
        return head.m_41720_() == ModItems.HF_BATTLE_MAID_HELMET.get() && chest.m_41720_() == ModItems.HF_BATTLE_MAID_CHESTPLATE.get() && legs.m_41720_() == ModItems.HF_BATTLE_MAID_LEGGINGS.get() && feet.m_41720_() == ModItems.HF_BATTLE_MAID_BOOTS.get();
    }

    private static boolean isStackingEffect(MobEffect effect) {
        Holder holder = BuiltInRegistries.f_256974_.m_263177_((Object)effect);
        return holder.m_203656_(ModMobEffects.STACKING_EFFECTS);
    }

    public static void applyEffect(MobEffectInstance instance, ItemStack source, LivingEntity target, @Nullable LivingEntity cause) {
        MobEffectInstance existing = target.m_21124_(instance.m_19544_());
        if (existing != null && ModUtils.isStackingEffect(instance.m_19544_())) {
            MobEffectInstance increased = new MobEffectInstance(instance.m_19544_(), instance.m_19557_(), existing.m_19564_() + 1, instance.m_19571_(), instance.m_19572_(), instance.m_19575_(), null, instance.m_216895_());
            target.m_7292_(increased);
            MobEffect mobEffect = instance.m_19544_();
            if (mobEffect instanceof IStackingEffect) {
                IStackingEffect stacking = (IStackingEffect)mobEffect;
                stacking.onIncreasedTo(increased, source, target, target.m_9236_());
            }
        } else if (instance.m_19544_().m_8093_()) {
            instance.m_19544_().m_19461_((Entity)cause, (Entity)cause, target, instance.m_19564_(), 1.0);
        } else {
            target.m_7292_(instance);
        }
    }

    public static void applyEffectPlus(MobEffectInstance instance, ItemStack source, LivingEntity target, @Nullable LivingEntity cause, int pAmplifier) {
        MobEffectInstance existing = target.m_21124_(instance.m_19544_());
        if (existing != null && ModUtils.isStackingEffect(instance.m_19544_())) {
            MobEffectInstance increased = new MobEffectInstance(instance.m_19544_(), instance.m_19557_(), existing.m_19564_() + pAmplifier, instance.m_19571_(), instance.m_19572_(), instance.m_19575_(), null, instance.m_216895_());
            target.m_7292_(increased);
            MobEffect mobEffect = instance.m_19544_();
            if (mobEffect instanceof IStackingEffect) {
                IStackingEffect stacking = (IStackingEffect)mobEffect;
                stacking.onIncreasedTo(increased, source, target, target.m_9236_());
            }
        } else if (instance.m_19544_().m_8093_()) {
            instance.m_19544_().m_19461_((Entity)cause, (Entity)cause, target, instance.m_19564_(), 1.0);
        } else {
            target.m_7292_(instance);
        }
    }

    public static void playHexedParticlesAndSound(LevelAccessor world, double x, double y, double z) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 0.72, z, 25, 0.0, 0.25, 0.0, 0.15);
        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)TerramityModParticleTypes.STYGIAN_PARTICLE.get()), x, y + 0.72, z, 35, 0.0, 0.25, 0.0, 0.15);
        if (world instanceof Level) {
            Level level = (Level)world;
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:hexed"));
            SoundEvent sound2 = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:hexed_super"));
            if (sound == null) {
                return;
            }
            if (!level.f_46443_) {
                level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), sound, SoundSource.PLAYERS, 2.0f, 1.0f);
                level.m_5594_(null, new BlockPos((int)x, (int)y, (int)z), sound2, SoundSource.PLAYERS, 0.75f, 1.0f);
            } else {
                level.m_7785_(x, y, z, sound, SoundSource.PLAYERS, 2.0f, 1.0f, false);
                level.m_7785_(x, y, z, sound2, SoundSource.PLAYERS, 0.75f, 1.0f, false);
            }
        }
    }

    private static int getTickCount() {
        Integer clientTicks = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            return mc.f_91074_ != null ? mc.f_91074_.f_19797_ : (int)(System.currentTimeMillis() / 50L);
        });
        return clientTicks != null ? clientTicks : (int)(System.currentTimeMillis() / 50L);
    }
}

