/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.item.custom.curios;

import java.util.List;
import java.util.UUID;
import net.daphne.lethality.util.ModUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class PaleBranchItem
extends Item
implements ICurioItem {
    private static final int TICKS_FOR_INVULNERABILITY = 60;
    private static final UUID KNOCKBACK_UUID = UUID.fromString("b84c8a4d-bd18-4796-9325-13d87532f84b");
    private static final AttributeModifier NO_KNOCKBACK = new AttributeModifier(KNOCKBACK_UUID, "Pale Branch Anchor", 1.0, AttributeModifier.Operation.ADDITION);

    public PaleBranchItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent baseName = Component.m_237115_((String)this.m_5671_(stack));
        return ModUtils.addColorGradientText((Component)baseName, 0.25f, 2.0f, (int[][])new int[][]{{85, 85, 85}, {128, 128, 128}, {192, 192, 192}, {192, 192, 192}, {128, 128, 128}, {85, 85, 85}});
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ResourceLocation MKART = new ResourceLocation("lethality", "mkart");
        MutableComponent legendaryText = ModUtils.addColorGradientTextWithFont((Component)Component.m_237113_((String)"tampico"), MKART, 0.5f, 5.0f, {255, 0, 0}, {255, 165, 0}, {255, 255, 0}, {0, 255, 0}, {0, 127, 255}, {0, 0, 255}, {139, 0, 255});
        pTooltipComponents.add((Component)legendaryText);
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.pale_branch.tooltip"));
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.pale_branch.advanced1"));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.pale_branch.advanced2"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (entity.m_9236_().m_5776_() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag tag = stack.m_41784_();
        double lastX = tag.m_128459_("lastX");
        double lastY = tag.m_128459_("lastY");
        double lastZ = tag.m_128459_("lastZ");
        double currentX = player.m_20185_();
        double currentY = player.m_20186_();
        double currentZ = player.m_20189_();
        double distanceSq = (currentX - lastX) * (currentX - lastX) + (currentY - lastY) * (currentY - lastY) + (currentZ - lastZ) * (currentZ - lastZ);
        tag.m_128347_("lastX", currentX);
        tag.m_128347_("lastY", currentY);
        tag.m_128347_("lastZ", currentZ);
        boolean isMoving = distanceSq > 4.0E-4;
        int timer = tag.m_128451_("StillTimer");
        boolean shouldBeInvulnerable = false;
        if (isMoving) {
            tag.m_128405_("StillTimer", 0);
            shouldBeInvulnerable = false;
        } else {
            tag.m_128405_("StillTimer", ++timer);
            if (timer >= 60) {
                shouldBeInvulnerable = true;
            }
        }
        if (shouldBeInvulnerable) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 5, 4, false, false, true));
            this.handleKnockback(player, true);
        } else {
            this.handleKnockback(player, false);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.handleKnockback(player, false);
        }
    }

    private void handleKnockback(Player player, boolean active) {
        boolean hasModifier;
        AttributeInstance knockbackAttribute = player.m_21051_(Attributes.f_22278_);
        if (knockbackAttribute == null) {
            return;
        }
        boolean bl = hasModifier = knockbackAttribute.m_22111_(KNOCKBACK_UUID) != null;
        if (active && !hasModifier) {
            knockbackAttribute.m_22118_(NO_KNOCKBACK);
        } else if (!active && hasModifier) {
            knockbackAttribute.m_22120_(KNOCKBACK_UUID);
        }
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return !context.entity().m_6047_();
    }
}

