/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.item.custom.curios;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BackupSOSItem
extends Item
implements ICurioItem {
    public BackupSOSItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent baseName = Component.m_237115_((String)this.m_5671_(stack));
        return BackupSOSItem.addColorGradientText((Component)baseName, 0.25f, 2.0f, (int[][])new int[][]{{42, 24, 42}, {54, 32, 54}, {54, 32, 54}, {75, 45, 83}, {75, 45, 83}, {92, 63, 109}, {92, 63, 109}, {75, 45, 83}, {75, 45, 83}, {54, 32, 54}, {54, 32, 54}, {42, 24, 42}});
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ResourceLocation MKART = new ResourceLocation("lethality", "mkart");
        MutableComponent legendaryText = BackupSOSItem.addColorGradientTextWithFont((Component)Component.m_237113_((String)"tampico"), MKART, 0.5f, 5.0f, {255, 0, 0}, {255, 165, 0}, {255, 255, 0}, {0, 255, 0}, {0, 127, 255}, {0, 0, 255}, {139, 0, 255});
        pTooltipComponents.add((Component)legendaryText);
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.sos.tooltip"));
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.sos.advanced1"));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.sos.advanced2"));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return !context.entity().m_6047_();
    }

    public static int[] changeBrightness(int[] colors, float factor) {
        int[] result = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            result[i] = (int)((float)colors[i] * factor);
        }
        return result;
    }

    public static Component tooltipHelper(String localeKey, boolean bold, ResourceLocation font, float waveSpeed, float spreadMultiplier, int[] ... colors) {
        if (font == null) {
            if (colors.length == 1) {
                return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_178520_(BackupSOSItem.rgbToInt(colors[0])));
            }
            return BackupSOSItem.addColorGradientText((Component)Component.m_237115_((String)localeKey), waveSpeed, spreadMultiplier, colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)));
        }
        if (colors.length == 1) {
            return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font).m_178520_(BackupSOSItem.rgbToInt(colors[0])));
        }
        return BackupSOSItem.addColorGradientText((Component)Component.m_237115_((String)localeKey), waveSpeed, spreadMultiplier, colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font));
    }

    public static MutableComponent tooltipHelper(String localeKey, boolean bold, ResourceLocation font, int[] ... colors) {
        if (font == null) {
            if (colors.length == 1) {
                return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_178520_(BackupSOSItem.rgbToInt(colors[0])));
            }
            return BackupSOSItem.addColorGradientText((Component)Component.m_237115_((String)localeKey), colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)));
        }
        if (colors.length == 1) {
            return Component.m_237115_((String)localeKey).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font).m_178520_(BackupSOSItem.rgbToInt(colors[0])));
        }
        return BackupSOSItem.addColorGradientText((Component)Component.m_237115_((String)localeKey), colors).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(bold)).m_131150_(font));
    }

    public static int[] ensureVisible(int[] rgb) {
        float[] hsv = new float[3];
        Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], hsv);
        float minBrightness = 25.0f;
        float boost = 0.25f;
        if (hsv[2] < minBrightness) {
            hsv[2] = Math.min(1.0f, hsv[2] + boost);
        }
        int rgbInt = Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
        return new int[]{rgbInt >> 16 & 0xFF, rgbInt >> 8 & 0xFF, rgbInt & 0xFF};
    }

    public static int getColorFromGradient(int percentage, int[] ... rgbColors) {
        if (rgbColors.length < 2) {
            return BackupSOSItem.rgbToInt(rgbColors[0]);
        }
        float ratio = (float)percentage / 100.0f;
        int totalSegments = rgbColors.length - 1;
        int segment = Math.min((int)(ratio * (float)totalSegments), totalSegments - 1);
        float localRatio = ratio * (float)totalSegments - (float)segment;
        int[] color1 = rgbColors[segment];
        int[] color2 = rgbColors[segment + 1];
        int r = (int)((1.0f - localRatio) * (float)color1[0] + localRatio * (float)color2[0]);
        int g = (int)((1.0f - localRatio) * (float)color1[1] + localRatio * (float)color2[1]);
        int b = (int)((1.0f - localRatio) * (float)color1[2] + localRatio * (float)color2[2]);
        return r << 16 | g << 8 | b;
    }

    public static MutableComponent addColorGradientText(Component text, float speed, float spreadMultiplier, int[] ... rgbColors) {
        MutableComponent gradientTextComponent = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        int numColors = rgbColors.length;
        if (numColors == 0 || length == 0) {
            return gradientTextComponent;
        }
        int tickCount = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                return Minecraft.m_91087_().f_91074_.f_19797_;
            }
            return (int)(System.currentTimeMillis() / 50L);
        });
        int[][] adjustedColors = new int[numColors + 1][3];
        System.arraycopy(rgbColors, 0, adjustedColors, 0, numColors);
        adjustedColors[numColors] = rgbColors[0];
        speed = 1.0f / speed;
        float effectiveTickCount = (float)tickCount % (speed * 20.0f);
        float ratio = effectiveTickCount / (speed * 20.0f);
        spreadMultiplier = 1.0f / spreadMultiplier;
        int effectiveLength = (int)((float)length * spreadMultiplier);
        for (int i = 0; i < length; ++i) {
            float adjustedIndex = ((float)i * spreadMultiplier / (float)length + ratio) * (float)effectiveLength;
            int percentage = (int)((adjustedIndex %= (float)effectiveLength) / (float)effectiveLength * 100.0f);
            int color = BackupSOSItem.getColorFromGradient(percentage, adjustedColors);
            MutableComponent letterComponent = Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color));
            gradientTextComponent = gradientTextComponent.m_7220_((Component)letterComponent);
        }
        return gradientTextComponent;
    }

    public static MutableComponent addColorGradientText(Component text, int[] ... rgbColors) {
        MutableComponent gradientTextComponent = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        int numColors = rgbColors.length;
        if (numColors == 0 || length == 0) {
            return gradientTextComponent;
        }
        for (int i = 0; i < length; ++i) {
            int percentage = i * 100 / (length - 1);
            int color = BackupSOSItem.getColorFromGradient(percentage, rgbColors);
            MutableComponent letterComponent = Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color));
            gradientTextComponent = gradientTextComponent.m_7220_((Component)letterComponent);
        }
        return gradientTextComponent;
    }

    public static MutableComponent addColorGradientTextWithFont(Component text, ResourceLocation font, float speed, float spreadMultiplier, int[] ... rgbColors) {
        MutableComponent gradientTextComponent = Component.m_237119_();
        String string = text.getString();
        int length = string.length();
        int numColors = rgbColors.length;
        if (numColors == 0 || length == 0) {
            return gradientTextComponent;
        }
        int tickCount = (Integer)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                return Minecraft.m_91087_().f_91074_.f_19797_;
            }
            return (int)(System.currentTimeMillis() / 50L);
        });
        int[][] adjustedColors = new int[numColors + 1][3];
        System.arraycopy(rgbColors, 0, adjustedColors, 0, numColors);
        adjustedColors[numColors] = rgbColors[0];
        speed = 1.0f / speed;
        float effectiveTickCount = (float)tickCount % (speed * 20.0f);
        float ratio = effectiveTickCount / (speed * 20.0f);
        spreadMultiplier = 1.0f / spreadMultiplier;
        int effectiveLength = (int)((float)length * spreadMultiplier);
        for (int i = 0; i < length; ++i) {
            float adjustedIndex = ((float)i * spreadMultiplier / (float)length + ratio) * (float)effectiveLength;
            int percentage = (int)((adjustedIndex %= (float)effectiveLength) / (float)effectiveLength * 100.0f);
            int color = BackupSOSItem.getColorFromGradient(percentage, adjustedColors);
            MutableComponent letterComponent = Component.m_237113_((String)String.valueOf(string.charAt(i))).m_130948_(Style.f_131099_.m_178520_(color).m_131150_(font));
            gradientTextComponent = gradientTextComponent.m_7220_((Component)letterComponent);
        }
        return gradientTextComponent;
    }

    public static int rgbToInt(int[] rgb) {
        return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int rgbToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public static int argbToInt(int[] rgb, int ... alpha) {
        int a = alpha.length > 0 ? alpha[0] : 255;
        rgb[0] = Math.max(0, Math.min(255, rgb[0]));
        rgb[1] = Math.max(0, Math.min(255, rgb[1]));
        rgb[2] = Math.max(0, Math.min(255, rgb[2]));
        return a << 24 | rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    }

    public static int[] argbToRgb(int argb) {
        return new int[]{argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF};
    }
}

