/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.item.custom;

import java.util.List;
import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.item.ModToolTiers;
import net.daphne.lethality.util.ModRarities;
import net.daphne.lethality.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class NightfallItem
extends SwordItem {
    public NightfallItem(Item.Properties pProperties) {
        super(ModToolTiers.SILLY, 17, -3.0f, new Item.Properties());
    }

    public Rarity m_41460_(ItemStack stack) {
        return ModRarities.STRANGE;
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent baseName = Component.m_237115_((String)this.m_5671_(stack));
        return ModUtils.addColorGradientText((Component)baseName, 0.25f, 2.0f, (int[][])new int[][]{{0, 104, 93}, {0, 159, 142}, {89, 255, 193}, {167, 255, 216}, {167, 255, 216}, {89, 255, 193}, {0, 159, 142}, {0, 104, 93}}).m_130940_(ChatFormatting.BOLD);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ResourceLocation VERMIN = new ResourceLocation("lethality", "vermin");
        ResourceLocation MKART = new ResourceLocation("lethality", "mkart");
        ResourceLocation STRANGE = new ResourceLocation("lethality", "grapesoda");
        ResourceLocation CALAMITOUS = new ResourceLocation("lethality", "homicide");
        MutableComponent legendaryText = ModUtils.addColorGradientTextWithFont((Component)Component.m_237113_((String)"Strange"), STRANGE, 0.1f, 5.0f, {255, 167, 175}, {255, 196, 175}, {255, 225, 175}, {255, 237, 181}, {255, 243, 181}, {255, 249, 181}, {255, 255, 181}, {243, 255, 181}, {232, 255, 181}, {220, 255, 181}, {208, 255, 181}, {191, 255, 179}, {179, 255, 204}, {179, 255, 229}, {179, 255, 255}, {179, 225, 255}, {179, 196, 255}, {179, 162, 255}, {196, 162, 255}, {225, 162, 255}, {255, 162, 255}, {255, 162, 225}, {255, 162, 196}, {255, 162, 162}, {255, 192, 192}, {255, 222, 222}, {255, 237, 237}, {255, 247, 247}, {255, 255, 255}, {237, 255, 255}, {222, 255, 237}, {222, 255, 222}, {222, 255, 211}, {222, 255, 196}, {222, 255, 181}, {222, 243, 181}, {222, 232, 181}, {222, 220, 181}, {222, 208, 181}, {222, 196, 181}, {222, 181, 181}, {222, 167, 181}, {222, 153, 181}, {222, 139, 181}, {222, 125, 181}, {222, 111, 181}, {222, 97, 181});
        pTooltipComponents.add((Component)legendaryText);
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.tooltip"));
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        float value = NightfallItem.getAccumulatedShield(pStack);
        if (value > 0.0f) {
            MutableComponent shieldText = ModUtils.addColorGradientTextWithFont((Component)Component.m_237113_((String)String.format("SHIELD:%.1f", Float.valueOf(value))), VERMIN, 0.5f, 5.0f, {0, 104, 93}, {0, 159, 142}, {89, 255, 193}, {167, 255, 216}, {167, 255, 216}, {89, 255, 193}, {0, 159, 142}, {0, 104, 93});
            pTooltipComponents.add((Component)shieldText);
        }
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.advanced1"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.advanced2"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.advanced3"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.advanced4"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.advanced5"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.nightfall.advanced6"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.hold_ctrl"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lethality", "nightfall_hit"));
        float pitch = Mth.m_216267_((RandomSource)pAttacker.m_217043_(), (float)0.8f, (float)1.2f);
        float volume = 5.0f;
        if (pAttacker.m_9236_().m_5776_()) {
            pAttacker.m_9236_().m_245747_(pAttacker.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch, false);
        } else {
            pAttacker.m_9236_().m_5594_(null, pAttacker.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
        }
        pTarget.f_19802_ = 0;
        pTarget.m_6469_(pTarget.m_269291_().m_269104_((Entity)pAttacker, (Entity)pAttacker), pTarget.m_21233_() / 20.0f);
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public static void addAccumulatedShield(ItemStack stack, Player player, float amount) {
        if (player.m_21023_((MobEffect)ModMobEffects.IRON_WILL.get())) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        float current = tag.m_128457_("ShieldCharge");
        tag.m_128350_("ShieldCharge", current + amount);
    }

    public static float getAccumulatedShield(ItemStack stack) {
        return stack.m_41784_().m_128457_("ShieldCharge");
    }

    public static void resetShield(ItemStack stack) {
        stack.m_41784_().m_128350_("ShieldCharge", 0.0f);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        float accumulated = NightfallItem.getAccumulatedShield(stack);
        if (!level.f_46443_) {
            boolean hasShield = player.m_21023_((MobEffect)ModMobEffects.IRON_WILL.get());
            if (hasShield) {
                float absorption = player.m_6103_();
                float heal = absorption * 0.6f;
                player.m_5634_(heal);
                player.m_7911_(0.0f);
                player.m_21195_((MobEffect)ModMobEffects.IRON_WILL.get());
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lethality", "nightfall_shield_recast"));
                float pitch = Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f);
                float volume = 1.0f;
                if (player.m_9236_().m_5776_()) {
                    player.m_9236_().m_245747_(player.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch, false);
                } else {
                    player.m_9236_().m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
                }
                player.m_36335_().m_41524_((Item)this, 200);
            } else if (accumulated > 1.0f) {
                player.m_7911_(accumulated);
                player.m_7292_(new MobEffectInstance((MobEffect)ModMobEffects.IRON_WILL.get(), 200, 0));
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lethality", "nightfall_shield_use"));
                float pitch = Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f);
                float volume = 1.0f;
                if (!player.m_9236_().f_46443_) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
                }
                NightfallItem.resetShield(stack);
            }
        }
        player.m_21011_(hand, true);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static void setInternalCooldown(ItemStack stack, int ticks) {
        stack.m_41784_().m_128405_("NightfallCooldown", ticks);
    }

    public static int getInternalCooldown(ItemStack stack) {
        return stack.m_41784_().m_128451_("NightfallCooldown");
    }

    public static void tickCooldown(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        int current = tag.m_128451_("NightfallCooldown");
        if (current > 0) {
            tag.m_128405_("NightfallCooldown", current - 1);
        }
    }

    public static boolean hadIronWill(ItemStack stack) {
        return stack.m_41784_().m_128471_("HadIronWill");
    }

    public static void setHadIronWill(ItemStack stack, boolean value) {
        stack.m_41784_().m_128379_("HadIronWill", value);
    }
}

