/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.item.custom;

import java.util.List;
import net.daphne.lethality.entity.AcidicSlashEntity;
import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.item.ModItems;
import net.daphne.lethality.item.ModToolTiers;
import net.daphne.lethality.util.ModRarities;
import net.daphne.lethality.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DefiledGreatswordItem
extends SwordItem {
    public DefiledGreatswordItem(Item.Properties pProperties) {
        super(ModToolTiers.TAINTED, 15, -2.0f, new Item.Properties());
    }

    public Rarity m_41460_(ItemStack stack) {
        return ModRarities.CALAMITOUS;
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent baseName = Component.m_237115_((String)this.m_5671_(stack));
        return ModUtils.addColorGradientText((Component)baseName, 0.25f, 2.0f, (int[][])new int[][]{{255, 254, 251}, {255, 242, 203}, {255, 227, 192}, {255, 221, 177}, {255, 202, 153}, {255, 172, 131}, {255, 156, 119}, {255, 139, 107}, {252, 114, 94}, {251, 101, 87}, {235, 75, 76}, {232, 72, 68}, {255, 64, 0}, {255, 0, 0}, {255, 0, 0}, {197, 32, 57}, {150, 0, 100}, {127, 0, 175}, {170, 0, 210}, {210, 0, 240}, {255, 0, 255}, {255, 75, 165}, {255, 98, 176}, {255, 130, 192}, {255, 158, 189}, {255, 170, 197}, {255, 191, 201}, {255, 221, 203}, {255, 227, 203}, {255, 242, 203}, {255, 254, 251}}).m_130940_(ChatFormatting.BOLD);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ResourceLocation VERMIN = new ResourceLocation("lethality", "vermin");
        ResourceLocation MKART = new ResourceLocation("lethality", "mkart");
        ResourceLocation STRANGE = new ResourceLocation("lethality", "grapesoda");
        ResourceLocation CALAMITOUS = new ResourceLocation("lethality", "homicide");
        MutableComponent legendaryText = ModUtils.addColorGradientTextWithFont((Component)Component.m_237113_((String)"Calamitous"), CALAMITOUS, 0.25f, 5.0f, {255, 254, 251}, {255, 242, 203}, {255, 221, 177}, {255, 202, 153}, {255, 172, 131}, {255, 156, 119}, {255, 139, 107}, {252, 114, 94}, {251, 101, 87}, {235, 75, 76}, {197, 32, 57}, {235, 75, 76}, {251, 101, 87}, {252, 114, 94}, {255, 139, 107}, {255, 156, 119}, {255, 172, 131}, {255, 202, 153}, {255, 221, 177}, {255, 254, 251});
        pTooltipComponents.add((Component)legendaryText);
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.defiled_greatsword.tooltip"));
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.defiled_greatsword.advanced1"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.defiled_greatsword.advanced2"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.defiled_greatsword.advanced3"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.defiled_greatsword.advanced4"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.hold_ctrl"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        int currentAmplifier = 0;
        if (pTarget.m_21023_((MobEffect)ModMobEffects.ACID_VENOM.get())) {
            currentAmplifier = pTarget.m_21124_((MobEffect)ModMobEffects.ACID_VENOM.get()).m_19564_() + 1;
        }
        currentAmplifier = Math.min(currentAmplifier, 4);
        pTarget.m_147207_(new MobEffectInstance((MobEffect)ModMobEffects.ACID_VENOM.get(), 200, currentAmplifier), (Entity)pAttacker);
        pTarget.m_147207_(new MobEffectInstance((MobEffect)ModMobEffects.HELLFIRE.get(), 200, currentAmplifier), (Entity)pAttacker);
        pTarget.f_19802_ = 0;
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public static void shootTripleAcidicSlash(Level world, Player user) {
        for (InteractionHand hand : InteractionHand.values()) {
            boolean acceptItem;
            ItemStack itemStack = user.m_21120_(hand);
            boolean bl = acceptItem = itemStack.m_41720_() == ModItems.DEFILED_GREATSWORD.get();
            if (!acceptItem) continue;
            boolean hasBetterCombat = ModList.get().isLoaded("bettercombat");
            if (!hasBetterCombat) {
                if (user.m_36335_().m_41519_(itemStack.m_41720_())) {
                    return;
                }
                float attackSpeed = 4.0f;
                AttributeInstance attribute = user.m_21051_(Attributes.f_22283_);
                if (attribute != null) {
                    attackSpeed = (float)attribute.m_22135_();
                }
                int cooldownTicks = (int)(20.0f / attackSpeed);
                user.m_36335_().m_41524_(itemStack.m_41720_(), cooldownTicks);
            }
            if (!world.f_46443_) {
                float fullDamage = ModUtils.getItemAttackDamage(user.m_21120_(hand));
                float halfDamage = fullDamage * 0.5f;
                float speed = 1.75f;
                float inaccuracy = 0.5f;
                float angleOffset = 25.0f;
                AcidicSlashEntity center = new AcidicSlashEntity(world, user.m_20185_(), user.m_20186_() + 0.25, user.m_20189_(), halfDamage, 100);
                center.m_20256_(user.m_20154_());
                center.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, speed, inaccuracy);
                center.m_5602_((Entity)user);
                world.m_7967_((Entity)center);
                AcidicSlashEntity left = new AcidicSlashEntity(world, user.m_20185_(), user.m_20186_() + 0.25, user.m_20189_(), halfDamage, 100);
                left.m_20256_(user.m_20154_());
                left.m_37251_((Entity)user, user.m_146909_(), user.m_146908_() - angleOffset, 0.0f, speed, inaccuracy);
                left.m_5602_((Entity)user);
                world.m_7967_((Entity)left);
                AcidicSlashEntity right = new AcidicSlashEntity(world, user.m_20185_(), user.m_20186_() + 0.25, user.m_20189_(), halfDamage, 100);
                right.m_20256_(user.m_20154_());
                right.m_37251_((Entity)user, user.m_146909_(), user.m_146908_() + angleOffset, 0.0f, speed, inaccuracy);
                right.m_5602_((Entity)user);
                world.m_7967_((Entity)right);
            }
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:crescent_moonblade_wave"));
            float pitch = Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)1.1f, (float)1.3f);
            float volume = 1.5f;
            if (!world.m_5776_()) {
                world.m_5594_(null, user.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
                continue;
            }
            world.m_245747_(user.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch, false);
        }
    }
}

