/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.item.custom;

import java.util.List;
import net.daphne.lethality.client.RadialModeHandler;
import net.daphne.lethality.entity.BBBProjectionEntity;
import net.daphne.lethality.item.ModToolTiers;
import net.daphne.lethality.util.ModRarities;
import net.daphne.lethality.util.ModUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class BrokenBiomeBladeItem
extends SwordItem {
    private static final String MODE_KEY = "BiomeBladeMode";

    public BrokenBiomeBladeItem(Item.Properties pProperties) {
        super(ModToolTiers.BIOME, 7, -2.4f, new Item.Properties());
    }

    public Rarity m_41460_(ItemStack stack) {
        return ModRarities.CALAMITOUS;
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent baseName = Component.m_237115_((String)this.m_5671_(stack));
        return ModUtils.addColorGradientText((Component)baseName, 0.25f, 2.0f, (int[][])new int[][]{{255, 75, 0}, {255, 120, 0}, {255, 160, 0}, {255, 185, 0}, {255, 205, 0}}).m_130940_(ChatFormatting.BOLD);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ResourceLocation VERMIN = new ResourceLocation("lethality", "vermin");
        ResourceLocation MKART = new ResourceLocation("lethality", "mkart");
        ResourceLocation CALAMITOUS = new ResourceLocation("lethality", "homicide");
        MutableComponent legendaryText = ModUtils.addColorGradientTextWithFont((Component)Component.m_237113_((String)"W.I.P"), VERMIN, 0.5f, 1.0f, {55, 55, 55}, {255, 255, 0});
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.wip_warning"));
        pTooltipComponents.add((Component)legendaryText);
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.tooltip"));
        pTooltipComponents.add((Component)Component.m_237113_((String)" "));
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced1"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced2"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced3"));
            pTooltipComponents.add((Component)Component.m_237113_((String)" "));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced4"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced5"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced6"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced7"));
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.broken_biome_blade.advanced8"));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.lethality.hold_ctrl"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        if (!pStack.m_41782_()) {
            return super.m_7579_(pStack, pTarget, pAttacker);
        }
        int mode = pStack.m_41784_().m_128451_(MODE_KEY);
        pTarget.f_19802_ = 0;
        switch (mode) {
            case 1: {
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
                break;
            }
            case 2: {
                pTarget.m_20254_(4);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                pTarget.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100, 1));
            }
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    private int getMode(ItemStack stack) {
        return stack.m_41784_().m_128451_(MODE_KEY);
    }

    public static void setMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_(MODE_KEY, mode);
    }

    public static void shootProjection(Level world, Player user) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack itemStack = user.m_21120_(hand);
            boolean acceptItem = itemStack.m_41720_() instanceof BrokenBiomeBladeItem;
            if (!acceptItem) continue;
            int mode = itemStack.m_41784_().m_128451_(MODE_KEY);
            if (mode != 0) {
                return;
            }
            boolean hasBetterCombat = ModList.get().isLoaded("bettercombat");
            if (!hasBetterCombat) {
                if (user.m_36335_().m_41519_(itemStack.m_41720_())) {
                    return;
                }
                float attackSpeed = 4.0f;
                AttributeInstance attribute = user.m_21051_(Attributes.f_22283_);
                if (attribute != null) {
                    attackSpeed = (float)attribute.m_22135_();
                }
                int cooldownTicks = (int)(20.0f / attackSpeed);
                user.m_36335_().m_41524_(itemStack.m_41720_(), cooldownTicks);
            }
            if (!world.f_46443_) {
                float fullDamage = ModUtils.getItemAttackDamage(user.m_21120_(hand));
                float halfDamage = fullDamage * 0.5f;
                BBBProjectionEntity entity = new BBBProjectionEntity(world, user.m_20185_(), user.m_20186_() + 0.25, user.m_20189_(), halfDamage);
                entity.m_20256_(user.m_20154_());
                entity.m_37251_((Entity)user, user.m_146909_(), user.m_146908_(), 0.0f, 1.5f, 1.0f);
                entity.m_5602_((Entity)user);
                world.m_7967_((Entity)entity);
            }
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:crescent_moonblade_wave"));
            float pitch = Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)1.1f, (float)1.3f);
            float volume = 1.5f;
            if (!world.m_5776_()) {
                world.m_5594_(null, user.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
                continue;
            }
            world.m_245747_(user.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch, false);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        SoundEvent transmute = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:transmute"));
        SoundEvent bass = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:bassy_thud"));
        SoundEvent unlock = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:unlock"));
        SoundEvent zap = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:slash2"));
        SoundEvent ascend = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:ascendedtop"));
        float pitch = Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)1.0f, (float)1.5f);
        float volume = 0.35f;
        if (!level.m_5776_()) {
            level.m_5594_(null, player.m_20183_(), transmute, SoundSource.PLAYERS, 0.75f, pitch);
            level.m_5594_(null, player.m_20183_(), bass, SoundSource.PLAYERS, volume, pitch);
            level.m_5594_(null, player.m_20183_(), unlock, SoundSource.PLAYERS, volume, pitch);
            level.m_5594_(null, player.m_20183_(), zap, SoundSource.PLAYERS, volume, pitch);
            level.m_5594_(null, player.m_20183_(), ascend, SoundSource.PLAYERS, volume, pitch);
        } else {
            level.m_245747_(player.m_20183_(), transmute, SoundSource.PLAYERS, 0.75f, pitch, false);
            level.m_245747_(player.m_20183_(), bass, SoundSource.PLAYERS, volume, pitch, false);
            level.m_245747_(player.m_20183_(), unlock, SoundSource.PLAYERS, volume, pitch, false);
            level.m_245747_(player.m_20183_(), zap, SoundSource.PLAYERS, volume, pitch, false);
            level.m_245747_(player.m_20183_(), bass, SoundSource.PLAYERS, volume, pitch, false);
            level.m_245747_(player.m_20183_(), ascend, SoundSource.PLAYERS, volume, pitch, false);
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseDuration) {
        if (level.f_46443_ && entity instanceof Player) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ == null && !RadialModeHandler.isOpen) {
                RadialModeHandler.open(stack);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        SoundEvent zap = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:slash2"));
        SoundEvent bass = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:bassy_thud"));
        SoundEvent ascend = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("terramity:ascendedtop"));
        float pitch = Mth.m_216267_((RandomSource)RandomSource.m_216327_(), (float)1.0f, (float)1.5f);
        float volume = 0.35f;
        if (!level.m_5776_()) {
            level.m_5594_(null, entity.m_20183_(), zap, SoundSource.PLAYERS, 0.75f, pitch);
            level.m_5594_(null, entity.m_20183_(), bass, SoundSource.PLAYERS, volume, pitch);
            level.m_5594_(null, entity.m_20183_(), ascend, SoundSource.PLAYERS, volume, pitch);
        } else {
            level.m_245747_(entity.m_20183_(), zap, SoundSource.PLAYERS, 0.75f, pitch, false);
            level.m_245747_(entity.m_20183_(), bass, SoundSource.PLAYERS, volume, pitch, false);
            level.m_245747_(entity.m_20183_(), ascend, SoundSource.PLAYERS, volume, pitch, false);
        }
    }
}

