/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.events;

import java.util.Iterator;
import net.daphne.lethality.events.ScheduledViolence;
import net.daphne.lethality.events.ViolenceDamageScheduler;
import net.daphne.lethality.item.ModItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lethality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ViolenceEvents {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        ItemStack held;
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        float damage = event.getAmount();
        if (source instanceof Player && (held = (player = (Player)source).m_21205_()).m_150930_((Item)ModItems.VIOLENCE.get())) {
            target.f_19802_ = 0;
            ViolenceDamageScheduler.schedule(target, damage, 4);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ViolenceDamageScheduler.flushNew();
        Iterator<ScheduledViolence> iterator = ViolenceDamageScheduler.scheduled.iterator();
        while (iterator.hasNext()) {
            ScheduledViolence scheduled = iterator.next();
            --scheduled.ticksRemaining;
            if (scheduled.ticksRemaining > 0) continue;
            for (ServerLevel level : ServerLifecycleHooks.getCurrentServer().m_129785_()) {
                Player player;
                ItemStack held;
                LivingEntity target;
                LivingEntity livingEntity;
                Entity entity = level.m_8791_(scheduled.targetUUID);
                if (!(entity instanceof LivingEntity) || !((livingEntity = (target = (LivingEntity)entity).m_21188_()) instanceof Player) || !(held = (player = (Player)livingEntity).m_21205_()).m_150930_((Item)ModItems.VIOLENCE.get())) continue;
                target.f_19802_ = 0;
                DamageSource delayedSource = target.m_9236_().m_269111_().m_269075_(player);
                target.m_6469_(delayedSource, scheduled.damage);
            }
            iterator.remove();
        }
    }
}

