/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.events;

import net.daphne.lethality.item.ModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lethality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SacrificeEvents {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Player player;
        ItemStack held;
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player && (held = (player = (Player)source).m_21205_()).m_150930_((Item)ModItems.SACRIFICE.get()) && SacrificeEvents.isAttackFromBehind((Entity)player, target)) {
            event.setAmount(event.getAmount() * 3.0f);
            target.f_19802_ = 0;
        }
    }

    private static boolean isAttackFromBehind(Entity attacker, LivingEntity target) {
        double targetYaw = SacrificeEvents.wrapAngleTo180(target.m_146908_());
        double angleToAttacker = Math.toDegrees(Math.atan2(attacker.m_20185_() - target.m_20185_(), attacker.m_20189_() - target.m_20189_()));
        return Math.abs(SacrificeEvents.wrapAngleTo180((angleToAttacker = SacrificeEvents.wrapAngleTo180(angleToAttacker)) - targetYaw)) > 135.0;
    }

    private static double wrapAngleTo180(double angle) {
        if ((angle %= 360.0) >= 180.0) {
            angle -= 360.0;
        }
        if (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }
}

