/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.events;

import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.item.custom.NightfallItem;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lethality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NightfallEvents {
    @SubscribeEvent
    public static void onPlayerDamageEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof NightfallItem)) {
            return;
        }
        float accumulated = event.getAmount() * 0.025f;
        NightfallItem.addAccumulatedShield(stack, player, accumulated);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        float absorption;
        float heal;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof NightfallItem)) {
            return;
        }
        NightfallItem.tickCooldown(stack);
        boolean currentlyHas = player.m_21023_((MobEffect)ModMobEffects.IRON_WILL.get());
        boolean previouslyHad = NightfallItem.hadIronWill(stack);
        if (!currentlyHas && previouslyHad && (heal = (absorption = player.m_6103_()) * 0.5f) > 0.0f) {
            player.m_5634_(heal);
            player.m_7911_(0.0f);
            NightfallItem.resetShield(stack);
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lethality", "nightfall_shield_recast"));
            float pitch = Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f);
            float volume = 1.0f;
            player.m_9236_().m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
            player.m_36335_().m_41524_(stack.m_41720_(), 200);
        }
        NightfallItem.setHadIronWill(stack, currentlyHas);
    }
}

