/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.events;

import java.util.Set;
import net.daphne.lethality.item.ModItems;
import net.daphne.lethality.particles.ModParticles;
import net.daphne.lethality.util.ModUtils;
import net.mcreator.terramity.init.TerramityModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="lethality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GamblersBladeEvents {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        DamageSource source = event.getSource();
        Entity attacker = source.m_7639_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        ItemStack mainHand = livingAttacker.m_21205_();
        if (!mainHand.m_150930_((Item)ModItems.GAMBLERS_BLADE.get())) {
            return;
        }
        Set<Item> gamblingCurios = Set.of((Item)TerramityModItems.POKER_CHIP_BRACELETS.get(), (Item)TerramityModItems.GAMBLERS_RING.get(), (Item)TerramityModItems.WEIGHTED_DIE.get(), (Item)TerramityModItems.DEVILS_DICE.get(), (Item)TerramityModItems.LUCKY_DICE.get(), (Item)TerramityModItems.DIE_OF_REVIVAL.get(), (Item)TerramityModItems.NULLIFYING_DICE.get(), (Item)TerramityModItems.FATEFUL_COIN.get());
        int[] equippedCount = new int[]{0};
        CuriosApi.getCuriosHelper().getEquippedCurios(livingAttacker).ifPresent(curios -> {
            for (int i = 0; i < curios.getSlots(); ++i) {
                ItemStack stack = curios.getStackInSlot(i);
                if (stack.m_41619_() || !gamblingCurios.contains(stack.m_41720_())) continue;
                equippedCount[0] = equippedCount[0] + 1;
            }
        });
        if (equippedCount[0] > 0) {
            float originalDamage = event.getAmount();
            float multiplier = 1.0f + 0.25f * (float)equippedCount[0];
            float boostedDamage = originalDamage * multiplier;
            event.setAmount(boostedDamage);
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        Player player;
        ItemStack mainhand;
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        BlockPos pos = target.m_20183_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        if (livingAttacker instanceof Player && (mainhand = (player = (Player)livingAttacker).m_21205_()).m_41720_() == ModItems.GAMBLERS_BLADE.get()) {
            int bloodCoins = ModUtils.countBloodCoins(player);
            float chance = bloodCoins;
            float roll = player.m_217043_().m_188501_() * 100.0f;
            if (roll < chance) {
                float baseDamage = event.getAmount();
                float criticalDamage = baseDamage * 2.5f;
                event.setAmount(criticalDamage);
                target.f_19802_ = 0;
                int toConsume = Mth.m_14045_((int)(player.m_217043_().m_188503_(7) + 1), (int)1, (int)bloodCoins);
                ModUtils.consumeBloodCoins(player, toConsume);
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_5594_(null, pos, SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.REAL_CRIT.get()), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 30, 0.3, 0.5, 0.3, 0.3);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack mainhand = player.m_21205_();
        if (!mainhand.m_150930_((Item)ModItems.GAMBLERS_BLADE.get())) {
            return;
        }
        LivingEntity target = event.getEntity();
        if (!target.m_9236_().f_46443_ && !(target instanceof Player)) {
            ItemStack drop = new ItemStack((ItemLike)ModItems.BLOOD_COIN.get());
            target.m_19983_(drop);
        }
    }
}

