/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.daphne.lethality.entity.UltraSOSBiteEntity;
import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.item.ModItems;
import net.daphne.lethality.item.custom.RealKnifeItem;
import net.mcreator.terramity.init.TerramityModMobEffects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="lethality", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEvents {
    private static final Map<UUID, Integer> playerCooldowns = new HashMap<UUID, Integer>();
    private static final Random random = new Random();

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof RealKnifeItem) {
            CompoundTag tag = heldItem.m_41784_();
            int kills = tag.m_128451_("KillCount");
            tag.m_128405_("KillCount", kills + 1);
            if (!player.m_21023_((MobEffect)ModMobEffects.RAGE.get())) {
                int genocide = tag.m_128451_("GenocideCount");
                tag.m_128405_("GenocideCount", genocide + 1);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        ItemEntity drop;
        ItemStack itemToDrop;
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_9236_().m_5776_()) {
            return;
        }
        String entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        if (entityId.equals("terramity:gob")) {
            itemToDrop = new ItemStack((ItemLike)ModItems.SKYSPLITTER_SWORD.get());
            drop = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), itemToDrop);
            drop.m_32060_();
            event.getDrops().add(drop);
        }
        if (entityId.equals("terramity:super_sniffer")) {
            itemToDrop = new ItemStack((ItemLike)ModItems.SWORD_OF_ACCLAIM.get());
            drop = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), itemToDrop);
            drop.m_32060_();
            event.getDrops().add(drop);
        }
        if (entityId.equals("terramity:trial_guardian")) {
            itemToDrop = new ItemStack((ItemLike)ModItems.SWORD_OF_SPLENDOR.get());
            drop = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), itemToDrop);
            drop.m_32060_();
            event.getDrops().add(drop);
        }
        if (entityId.equals("terramity:gundalf")) {
            itemToDrop = new ItemStack((ItemLike)ModItems.SWORD_OF_MAJESTY.get());
            drop = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_() + 0.5, entity.m_20189_(), itemToDrop);
            drop.m_32060_();
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public static void onHeadtakerKill(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_21205_().m_150930_((Item)ModItems.HORSELESS_HEADLESS_HORSEMANNS_HEADTAKER.get())) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 0));
            int lootingLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44982_, (ItemStack)player.m_21205_());
            double dropChance = 0.1 + (double)lootingLevel * 0.05;
            LivingEntity victim = event.getEntity();
            if ((double)player.m_217043_().m_188501_() < dropChance) {
                ItemStack head = ItemStack.f_41583_;
                if (victim instanceof Zombie) {
                    head = new ItemStack((ItemLike)Items.f_42681_);
                } else if (victim instanceof Skeleton) {
                    head = new ItemStack((ItemLike)Items.f_42678_);
                } else if (victim instanceof Creeper) {
                    head = new ItemStack((ItemLike)Items.f_42682_);
                } else if (victim instanceof WitherSkeleton) {
                    head = new ItemStack((ItemLike)Items.f_42679_);
                } else if (victim instanceof Player) {
                    head = new ItemStack((ItemLike)Items.f_42680_);
                    head.m_41784_().m_128359_("SkullOwner", victim.m_7755_().getString());
                }
                if (!head.m_41619_()) {
                    victim.m_19983_(head);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        UUID playerUUID;
        Entity entity = event.getSource().m_7640_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_9236_().f_46443_) {
            return;
        }
        boolean hasRedstonePiece = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.CHARGED_REDSTONE_PIECE.get()).isPresent();
        if (hasRedstonePiece) {
            player.m_7292_(new MobEffectInstance((MobEffect)TerramityModMobEffects.AMPED.get(), 60, 0, false, false, true));
        }
        if (playerCooldowns.getOrDefault(playerUUID = player.m_20148_(), 0) > 0) {
            return;
        }
        ItemStack equippedSOS = CommonForgeEvents.getEquippedCharm(player);
        if (equippedSOS.m_41619_()) {
            return;
        }
        LivingEntity target = event.getEntity();
        Level level = player.m_9236_();
        boolean isUltra = equippedSOS.m_150930_((Item)ModItems.ULTRA_SOS.get());
        int cooldownTicks = isUltra ? 6 : 8;
        Vec3 backwardDirection = player.m_20182_().m_82546_(target.m_20182_()).m_82541_();
        Vec3 spawnPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.6, 0.0).m_82549_(backwardDirection.m_82490_(0.5));
        if (isUltra) {
            float damage = (float)player.m_21133_(Attributes.f_22281_) * 2.5f;
            int effectDuration = 100;
            UltraSOSBiteEntity bite = new UltraSOSBiteEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, damage, effectDuration);
            bite.m_5602_((Entity)player);
            bite.m_6686_(backwardDirection.f_82479_, backwardDirection.f_82480_, backwardDirection.f_82481_, 2.5f, 0.0f);
            level.m_7967_((Entity)bite);
            level.m_6263_(null, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, SoundEvents.f_11865_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            Arrow arrow = new Arrow(level, (LivingEntity)player);
            arrow.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
            arrow.m_5602_((Entity)player);
            Vec3 arrowDir = backwardDirection.m_82496_((float)(random.nextGaussian() * 0.1)).m_82524_((float)(random.nextGaussian() * 0.1));
            arrow.m_6686_(arrowDir.f_82479_, arrowDir.f_82480_, arrowDir.f_82481_, 1.8f, 1.0f);
            arrow.m_36781_((double)((float)player.m_21133_(Attributes.f_22281_)));
            arrow.m_6842_(true);
            level.m_7967_((Entity)arrow);
        }
        playerCooldowns.put(playerUUID, cooldownTicks);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side.isClient()) {
            return;
        }
        UUID uuid = event.player.m_20148_();
        if (playerCooldowns.containsKey(uuid)) {
            int cd = playerCooldowns.get(uuid);
            if (cd > 0) {
                playerCooldowns.put(uuid, cd - 1);
            } else {
                playerCooldowns.remove(uuid);
            }
        }
    }

    private static ItemStack getEquippedCharm(Player player) {
        return CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(handler -> {
            for (Map.Entry entry : handler.getCurios().entrySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.SOS.get()) && !stack.m_150930_((Item)ModItems.ULTRA_SOS.get())) continue;
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }
}

