/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.events;

import com.mojang.blaze3d.systems.RenderSystem;
import net.daphne.lethality.item.custom.RealKnifeItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lethality", value={Dist.CLIENT})
public class ClientOverlayHandler {
    private static final ResourceLocation CHARGE_BAR = new ResourceLocation("lethality", "textures/gui/genocide_charge_bar.png");

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof RealKnifeItem)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int genocideCount = tag.m_128451_("GenocideCount");
        boolean active = tag.m_128471_("GenocideActive");
        int maxBars = 11;
        int barIndex = Math.min(genocideCount, maxBars - 1);
        if (active) {
            barIndex = maxBars - 1;
        }
        int spriteWidth = 32;
        int spriteHeight = 99;
        int x = 10;
        int screenHeight = mc.m_91268_().m_85446_();
        int y = screenHeight / 2 - spriteHeight / 2;
        RenderSystem.enableBlend();
        event.getGuiGraphics().m_280163_(CHARGE_BAR, x, y, (float)(barIndex * spriteWidth), 0.0f, spriteWidth, spriteHeight, spriteWidth * maxBars, spriteHeight);
        RenderSystem.disableBlend();
    }
}

