/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.daphne.lethality.entity.BloodScytheEntity;
import net.daphne.lethality.entity.ModEntities;
import net.daphne.lethality.particles.ModParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class VehemenceBoltEntity
extends AbstractHurtingProjectile
implements GeoEntity {
    private static final EntityDataAccessor<Integer> ID_TARGET = SynchedEntityData.m_135353_(BloodScytheEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float projdamage;
    private final Set<UUID> messagedEntities = new HashSet<UUID>();
    private int iteration = 0;
    private boolean slowingDown = false;
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final double seekDistance = 60.0;
    private static final double seekThreshold = 0.4;

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public VehemenceBoltEntity(EntityType<? extends VehemenceBoltEntity> type, Level world) {
        super(type, world);
    }

    public VehemenceBoltEntity(Level world, double x, double y, double z, float Damage) {
        this((EntityType<? extends VehemenceBoltEntity>)((EntityType)ModEntities.VEHEMENCE_BOLT.get()), world);
        this.m_6034_(x, y, z);
        this.projdamage = Damage;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ID_TARGET, (Object)-1);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8119_() {
        double radius = 1.0;
        double particleNum = 30.0;
        double arcAngle = 200.0;
        double yaw = (double)this.m_146908_() + 90.0;
        double pitch = -1.0 * ((double)this.m_146909_() + 90.0);
        double radYaw = Math.toRadians(yaw);
        double radPitch = Math.toRadians(pitch);
        Level level = this.m_9236_();
        Entity owner = this.m_19749_();
        if (!level.m_5776_()) {
            for (int i = 0; i < (int)particleNum; ++i) {
                double angle = (double)i * (arcAngle / particleNum);
                double radAngle = Math.toRadians(angle);
                double vX = (Math.sin(radAngle) * Math.sin(radPitch) * Math.cos(radYaw) + Math.cos(radAngle) * Math.sin(radYaw)) * -1.0;
                double vY = Math.sin(radAngle) * Math.cos(radPitch);
                double vZ = Math.sin(radAngle) * Math.sin(radPitch) * Math.sin(radYaw) * -1.0 + Math.cos(radAngle) * Math.cos(radYaw);
                double x_pos = this.m_20185_() + radius * vX;
                double y_pos = this.m_20186_() + radius * vY;
                double z_pos = this.m_20189_() + radius * vZ;
                AABB box = new AABB(x_pos, y_pos, z_pos, x_pos, y_pos, z_pos).m_82400_(0.5);
                List hitEntities = level.m_6443_(LivingEntity.class, box, e -> e != this.m_19749_());
                for (LivingEntity target : hitEntities) {
                    UUID uuid = target.m_20148_();
                    if (this.messagedEntities.contains(uuid)) continue;
                    this.messagedEntities.add(uuid);
                    target.m_6469_(level.m_269111_().m_269104_((Entity)this, this.m_19749_()), this.projdamage);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.GAEL_SMOKE.get()), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 10, 0.3, 0.5, 0.3, 0.2);
                    }
                    this.m_146870_();
                }
            }
        }
        if (owner != null && !this.m_9236_().f_46443_) {
            this.updateTarget();
            Entity target = this.getTarget();
            if (target instanceof LivingEntity) {
                LivingEntity targetEntity = (LivingEntity)target;
                Vec3 toTarget = targetEntity.m_20182_().m_82520_(0.0, (double)targetEntity.m_20206_() / 2.0, 0.0).m_82546_(this.m_20182_());
                Vec3 currentMotion = this.m_20184_();
                double steerStrength = 0.2;
                Vec3 desiredMotion = toTarget.m_82541_().m_82490_(currentMotion.m_82553_());
                Vec3 newMotion = currentMotion.m_82490_(1.0 - steerStrength).m_82549_(desiredMotion.m_82490_(steerStrength));
                newMotion = newMotion.m_82541_().m_82490_(currentMotion.m_82553_());
                this.m_20256_(newMotion);
            }
        }
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.FORBIDDEN_GLINT.get(), this.m_20185_(), this.m_20186_() + 0.9, this.m_20189_(), (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1, (this.f_19796_.m_188500_() - 0.5) * 0.1);
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        ++this.iteration;
        if (!this.slowingDown && this.iteration >= 20) {
            this.slowingDown = true;
        }
        if (this.slowingDown) {
            Vec3 motion = this.m_20184_();
            Vec3 slowed = motion.m_82490_(0.8);
            this.m_20256_(slowed);
            if (slowed.m_82556_() < 0.3) {
                this.detonateEntity(this.m_9236_(), this.m_20185_() + 0.2, this.m_20186_() + 0.9, this.m_20189_(), 50.0, 0.35f, (ParticleOptions)ModParticles.GAEL_SMOKE.get());
            }
            if (slowed.m_82556_() < 0.15) {
                this.m_146870_();
            }
        }
    }

    public void detonateEntity(Level level, double x, double y, double z, double points, float sizeModifier, ParticleOptions particleType) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            level.m_7106_(particleType, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            ++i;
        }
    }

    private void updateTarget() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            this.setTarget(null);
            target = null;
        }
        if (target == null) {
            Vec3 motion = this.m_20184_().m_82541_();
            AABB searchArea = this.m_20191_().m_82369_(motion.m_82490_(60.0)).m_82377_(1.5, 30.0, 1.5);
            double closestDot = -1.0;
            LivingEntity bestTarget = null;
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, searchArea)) {
                if (!entity.m_6084_() || !entity.m_142582_((Entity)this) || entity == this.m_19749_()) continue;
                Entity entity2 = this.m_19749_();
                if (entity2 instanceof Player) {
                    TamableAnimal pet;
                    Player player = (Player)entity2;
                    if (entity instanceof TamableAnimal && (pet = (TamableAnimal)entity).m_269323_() == player) continue;
                }
                if (!this.m_5603_((Entity)entity)) continue;
                Vec3 toTarget = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() / 2.0, 0.0).m_82546_(this.m_20182_()).m_82541_();
                double dot = motion.m_82526_(toTarget);
                if (entity instanceof Monster) {
                    dot += 0.1;
                }
                if (!(dot > 0.4) || !(dot > closestDot)) continue;
                closestDot = dot;
                bestTarget = entity;
            }
            if (bestTarget != null) {
                this.setTarget((Entity)bestTarget);
            }
        }
    }

    @Nullable
    private Entity getTarget() {
        return this.m_9236_().m_6815_(((Integer)this.m_20088_().m_135370_(ID_TARGET)).intValue());
    }

    private void setTarget(@Nullable Entity entity) {
        this.m_20088_().m_135381_(ID_TARGET, (Object)(entity == null ? -1 : entity.m_19879_()));
    }

    public boolean m_6000_(double camX, double camY, double camZ) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

