/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.daphne.lethality.entity.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RealSlashEntity
extends AbstractHurtingProjectile
implements GeoEntity {
    private float projdamage;
    private final Set<UUID> messagedEntities = new HashSet<UUID>();
    private int iteration = 0;
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public RealSlashEntity(EntityType<? extends RealSlashEntity> type, Level world) {
        super(type, world);
    }

    public RealSlashEntity(Level world, double x, double y, double z, float Damage) {
        this((EntityType<? extends RealSlashEntity>)((EntityType)ModEntities.REAL_SLASH.get()), world);
        this.m_6034_(x, y, z);
        this.projdamage = Damage;
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
    }

    protected void m_8097_() {
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6060_() {
        return false;
    }

    public void m_8119_() {
        double radius = 1.0;
        double particleNum = 30.0;
        double arcAngle = 200.0;
        double yaw = (double)this.m_146908_() + 90.0;
        double pitch = -1.0 * ((double)this.m_146909_() + 90.0);
        double radYaw = Math.toRadians(yaw);
        double radPitch = Math.toRadians(pitch);
        Level level = this.m_9236_();
        if (!level.m_5776_()) {
            for (int i = 0; i < (int)particleNum; ++i) {
                double angle = (double)i * (arcAngle / particleNum);
                double radAngle = Math.toRadians(angle);
                double vX = (Math.sin(radAngle) * Math.sin(radPitch) * Math.cos(radYaw) + Math.cos(radAngle) * Math.sin(radYaw)) * -1.0;
                double vY = Math.sin(radAngle) * Math.cos(radPitch);
                double vZ = Math.sin(radAngle) * Math.sin(radPitch) * Math.sin(radYaw) * -1.0 + Math.cos(radAngle) * Math.cos(radYaw);
                double x_pos = this.m_20185_() + radius * vX;
                double y_pos = this.m_20186_() + radius * vY;
                double z_pos = this.m_20189_() + radius * vZ;
                AABB box = new AABB(x_pos, y_pos + 1.6, z_pos, x_pos, y_pos + 1.6, z_pos).m_82400_(0.5);
                List hitEntities = level.m_6443_(LivingEntity.class, box, e -> e != this.m_19749_());
                for (LivingEntity target : hitEntities) {
                    UUID uuid = target.m_20148_();
                    if (this.messagedEntities.contains(uuid)) continue;
                    this.messagedEntities.add(uuid);
                    target.m_6469_(level.m_269111_().m_269104_((Entity)this, this.m_19749_()), this.projdamage);
                }
            }
        }
        if (level.m_5776_() && this.iteration > 2) {
            Entity owner = this.m_19749_();
            UUID ownerUUID = owner != null ? owner.m_20148_() : null;
            for (int i = 0; i < (int)particleNum; ++i) {
                double angle = (double)i * (arcAngle / particleNum);
                double radAngle = Math.toRadians(angle);
                double vX = (Math.sin(radAngle) * Math.sin(radPitch) * Math.cos(radYaw) + Math.cos(radAngle) * Math.sin(radYaw)) * -1.0;
                double vY = Math.sin(radAngle) * Math.cos(radPitch);
                double vZ = Math.sin(radAngle) * Math.sin(radPitch) * Math.sin(radYaw) * -1.0 + Math.cos(radAngle) * Math.cos(radYaw);
                double x_pos = this.m_20185_() + radius * vX;
                double y_pos = this.m_20186_() + radius * vY;
                double z_pos = this.m_20189_() + radius * vZ;
                AABB box2 = new AABB(x_pos - 0.25, y_pos + 1.6 - 0.25, z_pos - 0.25, x_pos + 0.25, y_pos + 1.6 + 0.25, z_pos + 0.25);
                List hitEntities = level.m_6443_(LivingEntity.class, box2, e -> ownerUUID == null || !e.m_20148_().equals(ownerUUID));
                for (LivingEntity target : hitEntities) {
                    UUID uuid = target.m_20148_();
                    if (this.messagedEntities.contains(uuid)) continue;
                    this.messagedEntities.add(uuid);
                }
            }
        }
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        ++this.iteration;
        if (this.iteration >= 20) {
            this.m_146870_();
        }
    }

    public void detonateEntity(Level level, double x, double y, double z, double points, float sizeModifier, ParticleOptions particleType) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            level.m_7106_(particleType, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            ++i;
        }
    }

    public boolean m_6000_(double camX, double camY, double camZ) {
        return true;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

