/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.daphne.lethality.entity.ModEntities;
import net.daphne.lethality.item.ModItems;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PickleBallEntity
extends ThrowableItemProjectile
implements GeoEntity {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int bounceCount = 0;
    private float roll;
    private float pitch;
    private float yaw;
    private float prevRoll;
    private float prevPitch;
    private float prevYaw;
    private float projDamage;
    private final Set<UUID> hitEntities = new HashSet<UUID>();
    public static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.m_135353_(PickleBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public PickleBallEntity(EntityType<? extends PickleBallEntity> type, Level world) {
        super(type, world);
    }

    public PickleBallEntity(Level world, double x, double y, double z, float damage, ItemStack item) {
        this((EntityType<? extends PickleBallEntity>)((EntityType)ModEntities.PICKLE_BALL.get()), world);
        this.m_6034_(x, y, z);
        this.projDamage = damage;
        this.m_37446_(item);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_37446_(ItemStack stack) {
        this.f_19804_.m_135381_(ITEM_STACK, (Object)stack);
    }

    public ItemStack m_7846_() {
        return (ItemStack)this.f_19804_.m_135370_(ITEM_STACK);
    }

    protected Item m_7881_() {
        return (Item)ModItems.PICKLE_PADDLE.get();
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double speed = motion.m_82553_();
        if (speed > 0.01) {
            this.prevRoll = this.roll;
            this.prevPitch = this.pitch;
            this.prevYaw = this.yaw;
            this.roll += (float)(speed * 30.0);
            this.yaw = (float)Math.toDegrees(Math.atan2(motion.f_82481_, motion.f_82479_)) - 90.0f;
            this.pitch = (float)Math.toDegrees(Math.atan2(motion.f_82480_, Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_)));
        }
        if (!this.m_9236_().f_46443_) {
            this.checkEntityCollisions();
        }
    }

    private void checkEntityCollisions() {
        AABB bounds = this.m_20191_();
        List hit = this.m_9236_().m_6443_(LivingEntity.class, bounds, e -> e != this.m_19749_());
        for (LivingEntity entity : hit) {
            if (!this.hitEntities.add(entity.m_20148_())) continue;
            entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.projDamage + this.projDamage * (float)this.bounceCount);
            this.m_146870_();
            break;
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        if (this.bounceCount >= 3) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.1, 0.2, 0.05);
            }
            this.m_146870_();
            return;
        }
        Vec3 normal = Vec3.m_82528_((Vec3i)hitResult.m_82434_().m_122436_());
        Vec3 incoming = this.m_20184_();
        Vec3 reflected = incoming.m_82546_(normal.m_82490_(2.0 * incoming.m_82526_(normal)));
        this.m_20256_(reflected.m_82490_((double)this.getBounciness()));
        this.m_146884_(hitResult.m_82450_().m_82549_(reflected.m_82541_().m_82490_(0.05)));
        ++this.bounceCount;
        this.m_5496_(SoundEvents.f_12391_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.1, 0.2, 0.05);
        }
    }

    protected float getBounciness() {
        return 0.8f;
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity living;
        super.m_5790_(result);
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && this.hitEntities.add((living = (LivingEntity)entity).m_20148_())) {
            living.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.projDamage);
            living.f_19802_ = 0;
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123753_, living.m_20185_(), living.m_20186_() + 1.0, living.m_20189_(), 25, 0.3, 0.5, 0.3, 2.0);
            }
            this.m_146870_();
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, state -> PlayState.CONTINUE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public boolean m_6000_(double camX, double camY, double camZ) {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

