/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.entity;

import net.daphne.lethality.entity.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HookEntity
extends AbstractHurtingProjectile
implements GeoAnimatable {
    private static final EntityDataAccessor<Byte> HOOK_FLAGS = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int lifeTicks = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float projdamage;

    public Vec3 getLerpedPos(float partialTicks) {
        return new Vec3(Mth.m_14139_((double)partialTicks, (double)this.f_19790_, (double)this.m_20185_()), Mth.m_14139_((double)partialTicks, (double)this.f_19791_, (double)this.m_20186_()), Mth.m_14139_((double)partialTicks, (double)this.f_19792_, (double)this.m_20189_()));
    }

    public HookEntity(EntityType<? extends HookEntity> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public HookEntity(Level level, LivingEntity owner, float Damage) {
        super((EntityType)ModEntities.HOOK.get(), owner.m_20185_(), owner.m_20188_(), owner.m_20189_(), 0.0, 0.0, 0.0, level);
        this.m_5602_((Entity)owner);
        this.m_20242_(true);
        this.projdamage = Damage;
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HOOK_FLAGS, (Object)0);
    }

    public void m_8119_() {
        Entity owner = this.m_19749_();
        if (!this.m_9236_().f_46443_) {
            super.m_8119_();
            ++this.lifeTicks;
            if (owner == null || !owner.m_6084_()) {
                this.m_146870_();
                return;
            }
            if (this.lifeTicks >= 30 && !this.hasDealtDamage()) {
                this.setDealtDamage(true);
                this.m_5496_(SoundEvents.f_12516_, 1.0f, 1.0f);
            }
            if (this.hasDealtDamage() || this.f_19794_) {
                this.f_19794_ = true;
                Vec3 vec = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20256_(vec.m_82541_().m_82490_(1.5));
                if (vec.m_82556_() < 1.0) {
                    this.m_146870_();
                }
            }
            if (this.m_20096_() && !this.hasDealtDamage()) {
                this.m_20256_(Vec3.f_82478_);
                this.setDealtDamage(true);
                if (this.hasReeling() && owner instanceof Player) {
                    Player player = (Player)owner;
                    Vec3 direction = this.m_20182_().m_82546_(player.m_146892_()).m_82541_();
                    double pullStrength = 1.0;
                    player.m_20256_(player.m_20184_().m_82490_(0.9).m_82549_(direction.m_82490_(pullStrength)));
                    player.f_19789_ = 0.0f;
                } else {
                    Level level = this.m_9236_();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.2, 0.2, 0.2, 0.0);
                    }
                    this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), e -> e.m_6084_() && e != owner).forEach(target -> {
                        float baseStrength = 1.0f * (float)(1.0 - target.m_21133_(Attributes.f_22278_));
                        float knockbackMultiplier = 0.4f;
                        float strength = baseStrength * knockbackMultiplier;
                        Vec3 distance = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_());
                        Vec3 direction = distance.m_82541_().m_82490_((double)strength);
                        direction = new Vec3(direction.f_82479_, direction.f_82480_ * 0.5, direction.f_82481_);
                        target.m_5997_(direction.f_82479_, direction.f_82480_, direction.f_82481_);
                        target.f_19864_ = true;
                        target.f_19789_ = 0.0f;
                    });
                }
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity owner;
        Entity entity = result.m_82443_();
        if (entity == (owner = this.m_19749_())) {
            return;
        }
        if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
            DamageSource source;
            LivingEntity target;
            LivingEntity livingOwner = (LivingEntity)owner;
            float damage = this.projdamage;
            if (entity instanceof LivingEntity && (target = (LivingEntity)entity).m_6469_(source = this.m_9236_().m_269111_().m_269333_(livingOwner), damage)) {
                float strength = (float)(1.0 - target.m_21133_(Attributes.f_22278_));
                Vec3 dir = livingOwner.m_20182_().m_82546_(target.m_20182_()).m_82490_((double)(strength / 4.0f));
                target.m_5997_(dir.f_82479_, dir.f_82480_, dir.f_82481_);
                target.f_19864_ = true;
                this.setDealtDamage(true);
                this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
            }
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (result.m_6662_() == HitResult.Type.BLOCK && !this.hasDealtDamage()) {
            this.m_20256_(Vec3.f_82478_);
            this.setDealtDamage(true);
            this.m_5496_(SoundEvents.f_12515_, 1.0f, 1.0f);
        }
    }

    private boolean getFlag(int bit) {
        return ((Byte)this.f_19804_.m_135370_(HOOK_FLAGS) & 1 << bit) != 0;
    }

    private void setFlag(int bit, boolean value) {
        byte flags = (Byte)this.f_19804_.m_135370_(HOOK_FLAGS);
        flags = value ? (byte)(flags | 1 << bit) : (byte)(flags & ~(1 << bit));
        this.f_19804_.m_135381_(HOOK_FLAGS, (Object)flags);
    }

    public boolean hasDealtDamage() {
        return this.getFlag(0);
    }

    public void setDealtDamage(boolean b) {
        this.setFlag(0, b);
    }

    public boolean hasReeling() {
        return this.getFlag(1);
    }

    public void setReeling(boolean b) {
        this.setFlag(1, b);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    protected ItemStack getPickupItem() {
        return ItemStack.f_41583_;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }
}

