/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.List;
import net.daphne.lethality.client.RadialModeHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lethality", value={Dist.CLIENT})
public class RadialOverlayRenderer {
    private static final ResourceLocation CURSOR_TEX = new ResourceLocation("lethality", "textures/gui/cursor_icon.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("lethality", "textures/gui/biome_menu.png");
    public static final List<ModeEntry> MODES = List.of(new ModeEntry("Grovetender's Touch", new ResourceLocation("lethality", "textures/gui/poison.png"), 0.0, new Color(0x4CCF4C)), new ModeEntry("Biting Embrace", new ResourceLocation("lethality", "textures/gui/ice.png"), 1.5707963267948966, new Color(5949690)), new ModeEntry("Arid Grandeur", new ResourceLocation("lethality", "textures/gui/fire.png"), Math.PI, new Color(16747586)), new ModeEntry("Decay's Retort", new ResourceLocation("lethality", "textures/gui/bleed.png"), 4.71238898038469, new Color(0xD33636)));
    private static double lastAngle = 0.0;
    private static final float[] iconScales = new float[MODES.size()];
    private static int lastSelectedIndex = -1;
    private static float cursorR = 1.0f;
    private static float cursorG = 1.0f;
    private static float cursorB = 1.0f;

    public static List<ModeEntry> getModes() {
        return MODES;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiOverlayEvent.Post event) {
        float targetR;
        float targetG;
        float targetB;
        double normalizedProximity;
        double angleDiff;
        double closestAngle;
        if (!RadialModeHandler.isOpen || RadialModeHandler.currentStack.m_41619_()) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        int centerX = width / 2;
        int centerY = height / 2;
        double mouseX = mc.f_91067_.m_91589_() * ((double)width / (double)mc.m_91268_().m_85443_());
        double mouseY = mc.f_91067_.m_91594_() * ((double)height / (double)mc.m_91268_().m_85444_());
        guiGraphics.m_280163_(TEXTURE, centerX - 64, centerY - 64, 0.0f, 0.0f, 128, 128, 128, 128);
        double dx = mouseX - (double)centerX;
        double dy = mouseY - (double)centerY;
        double targetAngle = Math.atan2(dy, dx);
        targetAngle = (targetAngle + Math.PI * 2) % (Math.PI * 2);
        double distance = Math.sqrt(dx * dx + dy * dy);
        double deadZoneRadius = 15.0;
        double smoothing = 0.2;
        lastAngle = RadialOverlayRenderer.interpolateAngle(lastAngle, targetAngle, 0.2);
        int newIndex = RadialOverlayRenderer.getClosestModeIndex(lastAngle);
        if (distance > deadZoneRadius) {
            if (lastSelectedIndex == -1) {
                lastSelectedIndex = newIndex;
            } else if (lastSelectedIndex != newIndex) {
                double currentAngle = MODES.get(lastSelectedIndex).angle();
                double newAngle = MODES.get(newIndex).angle();
                double diff = RadialOverlayRenderer.angleDifference(newAngle, currentAngle);
                if (diff > Math.toRadians(10.0)) {
                    lastSelectedIndex = newIndex;
                }
            }
            RadialModeHandler.selectedIndex = lastSelectedIndex;
            closestAngle = MODES.get(newIndex).angle();
            angleDiff = RadialOverlayRenderer.angleDifference(lastAngle, closestAngle);
            normalizedProximity = 1.0 - Math.min(angleDiff / Math.PI, 1.0);
            float hue = (float)(0.0 + 0.4 * normalizedProximity);
            float saturation = 1.0f;
            float brightness = 1.0f;
            int rgb = Color.HSBtoRGB(hue, saturation, brightness);
            float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgb & 0xFF) / 255.0f;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
        } else {
            lastSelectedIndex = -1;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
        }
        closestAngle = MODES.get(newIndex).angle();
        angleDiff = RadialOverlayRenderer.angleDifference(lastAngle, closestAngle);
        normalizedProximity = 1.0 - Math.min(angleDiff / Math.PI, 1.0);
        float deadZoneColor = 0.4f;
        float colorSmoothing = 0.1f;
        if (distance <= deadZoneRadius + 5.0) {
            targetG = targetB = deadZoneColor;
            targetR = targetB;
        } else {
            ModeEntry mode = MODES.get(newIndex);
            Color baseColor = mode.color();
            float proximity = (float)normalizedProximity;
            float baseR = (float)baseColor.getRed() / 255.0f;
            float baseG = (float)baseColor.getGreen() / 255.0f;
            float baseB = (float)baseColor.getBlue() / 255.0f;
            float gray = 0.4f;
            targetR = baseR * proximity + gray * (1.0f - proximity);
            targetG = baseG * proximity + gray * (1.0f - proximity);
            targetB = baseB * proximity + gray * (1.0f - proximity);
        }
        cursorR += (targetR - cursorR) * colorSmoothing;
        cursorG += (targetG - cursorG) * colorSmoothing;
        cursorB += (targetB - cursorB) * colorSmoothing;
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)cursorR, (float)cursorG, (float)cursorB, (float)1.0f);
        guiGraphics.m_280163_(CURSOR_TEX, (int)mouseX - 10, (int)mouseY - 10, 0.0f, 0.0f, 20, 20, 20, 20);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        for (int i = 0; i < MODES.size(); ++i) {
            boolean selected;
            ModeEntry mode = MODES.get(i);
            double a = (double)i * (Math.PI * 2 / (double)MODES.size());
            int radius = 60;
            int x = (int)((double)centerX + Math.cos(a) * (double)radius);
            int y = (int)((double)centerY + Math.sin(a) * (double)radius);
            float targetScale = i == lastSelectedIndex ? 1.75f : 1.0f;
            float scaleSmoothing = 0.005f;
            int n = i;
            iconScales[n] = iconScales[n] + (targetScale - iconScales[i]) * scaleSmoothing;
            int baseSize = 32;
            int size = (int)((float)baseSize * iconScales[i]);
            int halfSize = size / 2;
            boolean bl = selected = i == lastSelectedIndex;
            if (!selected) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)0.35f, (float)0.35f, (float)0.35f, (float)0.6f);
            }
            guiGraphics.m_280163_(mode.icon, x - halfSize, y - halfSize, 0.0f, 0.0f, size, size, size, size);
            if (selected) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
        if (distance > deadZoneRadius && lastSelectedIndex >= 0 && lastSelectedIndex < MODES.size()) {
            String selectedName = RadialOverlayRenderer.MODES.get((int)RadialOverlayRenderer.lastSelectedIndex).name;
            guiGraphics.m_280137_(mc.f_91062_, selectedName, centerX, centerY + 24, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static int getClosestModeIndex(double angle) {
        int closestIndex = -1;
        double smallestDiff = Double.MAX_VALUE;
        for (int i = 0; i < MODES.size(); ++i) {
            double modeAngle = MODES.get(i).angle();
            double diff = RadialOverlayRenderer.angleDifference(angle, modeAngle);
            if (!(diff < smallestDiff)) continue;
            smallestDiff = diff;
            closestIndex = i;
        }
        return closestIndex;
    }

    private static double angleDifference(double a, double b) {
        double diff = Math.abs(a - b) % (Math.PI * 2);
        return diff > Math.PI ? Math.PI * 2 - diff : diff;
    }

    private static double interpolateAngle(double current, double target, double factor) {
        double diff = (target - current + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return current + diff * factor;
    }

    static {
        for (int i = 0; i < iconScales.length; ++i) {
            RadialOverlayRenderer.iconScales[i] = 1.0f;
        }
    }

    public record ModeEntry(String name, ResourceLocation icon, double angle, Color color) {
    }
}

