/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.client;

import net.daphne.lethality.client.RadialModeHandler;
import net.daphne.lethality.networking.ModMessages;
import net.daphne.lethality.networking.SelectModePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lethality", value={Dist.CLIENT})
public class RadialInputHandler {
    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton event) {
        if (RadialModeHandler.isOpen) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelScrolling(InputEvent.MouseScrollingEvent event) {
        if (RadialModeHandler.isOpen) {
            event.setCanceled(true);
        }
    }

    private static int getSelectedMode(Minecraft mc, double mouseX, double mouseY) {
        int selectedMode;
        int centerY;
        double dy;
        int centerX = mc.m_91268_().m_85445_() / 2;
        double dx = mouseX - (double)centerX;
        double distance = Math.sqrt(dx * dx + (dy = mouseY - (double)(centerY = mc.m_91268_().m_85446_() / 2)) * dy);
        if (distance <= 16.0) {
            selectedMode = 0;
        } else {
            double adjusted;
            double angle = Math.atan2(dy, dx);
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            if ((adjusted = angle - 1.5707963267948966 + 0.7853981633974483) < 0.0) {
                adjusted += Math.PI * 2;
            }
            int sector = (int)(adjusted / 1.5707963267948966);
            selectedMode = sector + 1;
        }
        return selectedMode;
    }

    @SubscribeEvent
    public static void onMouseReleased(InputEvent.MouseButton event) {
        if (RadialModeHandler.isOpen && event.getButton() == 1 && event.getAction() == 0) {
            ItemStack stack;
            Minecraft mc = Minecraft.m_91087_();
            double mouseX = mc.f_91067_.m_91589_() * (double)mc.m_91268_().m_85445_() / (double)mc.m_91268_().m_85443_();
            double mouseY = mc.f_91067_.m_91594_() * (double)mc.m_91268_().m_85446_() / (double)mc.m_91268_().m_85444_();
            int selectedMode = RadialInputHandler.getSelectedMode(mc, mouseX, mouseY);
            if (mc.f_91074_ != null && !(stack = mc.f_91074_.m_21205_()).m_41619_()) {
                ModMessages.sendToServer(new SelectModePacket(selectedMode));
            }
            RadialModeHandler.close();
        }
    }
}

