/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.client;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.item.custom.NightfallItem;
import net.daphne.lethality.particles.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="lethality")
public class ModEffectEvents {
    private static final List<DelayedDamage> damageQueue = new CopyOnWriteArrayList<DelayedDamage>();

    @SubscribeEvent
    public static void onPlayerDealsDamage(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.m_21023_((MobEffect)ModMobEffects.BRIMSTONE_FLAMES_BUFF.get())) {
            return;
        }
        float originalDamage = event.getAmount();
        float amplifiedDamage = originalDamage * 2.0f;
        event.setAmount(amplifiedDamage);
        float lifeSteal = amplifiedDamage * 0.2f;
        player.m_5634_(lifeSteal);
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175823_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 10, 0.2, 0.5, 0.2, 0.1);
            serverLevel.m_5594_(null, player.m_20183_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 0.6f, 1.2f);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)ModMobEffects.CRUMBLING.get())) {
            float damage = event.getAmount();
            float newDamage = entity instanceof Player ? damage / 0.7f : damage / 0.92f;
            event.setAmount(newDamage);
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        if (event == null || event.getEntity() == null) {
            return;
        }
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        BlockPos pos = target.m_20183_();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        MobEffectInstance effect = livingAttacker.m_21124_((MobEffect)ModMobEffects.RAGE.get());
        if (effect == null) {
            return;
        }
        float originalDamage = event.getAmount();
        float multiplier = 2.0f;
        event.setAmount(originalDamage * multiplier);
        target.f_19802_ = 0;
        Level level = target.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_5594_(null, pos, SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticles.REAL_CRIT.get()), target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_(), 20, 0.3, 0.5, 0.3, 0.2);
        } else {
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<DelayedDamage> toRemove = new ArrayList<DelayedDamage>();
        for (DelayedDamage delayed : damageQueue) {
            --delayed.ticks;
            if (delayed.ticks > 0) continue;
            if (delayed.target.m_6084_()) {
                delayed.target.f_19802_ = 0;
                delayed.target.m_6469_(delayed.target.m_269291_().m_269104_((Entity)delayed.attacker, (Entity)delayed.attacker), delayed.amount);
            }
            toRemove.add(delayed);
        }
        damageQueue.removeAll(toRemove);
    }

    @SubscribeEvent
    public static void onMobTargetChange(LivingChangeTargetEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        LivingEntity newTarget = event.getNewTarget();
        if (!(newTarget instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = newTarget;
        if (target.m_21023_((MobEffect)ModMobEffects.TRANQUILITY.get())) {
            event.setNewTarget(null);
            mob.m_6710_(null);
            mob.m_21573_().m_26573_();
            mob.m_6274_().m_21936_(MemoryModuleType.f_26372_);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().f_46443_ || event.phase != TickEvent.Phase.END) {
            return;
        }
        ItemStack mainhand = player.m_21205_();
        boolean hasIronWill = player.m_21023_((MobEffect)ModMobEffects.IRON_WILL.get());
        CompoundTag data = player.getPersistentData();
        boolean hadNightfall = data.m_128471_("HadNightfallEquipped");
        boolean currentlyHasNightfall = mainhand.m_41720_() instanceof NightfallItem;
        if (hasIronWill && hadNightfall && !currentlyHasNightfall) {
            float absorption = player.m_6103_();
            float heal = absorption * 0.6f;
            player.m_5634_(heal);
            player.m_7911_(0.0f);
            player.m_21195_((MobEffect)ModMobEffects.IRON_WILL.get());
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("lethality", "nightfall_shield_recast"));
            float pitch = Mth.m_216267_((RandomSource)player.m_217043_(), (float)0.8f, (float)1.2f);
            float volume = 1.0f;
            player.m_9236_().m_5594_(null, player.m_20183_(), sound, SoundSource.PLAYERS, volume, pitch);
            Item item = player.m_21206_().m_41720_();
            if (item instanceof NightfallItem) {
                NightfallItem nightfall = (NightfallItem)item;
                NightfallItem.resetShield(player.m_21206_());
            }
        }
        data.m_128379_("HadNightfallEquipped", currentlyHasNightfall);
    }

    private static class DelayedDamage {
        public final LivingEntity target;
        public final LivingEntity attacker;
        public final float amount;
        public int ticks;

        public DelayedDamage(LivingEntity target, LivingEntity attacker, float amount, int ticks) {
            this.target = target;
            this.attacker = attacker;
            this.amount = amount;
            this.ticks = ticks;
        }
    }
}

