/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality.client;

import java.util.List;
import java.util.UUID;
import net.daphne.lethality.init.ModMobEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lethality")
public class BladeModeEvents {
    private static final UUID BLADE_MODE_SPEED_ID = UUID.fromString("d3e76a14-5b9e-4b41-a421-d0a7a9c979a8");
    private static final UUID BLADE_MODE_ATTACK_SPEED_ID = UUID.fromString("3e4a8e2f-6e6a-4a9f-91fc-b4bb51d7c1e2");
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(BLADE_MODE_SPEED_ID, "Blade Mode Speed", 0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier ATTACK_SPEED_MODIFIER = new AttributeModifier(BLADE_MODE_ATTACK_SPEED_ID, "Blade Mode Attack Speed", 0.75, AttributeModifier.Operation.MULTIPLY_TOTAL);

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        boolean hasBladeMode = player.m_21023_((MobEffect)ModMobEffects.BLADE_MODE.get());
        if (hasBladeMode) {
            AABB area = player.m_20191_().m_82400_(5.0);
            List targets = player.m_9236_().m_6443_(LivingEntity.class, area, e -> e != player && e.m_6084_() && e instanceof Mob);
            for (LivingEntity target : targets) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 2, false, false));
            }
            if (!player.m_21051_(Attributes.f_22279_).m_22109_(SPEED_MODIFIER)) {
                player.m_21051_(Attributes.f_22279_).m_22118_(SPEED_MODIFIER);
            }
            if (!player.m_21051_(Attributes.f_22283_).m_22109_(ATTACK_SPEED_MODIFIER)) {
                player.m_21051_(Attributes.f_22283_).m_22118_(ATTACK_SPEED_MODIFIER);
            }
        } else {
            player.m_21051_(Attributes.f_22279_).m_22120_(BLADE_MODE_SPEED_ID);
            player.m_21051_(Attributes.f_22283_).m_22120_(BLADE_MODE_ATTACK_SPEED_ID);
        }
    }
}

