/*
 * Decompiled with CFR 0.152.
 */
package net.daphne.lethality;

import com.mojang.logging.LogUtils;
import net.daphne.lethality.block.ModBlocks;
import net.daphne.lethality.entity.ModEntities;
import net.daphne.lethality.init.ModMobEffects;
import net.daphne.lethality.init.ModSounds;
import net.daphne.lethality.item.ModCreativeModTabs;
import net.daphne.lethality.item.ModItems;
import net.daphne.lethality.networking.ModMessages;
import net.daphne.lethality.networking.packets.C2S.BattleMaidAbilityPacket;
import net.daphne.lethality.particles.AcidicBubble;
import net.daphne.lethality.particles.AcidicBubbleFork;
import net.daphne.lethality.particles.AcidicImpact;
import net.daphne.lethality.particles.Crumbling;
import net.daphne.lethality.particles.CustomParticle;
import net.daphne.lethality.particles.CuteSparkles;
import net.daphne.lethality.particles.GaelSmoke;
import net.daphne.lethality.particles.HexFlame;
import net.daphne.lethality.particles.ModParticles;
import net.daphne.lethality.particles.Tranquility;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="lethality")
public class LethalityMod {
    public static final String MOD_ID = "lethality";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("lethality", "main"), () -> "1.0", s -> true, s -> true);

    public LethalityMod() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModCreativeModTabs.register(modEventBus);
        ModMessages.register();
        ModEntities.register(modEventBus);
        ModParticles.register(modEventBus);
        ModSounds.register(modEventBus);
        ModMobEffects.MOB_EFFECTS.register(modEventBus);
        ModBlocks.register();
        ModBlocks.registerBlockItems();
        ModItems.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256968_) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @Mod.EventBusSubscriber(modid="lethality", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        private static final String PROTOCOL_VERSION = "1";

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            NETWORK_CHANNEL.registerMessage(0, BattleMaidAbilityPacket.class, BattleMaidAbilityPacket::encode, BattleMaidAbilityPacket::decode, BattleMaidAbilityPacket::handle);
        }

        @SubscribeEvent
        public static void registerParticles(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ModParticles.CUSTOM_PARTICLE.get(), CustomParticle.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.ACIDIC_BUBBLE.get(), AcidicBubble.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.ACIDIC_BUBBLE_FORK.get(), AcidicBubbleFork.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.ACIDIC_IMPACT.get(), AcidicImpact.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.REAL_CRIT.get(), AcidicImpact.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.FORBIDDEN_GLINT.get(), AcidicImpact.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.HEX_FLAME.get(), HexFlame.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.GAEL_SMOKE.get(), GaelSmoke.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.TRANQUILITY.get(), Tranquility.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.CRUMBLING.get(), Crumbling.Provider::new);
            event.registerSpriteSet((ParticleType)ModParticles.CUTE_SPARKLES.get(), CuteSparkles.Provider::new);
        }
    }
}

