/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.craftingrecipeexporter;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.leclowndu93150.craftingrecipeexporter.CraftingJsonMenu;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class CraftingJsonScreen
extends AbstractContainerScreen<CraftingJsonMenu> {
    private static final ResourceLocation CRAFTING_TABLE_LOCATION = new ResourceLocation("textures/gui/container/crafting_table.png");
    private Button exportJsonButton;
    private Button exportKubeJSButton;
    private Checkbox shapelessCheckbox;
    private Checkbox fixedPositionCheckbox;
    private Checkbox useTagsCheckbox;
    private EditBox[] tagInputs;
    private boolean isShapeless = false;
    private boolean isFixed = false;
    private boolean useTags = false;
    private static final int TAG_INPUT_X_OFFSET = 12;
    private static final int TAG_INPUT_Y_OFFSET = 80;
    private static final int TAG_INPUT_HORIZONTAL_SPACING = 50;
    private static final int TAG_INPUT_VERTICAL_SPACING = 20;
    private static final int TAG_INPUT_SIZE = 48;

    public CraftingJsonScreen(CraftingJsonMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_96541_ = Minecraft.m_91087_();
        this.f_97726_ = 176;
        this.f_97727_ = 166;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 40;
        int spacing = 4;
        int startX = this.f_97735_ + 85;
        this.shapelessCheckbox = new Checkbox(startX - 170, this.f_97736_ + 30, 50, 20, (Component)Component.m_237113_((String)"Shapeless"), this.isShapeless){

            public void m_5691_() {
                super.m_5691_();
                CraftingJsonScreen.this.isShapeless = this.m_93840_();
            }
        };
        this.fixedPositionCheckbox = new Checkbox(startX + 55, this.f_97736_ + 35, 50, 20, (Component)Component.m_237113_((String)"Fixed"), this.isFixed){

            public void m_5691_() {
                super.m_5691_();
                CraftingJsonScreen.this.isFixed = this.m_93840_();
            }
        };
        this.useTagsCheckbox = new Checkbox(startX - 170, this.f_97736_ + 60, 50, 20, (Component)Component.m_237113_((String)"Use Tags"), this.useTags){

            public void m_5691_() {
                super.m_5691_();
                CraftingJsonScreen.this.useTags = this.m_93840_();
                CraftingJsonScreen.this.updateTagInputVisibility();
            }
        };
        this.tagInputs = new EditBox[9];
        for (int i = 0; i < 9; ++i) {
            int index = i;
            this.tagInputs[i] = new EditBox(this.f_96547_, this.f_97735_ + 8 + i % 3 * 18, this.f_97736_ + 17 + i / 3 * 18, 16, 16, (Component)Component.m_237119_());
            this.tagInputs[i].m_94194_(false);
        }
        this.fixedPositionCheckbox.f_93623_ = false;
        this.fixedPositionCheckbox.f_93624_ = false;
        this.exportJsonButton = Button.m_253074_((Component)Component.m_237113_((String)"JSON"), button -> {
            if (!this.isRecipeValid()) {
                return;
            }
            if (Screen.m_96637_()) {
                String json = this.isShapeless ? this.generateShapelessJson() : this.generateJson();
                Minecraft.m_91087_().f_91068_.m_90911_(json);
            } else if (this.isShapeless) {
                this.exportShapelessRecipe();
            } else {
                this.exportRecipe();
            }
        }).m_252794_(startX, this.f_97736_ + 58).m_253046_(buttonWidth, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"Left click to export to crafting_recipes folder.\nHold Ctrl + click to copy to clipboard"))).m_253136_();
        this.exportKubeJSButton = Button.m_253074_((Component)Component.m_237113_((String)"KubeJS"), button -> {
            if (!this.isRecipeValid()) {
                return;
            }
            if (Screen.m_96637_()) {
                String kubeJs = this.isShapeless ? this.generateShapelessKubeJS() : this.generateKubeJS();
                Minecraft.m_91087_().f_91068_.m_90911_(kubeJs);
            } else if (this.isShapeless) {
                this.exportShapelessKubeJSRecipe();
            } else {
                this.exportKubeJSRecipe();
            }
        }).m_252794_(startX + buttonWidth + spacing, this.f_97736_ + 58).m_253046_(buttonWidth, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"Left click to export to kubejs/server_scripts\nHold Ctrl + click to copy to clipboard"))).m_253136_();
        this.m_142416_((GuiEventListener)this.shapelessCheckbox);
        this.m_142416_((GuiEventListener)this.fixedPositionCheckbox);
        this.m_142416_((GuiEventListener)this.useTagsCheckbox);
        for (EditBox tagInput : this.tagInputs) {
            this.m_142416_((GuiEventListener)tagInput);
        }
        this.m_142416_((GuiEventListener)this.exportJsonButton);
        this.m_142416_((GuiEventListener)this.exportKubeJSButton);
        this.f_97728_ = 28;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        this.m_280072_(graphics, mouseX, mouseY);
        this.updateTagInputVisibility();
    }

    private void updateTagInputVisibility() {
        for (int i = 0; i < 9; ++i) {
            int x = this.f_97735_ + 12 + i % 3 * 50;
            int y = this.f_97736_ + 80 + i / 3 * 20;
            this.tagInputs[i].m_252865_(x);
            this.tagInputs[i].m_253211_(y);
            this.tagInputs[i].m_93674_(48);
            this.tagInputs[i].m_94194_(this.useTags && !((CraftingJsonMenu)this.f_97732_).m_38853_(i + 1).m_7993_().m_41619_());
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        int x = this.f_97735_;
        int y = this.f_97736_;
        graphics.m_280218_(CRAFTING_TABLE_LOCATION, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    private void updateCheckboxStates() {
        this.isShapeless = this.shapelessCheckbox.m_93840_();
        this.isFixed = this.fixedPositionCheckbox.m_93840_();
        this.useTags = this.useTagsCheckbox.m_93840_();
    }

    private JsonObject serializeItemOrTag(ItemStack stack, int slot) {
        JsonObject item = new JsonObject();
        if (this.useTags && !this.tagInputs[slot].m_94155_().isEmpty()) {
            item.addProperty("tag", this.tagInputs[slot].m_94155_());
        } else {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
            if (itemId != null) {
                item.addProperty("item", itemId.toString());
            }
        }
        if (stack.m_41613_() > 1) {
            item.addProperty("count", (Number)stack.m_41613_());
        }
        return item;
    }

    private JsonObject serializeResult(ItemStack stack) {
        JsonObject result = new JsonObject();
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId != null) {
            result.addProperty("item", itemId.toString());
            result.addProperty("count", (Number)stack.m_41613_());
        }
        return result;
    }

    private void exportShapelessRecipe() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack output = ((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_();
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = ((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_();
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        JsonArray ingredients = new JsonArray();
        for (ItemStack input : inputs) {
            ingredients.add((JsonElement)this.serializeItem(input));
        }
        json.add("ingredients", (JsonElement)ingredients);
        json.add("result", (JsonElement)this.serializeResult(output));
        String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
        try {
            Path modsDir = FMLPaths.GAMEDIR.get().resolve("crafting_recipes");
            Files.createDirectories(modsDir, new FileAttribute[0]);
            Path recipePath = modsDir.resolve("shapeless_recipe_" + System.currentTimeMillis() + ".json");
            Files.writeString(recipePath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportShapelessKubeJSRecipe() {
        try {
            Path scriptsDir = FMLPaths.GAMEDIR.get().resolve("kubejs/server_scripts");
            Files.createDirectories(scriptsDir, new FileAttribute[0]);
            Path recipePath = scriptsDir.resolve("exported_recipes.js");
            String newRecipe = this.generateShapelessKubeJS();
            String existingContent = "";
            if (Files.exists(recipePath, new LinkOption[0])) {
                existingContent = Files.readString(recipePath);
            }
            if (!existingContent.contains("ServerEvents.recipes")) {
                existingContent = "ServerEvents.recipes(event => {\n\n});\n";
            }
            if (!existingContent.contains(newRecipe.trim())) {
                String updatedContent = existingContent.replace("});", newRecipe + "\n});");
                Files.writeString(recipePath, (CharSequence)updatedContent, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportRecipe() {
        this.updateCheckboxStates();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack output = ((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_();
        for (int i = 1; i < 10; ++i) {
            inputs.add(((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_());
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray pattern = new JsonArray();
        JsonObject key = new JsonObject();
        char currentKey = 'A';
        for (int row = 0; row < 3; ++row) {
            StringBuilder patternRow = new StringBuilder();
            for (int col = 0; col < 3; ++col) {
                ItemStack stack = (ItemStack)inputs.get(row * 3 + col);
                if (!stack.m_41619_()) {
                    ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    if (itemId == null) continue;
                    key.add(String.valueOf(currentKey), (JsonElement)this.serializeItem(stack));
                    char c = currentKey;
                    currentKey = (char)(currentKey + '\u0001');
                    patternRow.append(c);
                    continue;
                }
                patternRow.append(" ");
            }
            pattern.add(patternRow.toString());
        }
        json.add("pattern", (JsonElement)pattern);
        json.add("key", (JsonElement)key);
        json.add("result", (JsonElement)this.serializeResult(output));
        if (this.isFixed) {
            JsonObject conditions = new JsonObject();
            conditions.addProperty("fixed", Boolean.valueOf(true));
            json.add("conditions", (JsonElement)conditions);
        }
        String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
        try {
            Path modsDir = FMLPaths.GAMEDIR.get().resolve("crafting_recipes");
            Files.createDirectories(modsDir, new FileAttribute[0]);
            Path recipePath = modsDir.resolve("recipe_" + System.currentTimeMillis() + ".json");
            Files.writeString(recipePath, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportKubeJSRecipe() {
        try {
            Path scriptsDir = FMLPaths.GAMEDIR.get().resolve("kubejs/server_scripts");
            Files.createDirectories(scriptsDir, new FileAttribute[0]);
            Path recipePath = scriptsDir.resolve("exported_recipes.js");
            String newRecipe = this.generateKubeJS();
            String existingContent = "";
            if (Files.exists(recipePath, new LinkOption[0])) {
                existingContent = Files.readString(recipePath);
            }
            if (!existingContent.contains("ServerEvents.recipes")) {
                existingContent = "ServerEvents.recipes(event => {\n\n});\n";
            }
            if (!existingContent.contains(newRecipe.trim())) {
                String updatedContent = existingContent.replace("});", newRecipe + "\n});");
                Files.writeString(recipePath, (CharSequence)updatedContent, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JsonObject serializeItem(ItemStack stack) {
        JsonObject item = new JsonObject();
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId != null) {
            item.addProperty("item", itemId.toString());
            if (stack.m_41613_() > 1) {
                item.addProperty("count", (Number)stack.m_41613_());
            }
        }
        return item;
    }

    private boolean isRecipeValid() {
        boolean hasItems = false;
        boolean hasResult = !((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_().m_41619_();
        for (int i = 1; i < 10; ++i) {
            if (((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_().m_41619_()) continue;
            hasItems = true;
            break;
        }
        return hasItems && hasResult;
    }

    private String generateJson() {
        this.updateCheckboxStates();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack output = ((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_();
        for (int i = 1; i < 10; ++i) {
            inputs.add(((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_());
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        JsonArray pattern = new JsonArray();
        JsonObject key = new JsonObject();
        char currentKey = 'A';
        for (int row = 0; row < 3; ++row) {
            StringBuilder patternRow = new StringBuilder();
            for (int col = 0; col < 3; ++col) {
                ItemStack stack = (ItemStack)inputs.get(row * 3 + col);
                if (!stack.m_41619_()) {
                    ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    if (itemId == null) continue;
                    key.add(String.valueOf(currentKey), (JsonElement)this.serializeItemOrTag(stack, row * 3 + col));
                    char c = currentKey;
                    currentKey = (char)(currentKey + '\u0001');
                    patternRow.append(c);
                    continue;
                }
                patternRow.append(" ");
            }
            pattern.add(patternRow.toString());
        }
        json.add("pattern", (JsonElement)pattern);
        json.add("key", (JsonElement)key);
        json.add("result", (JsonElement)this.serializeResult(output));
        if (this.isFixed) {
            JsonObject conditions = new JsonObject();
            conditions.addProperty("fixed", Boolean.valueOf(true));
            json.add("conditions", (JsonElement)conditions);
        }
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
    }

    private String generateShapelessJson() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack output = ((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_();
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = ((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_();
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shapeless");
        JsonArray ingredients = new JsonArray();
        for (int i = 0; i < inputs.size(); ++i) {
            ingredients.add((JsonElement)this.serializeItemOrTag((ItemStack)inputs.get(i), i));
        }
        json.add("ingredients", (JsonElement)ingredients);
        json.add("result", (JsonElement)this.serializeResult(output));
        return new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
    }

    private String generateKubeJS() {
        this.updateCheckboxStates();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack output = ((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_();
        for (int i = 1; i < 10; ++i) {
            inputs.add(((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_());
        }
        StringBuilder script = new StringBuilder();
        if (!Screen.m_96637_()) {
            script.append("    ");
        }
        script.append("event.shaped(\n");
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        ResourceLocation outputId = ForgeRegistries.ITEMS.getKey((Object)output.m_41720_());
        script.append("    Item.of('").append(outputId).append("'");
        if (output.m_41613_() > 1) {
            script.append(", ").append(output.m_41613_());
        }
        script.append("),\n");
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        script.append("    [\n");
        char currentKey = 'A';
        HashMap<String, Character> itemToKey = new HashMap<String, Character>();
        HashMap<Character, String> keyToTagMap = new HashMap<Character, String>();
        boolean hasItems = false;
        for (int row = 0; row < 3; ++row) {
            if (!Screen.m_96637_()) {
                script.append("            ");
            }
            script.append("        '");
            for (int col = 0; col < 3; ++col) {
                ItemStack stack = (ItemStack)inputs.get(row * 3 + col);
                if (!stack.m_41619_()) {
                    ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    if (itemId != null) {
                        Object key = this.useTags && !this.tagInputs[row * 3 + col].m_94155_().isEmpty() ? "#" + this.tagInputs[row * 3 + col].m_94155_() : itemId.toString();
                        if (!itemToKey.containsKey(key)) {
                            itemToKey.put((String)key, Character.valueOf(currentKey));
                            if (((String)key).startsWith("#")) {
                                keyToTagMap.put(Character.valueOf(currentKey), ((String)key).substring(1));
                            }
                            currentKey = (char)(currentKey + '\u0001');
                        }
                        script.append(itemToKey.get(key));
                        hasItems = true;
                        continue;
                    }
                    script.append(" ");
                    continue;
                }
                script.append(" ");
            }
            if (hasItems) {
                script.append(row < 2 ? "',\n" : "'\n");
                continue;
            }
            if (row < 2) {
                script.append("',\n");
                continue;
            }
            script.append("'\n");
        }
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        script.append("    ],\n");
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        script.append("    {\n");
        boolean first = true;
        for (Map.Entry entry : itemToKey.entrySet()) {
            if (!first) {
                script.append(",\n");
            }
            if (!Screen.m_96637_()) {
                script.append("            ");
            }
            String value = (String)entry.getKey();
            script.append("        ").append(entry.getValue()).append(": '");
            if (value.startsWith("#")) {
                script.append("#").append((String)keyToTagMap.get(entry.getValue()));
            } else {
                script.append(value);
            }
            script.append("'");
            first = false;
        }
        script.append("\n");
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        script.append("    }");
        if (this.isFixed) {
            script.append(",\n");
            if (!Screen.m_96637_()) {
                script.append("        ");
            }
            script.append("    { fixed: true }");
        }
        script.append("\n");
        if (!Screen.m_96637_()) {
            script.append("    ");
        }
        script.append(")");
        return script.toString();
    }

    private String generateShapelessKubeJS() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack output = ((CraftingJsonMenu)this.f_97732_).m_38853_(0).m_7993_();
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = ((CraftingJsonMenu)this.f_97732_).m_38853_(i).m_7993_();
            if (stack.m_41619_()) continue;
            inputs.add(stack);
        }
        StringBuilder script = new StringBuilder();
        if (!Screen.m_96637_()) {
            script.append("    ");
        }
        script.append("event.shapeless(\n");
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        ResourceLocation outputId = ForgeRegistries.ITEMS.getKey((Object)output.m_41720_());
        script.append("    Item.of('").append(outputId).append("'");
        if (output.m_41613_() > 1) {
            script.append(", ").append(output.m_41613_());
        }
        script.append("),\n");
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        script.append("    [\n");
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack input = (ItemStack)inputs.get(i);
            if (!Screen.m_96637_()) {
                script.append("            ");
            }
            if (this.useTags && !this.tagInputs[i].m_94155_().isEmpty()) {
                script.append("        '#").append(this.tagInputs[i].m_94155_()).append("'");
            } else {
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)input.m_41720_());
                script.append("        '").append(itemId).append("'");
            }
            if (input.m_41613_() > 1) {
                script.append(", ").append(input.m_41613_());
            }
            if (i < inputs.size() - 1) {
                script.append(",");
            }
            script.append("\n");
        }
        if (!Screen.m_96637_()) {
            script.append("        ");
        }
        script.append("    ]");
        if (this.isFixed) {
            script.append(",\n");
            if (!Screen.m_96637_()) {
                script.append("        ");
            }
            script.append("    { fixed: true }");
        }
        script.append("\n");
        if (!Screen.m_96637_()) {
            script.append("    ");
        }
        script.append(")");
        return script.toString();
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        GuiEventListener guiEventListener;
        boolean anyFocused = false;
        for (EditBox tagInput : this.tagInputs) {
            if (!tagInput.m_93696_()) continue;
            anyFocused = true;
            break;
        }
        if (anyFocused && (guiEventListener = this.m_7222_()) instanceof EditBox) {
            EditBox editBox = (EditBox)guiEventListener;
            editBox.m_7933_(keyCode, scanCode, modifiers);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (EditBox tagInput : this.tagInputs) {
            if (tagInput.m_5953_(mouseX, mouseY) || !tagInput.m_93696_()) continue;
            tagInput.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

