/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.notickvd.mixin;

import com.ishland.c2me.notickvd.common.IChunkTicketManager;
import com.ishland.c2me.notickvd.common.NoOPTickingMap;
import com.ishland.c2me.notickvd.common.NoTickSystem;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TickingTracker;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DistanceManager.class})
public class MixinChunkTicketManager
implements IChunkTicketManager {
    @Shadow
    private long f_140771_;
    @Mutable
    @Shadow
    @Final
    private TickingTracker f_183901_;
    @Shadow
    @Final
    private DistanceManager.PlayerTicketTracker f_140764_;
    @Unique
    private NoTickSystem noTickSystem;
    @Unique
    private long lastNoTickSystemTick = -1L;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.noTickSystem = new NoTickSystem((DistanceManager)this);
        this.f_183901_ = new NoOPTickingMap();
    }

    @Inject(method={"handleChunkEnter"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$DistanceFromNearestPlayerTracker;updateLevel(JIZ)V", ordinal=0, shift=At.Shift.AFTER)})
    private void onHandleChunkEnter(SectionPos pos, ServerPlayer player, CallbackInfo ci) {
        this.noTickSystem.addPlayerSource(pos.m_123251_());
    }

    @Inject(method={"handleChunkLeave"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ChunkTicketManager$DistanceFromNearestPlayerTracker;updateLevel(JIZ)V", ordinal=0, shift=At.Shift.AFTER)})
    private void onHandleChunkLeave(SectionPos pos, ServerPlayer player, CallbackInfo ci) {
        this.noTickSystem.removePlayerSource(pos.m_123251_());
    }

    @Inject(method={"purge"}, at={@At(value="RETURN")})
    private void onPurge(CallbackInfo ci) {
        this.noTickSystem.runPurge(this.f_140771_);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void beforeTick(ChunkMap chunkStorage, CallbackInfoReturnable<Boolean> cir) {
        this.noTickSystem.beforeTicketTicks();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(ChunkMap chunkStorage, CallbackInfoReturnable<Boolean> cir) {
        TickingTracker tickingTracker = this.f_183901_;
        if (tickingTracker instanceof NoOPTickingMap) {
            NoOPTickingMap map = (NoOPTickingMap)tickingTracker;
            map.setTACS(chunkStorage);
        }
        this.noTickSystem.tickScheduler();
        this.noTickSystem.afterTicketTicks();
        if (this.lastNoTickSystemTick != this.f_140771_) {
            this.noTickSystem.tick(chunkStorage);
            this.lastNoTickSystemTick = this.f_140771_;
        }
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="RETURN")})
    private void onAddTicket(long position, Ticket<?> ticket, CallbackInfo ci) {
        this.noTickSystem.onTicketAdded(position, ticket);
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/world/ChunkTicket;)V"}, at={@At(value="RETURN")})
    private void onRemoveTicket(long pos, Ticket<?> ticket, CallbackInfo ci) {
        this.noTickSystem.onTicketRemoved(pos, ticket);
    }

    @Overwrite
    public void m_183911_(int i) {
        this.f_140764_.m_140912_(i);
    }

    @Overwrite
    public void m_140777_(int viewDistance) {
        this.noTickSystem.setNoTickViewDistance(viewDistance);
    }

    @Override
    @Unique
    public LongSet getNoTickOnlyChunks() {
        return this.noTickSystem.getNoTickOnlyChunksSnapshot();
    }

    @Override
    @Unique
    public int getNoTickPendingTicketUpdates() {
        return this.noTickSystem.getPendingNoTickTicketUpdatesCount();
    }
}

